<style>
	.debug-tool {
		position: fixed;
		margin: 10px;
		z-index: 1000000;
	}

	.debug-tool .content {
		position: fixed;
		top: 15px;
		bottom: 15px;
		left: 15px;
		right: 15px;
		border: 1px solid black;
		border-radius: 10px;
		padding: 10px;
		background: white;
		overflow: auto;
	}

	.debug-tool .overlay {
		position: fixed;
		top: 0;
		bottom: 0;
		left: 0;
		right: 0;
		background: black;
		opacity: 0.6;
	}

	.debug-tool > button .count-preview {
		border: 1px solid #444;
		border-radius: 3px;
	}

	.debug-tool > button .count-preview.errors {
		background: #C9162B;
		color: white;
	}

	.debug-tool > button .count-preview.warnings {
		background: #EDE61A;
		color: black;
	}

	.debug-tool .content > ul > li {
		margin: 10px;
	}

	.debug-tool ul ol {
		margin-left: 20px;
	}

	.debug-tool ul ol li {
		padding: 5px;
		border-bottom: 1px solid #ccc;
	}

	.debug-tool ul ol li.last {
		border-bottom: none;
	}

	.debug-tool ul ol li:hover {
		background: lightblue;
	}
</style>

|-function name="debugToolItemsList" items="null" title="Items" noItemsText="No items"-|
	<strong>|-if count($items) gt 0-||-$title-||-else-||-$noItemsText-||-/if-|</strong>
	<ol>
		|-foreach $items as $item-|
			<li |-if $item@last-|class="last"|-/if-|>
				<pre>|-$item-|</pre>
			</li>
		|-/foreach-|
	</ol>
|-/function-|

<template id="debugToolContent">
	<div class="overlay" onclick="closeDebugTool(this.parentNode);"></div>
	<div class="content">
		<button onclick="closeDebugTool(this.parentNode.parentNode);">Close</button>
		<ul>
			|-foreach $debugData->getAll() as $name => $data-|
				|-if $name neq 'errors' && $name neq 'warnings'-|
					<li>
						<p>
							<strong>|-$name-|</strong>
						</p>
						<p>
							<pre>|-print_r($data, true)-|</pre>
						</p>
					</li>
				|-/if-|
			|-foreachelse-|
				<li>No debug data.</li>
			|-/foreach-|
			<li>
				|-debugToolItemsList items=$debugData->get('errors')->getAll()
					title="Errors" noItemsText="No errors"-|
			</li>
			<li>
				|-debugToolItemsList items=$debugData->get('warnings')->getAll()
					title="Warnings" noItemsText="No warnings"-|
			</li>
		</ul>
	</div>
</template>

<template id="debugToolTrigger">
	<button onclick="openDebugTool(this.parentNode)">
		Open Debug Tool
		|-$errorsCount = $debugData->get('errors')->count()-|
		|-$warningsCount = $debugData->get('warnings')->count()-|
		|-if $errorsCount > 0-|
			<span class="count-preview errors">|-$errorsCount-|</span>
		|-/if-|
		|-if $warningsCount > 0-|
			<span class="count-preview warnings">|-$warningsCount-|</span>
		|-/if-|
	</button>
</template>

<div class="debug-tool"></div>

<script>
	var openDebugTool = function(debugToolBox) {
		var template = document.querySelector('#debugToolContent');
		debugToolBox.innerHTML = '';
		debugToolBox.appendChild(document.importNode(template.content, true));
	};

	var closeDebugTool = function(debugToolBox) {
		var template = document.querySelector('#debugToolTrigger');
		debugToolBox.innerHTML = '';
		debugToolBox.appendChild(document.importNode(template.content, true));
	};

	closeDebugTool(document.querySelector('.debug-tool'));
</script>