<script>
	var egytcaFilters = angular.module('egytcaFilters', []);

	egytcaFilters.filter('system_date_format', ['$filter',
		function($filter) {
			return function(dateString) {
				var date = new Date(dateString);
				var format = '|-$egytca.angularDateFormat-|';
				return $filter('date')(date, format);
			}
		}
	]);

	egytcaFilters.filter('system_numeric_format',
		function() {
			return function(number, decimals) {

				var decimalSeparator = ',';
				var thousandsSeparator = '.';

				if (decimals === undefined)
					decimals = 2;

				number = '' + number.toFixed(decimals);

				var parts = number.split('.');
				var integerPart = parts[0];
				var decimalPart = parts.length > 1 ? (decimalSeparator + parts[1]) : '';

				var rgx = /(\d+)(\d{3})/;
				while (rgx.test(integerPart)) {
					integerPart = integerPart.replace(rgx, '$1' + thousandsSeparator + '$2');
				}

				return integerPart + decimalPart;
			}
		}
	);
</script>