<?php

require_once 'builder/om/QueryBuilder.php';

class CustomParentQueryBuilder extends QueryBuilder {

	protected function addClassOpen(&$script) {
		parent::addClassOpen($script);
		$parentClass = $this->getParentClass();
		if ($parentClass) {
			$script = preg_replace("/extends ModelCriteria(\b)/", "extends $parentClass$1", $script);
		}
	}

	protected function getParentClass() {

		$behaviorParentClass = $this->getBehaviorContent('parentClass');
		if ($behaviorParentClass) {
			return $behaviorParentClass;
		}

		$parentClass = $this->getBuildProperty('parentQuery');
		if ($parentClass) {
			return $parentClass;
		}

		return null;
	}
}
