<?php


/**
 * Base class that represents a row from the 'positions_position' table.
 *
 * Cargos
 *
 * @package    propel.generator.positions.classes.om
 */
abstract class BasePosition extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'PositionPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        PositionPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     * @var        string
     */
    protected $name;

    /**
     * The value for the code field.
     * @var        int
     */
    protected $code;

    /**
     * The value for the usergroupid field.
     * @var        int
     */
    protected $usergroupid;

    /**
     * The value for the versionid field.
     * @var        int
     */
    protected $versionid;

    /**
     * The value for the internalcode field.
     * @var        string
     */
    protected $internalcode;

    /**
     * The value for the ownername field.
     * @var        string
     */
    protected $ownername;

    /**
     * The value for the ownernamefemale field.
     * @var        string
     */
    protected $ownernamefemale;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the kind field.
     * Note: this column has a database default value of: 'hierarchical'
     * @var        string
     */
    protected $kind;

    /**
     * The value for the address field.
     * @var        string
     */
    protected $address;

    /**
     * The value for the telephone field.
     * @var        string
     */
    protected $telephone;

    /**
     * The value for the email field.
     * @var        string
     */
    protected $email;

    /**
     * The value for the budget field.
     * Note: this column has a database default value of: 0
     * @var        double
     */
    protected $budget;

    /**
     * The value for the personnel field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $personnel;

    /**
     * The value for the hired field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $hired;

    /**
     * The value for the consultant field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $consultant;

    /**
     * The value for the other field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $other;

    /**
     * The value for the planning field.
     * @var        boolean
     */
    protected $planning;

    /**
     * The value for the order field.
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $order;

    /**
     * The value for the tree_left field.
     * @var        int
     */
    protected $tree_left;

    /**
     * The value for the tree_right field.
     * @var        int
     */
    protected $tree_right;

    /**
     * The value for the tree_level field.
     * @var        int
     */
    protected $tree_level;

    /**
     * @var        Group
     */
    protected $aGroup;

    /**
     * @var        PositionVersion
     */
    protected $aPositionVersion;

    /**
     * @var        PropelObjectCollection|Indicator[] Collection to store aggregation of Indicator objects.
     */
    protected $collIndicators;
    protected $collIndicatorsPartial;

    /**
     * @var        PropelObjectCollection|Objective[] Collection to store aggregation of Objective objects.
     */
    protected $collObjectives;
    protected $collObjectivesPartial;

    /**
     * @var        PropelObjectCollection|ObjectiveLog[] Collection to store aggregation of ObjectiveLog objects.
     */
    protected $collObjectiveLogs;
    protected $collObjectiveLogsPartial;

    /**
     * @var        PropelObjectCollection|PositionTenure[] Collection to store aggregation of PositionTenure objects.
     */
    protected $collPositionTenures;
    protected $collPositionTenuresPartial;

    /**
     * @var        PropelObjectCollection|PositionDocument[] Collection to store aggregation of PositionDocument objects.
     */
    protected $collPositionDocuments;
    protected $collPositionDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Project[] Collection to store aggregation of Project objects.
     */
    protected $collProjects;
    protected $collProjectsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivity[] Collection to store aggregation of ProjectActivity objects.
     */
    protected $collProjectActivitys;
    protected $collProjectActivitysPartial;

    /**
     * @var        PropelObjectCollection|ProjectLog[] Collection to store aggregation of ProjectLog objects.
     */
    protected $collProjectLogs;
    protected $collProjectLogsPartial;

    /**
     * @var        PropelObjectCollection|ProjectActivityLog[] Collection to store aggregation of ProjectActivityLog objects.
     */
    protected $collProjectActivityLogs;
    protected $collProjectActivityLogsPartial;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    // nested_set behavior

    /**
     * Queries to be executed in the save transaction
     * @var        array
     */
    protected $nestedSetQueries = array();

    /**
     * Internal cache for children nodes
     * @var        null|PropelObjectCollection
     */
    protected $collNestedSetChildren = null;

    /**
     * Internal cache for parent node
     * @var        null|Position
     */
    protected $aNestedSetParent = null;


    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $indicatorsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectivesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $objectiveLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $positionTenuresScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $positionDocumentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivitysScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectLogsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $projectActivityLogsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see        __construct()
     */
    public function applyDefaultValues()
    {
        $this->kind = 'hierarchical';
        $this->budget = 0;
        $this->personnel = 0;
        $this->hired = 0;
        $this->consultant = 0;
        $this->other = 0;
        $this->order = 0;
    }

    /**
     * Initializes internal state of BasePosition object.
     * @see        applyDefaults()
     */
    public function __construct()
    {
        parent::__construct();
        $this->applyDefaultValues();
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     * Position Name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [code] column value.
     * Codigo del cargo, usado para poder generar nuevas versiones del mismo cargo, el cual mantiene el code pero genera una nueva version
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Get the [usergroupid] column value.
     * Id del grupo de usuarios con acceso a los datos de la position
     * @return int
     */
    public function getUsergroupid()
    {
        return $this->usergroupid;
    }

    /**
     * Get the [versionid] column value.
     * Version
     * @return int
     */
    public function getVersionid()
    {
        return $this->versionid;
    }

    /**
     * Get the [internalcode] column value.
     * Codigo del cargo
     * @return string
     */
    public function getInternalcode()
    {
        return $this->internalcode;
    }

    /**
     * Get the [ownername] column value.
     * Titulo de la persona que ocupa el cargo (Presidente)
     * @return string
     */
    public function getOwnername()
    {
        return $this->ownername;
    }

    /**
     * Get the [ownernamefemale] column value.
     * Titulo de la persona que ocupa el cargo en femenino
     * @return string
     */
    public function getOwnernamefemale()
    {
        return $this->ownernamefemale;
    }

    /**
     * Get the [type] column value.
     *
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [kind] column value.
     *
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Get the [address] column value.
     * Address
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Get the [telephone] column value.
     * Telephone
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Get the [email] column value.
     * e-mail
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [budget] column value.
     * Budget (Presupuesto)
     * @return double
     */
    public function getBudget()
    {
        return $this->budget;
    }

    /**
     * Get the [personnel] column value.
     * Planta permanente
     * @return int
     */
    public function getPersonnel()
    {
        return $this->personnel;
    }

    /**
     * Get the [hired] column value.
     * Contratados
     * @return int
     */
    public function getHired()
    {
        return $this->hired;
    }

    /**
     * Get the [consultant] column value.
     * Asesores
     * @return int
     */
    public function getConsultant()
    {
        return $this->consultant;
    }

    /**
     * Get the [other] column value.
     * Otros
     * @return int
     */
    public function getOther()
    {
        return $this->other;
    }

    /**
     * Get the [planning] column value.
     * Indica si va a inicio de planificacion
     * @return boolean
     */
    public function getPlanning()
    {
        return $this->planning;
    }

    /**
     * Get the [order] column value.
     * Orden de aparicion en home
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * Get the [tree_left] column value.
     *
     * @return int
     */
    public function getTreeLeft()
    {
        return $this->tree_left;
    }

    /**
     * Get the [tree_right] column value.
     *
     * @return int
     */
    public function getTreeRight()
    {
        return $this->tree_right;
    }

    /**
     * Get the [tree_level] column value.
     *
     * @return int
     */
    public function getTreeLevel()
    {
        return $this->tree_level;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = PositionPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [name] column.
     * Position Name
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[] = PositionPeer::NAME;
        }


        return $this;
    } // setName()

    /**
     * Set the value of [code] column.
     * Codigo del cargo, usado para poder generar nuevas versiones del mismo cargo, el cual mantiene el code pero genera una nueva version
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setCode($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->code !== $v) {
            $this->code = $v;
            $this->modifiedColumns[] = PositionPeer::CODE;
        }


        return $this;
    } // setCode()

    /**
     * Set the value of [usergroupid] column.
     * Id del grupo de usuarios con acceso a los datos de la position
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setUsergroupid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->usergroupid !== $v) {
            $this->usergroupid = $v;
            $this->modifiedColumns[] = PositionPeer::USERGROUPID;
        }

        if ($this->aGroup !== null && $this->aGroup->getId() !== $v) {
            $this->aGroup = null;
        }


        return $this;
    } // setUsergroupid()

    /**
     * Set the value of [versionid] column.
     * Version
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setVersionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->versionid !== $v) {
            $this->versionid = $v;
            $this->modifiedColumns[] = PositionPeer::VERSIONID;
        }

        if ($this->aPositionVersion !== null && $this->aPositionVersion->getId() !== $v) {
            $this->aPositionVersion = null;
        }


        return $this;
    } // setVersionid()

    /**
     * Set the value of [internalcode] column.
     * Codigo del cargo
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setInternalcode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->internalcode !== $v) {
            $this->internalcode = $v;
            $this->modifiedColumns[] = PositionPeer::INTERNALCODE;
        }


        return $this;
    } // setInternalcode()

    /**
     * Set the value of [ownername] column.
     * Titulo de la persona que ocupa el cargo (Presidente)
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setOwnername($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ownername !== $v) {
            $this->ownername = $v;
            $this->modifiedColumns[] = PositionPeer::OWNERNAME;
        }


        return $this;
    } // setOwnername()

    /**
     * Set the value of [ownernamefemale] column.
     * Titulo de la persona que ocupa el cargo en femenino
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setOwnernamefemale($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ownernamefemale !== $v) {
            $this->ownernamefemale = $v;
            $this->modifiedColumns[] = PositionPeer::OWNERNAMEFEMALE;
        }


        return $this;
    } // setOwnernamefemale()

    /**
     * Set the value of [type] column.
     *
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = PositionPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Set the value of [kind] column.
     *
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setKind($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->kind !== $v) {
            $this->kind = $v;
            $this->modifiedColumns[] = PositionPeer::KIND;
        }


        return $this;
    } // setKind()

    /**
     * Set the value of [address] column.
     * Address
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setAddress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->address !== $v) {
            $this->address = $v;
            $this->modifiedColumns[] = PositionPeer::ADDRESS;
        }


        return $this;
    } // setAddress()

    /**
     * Set the value of [telephone] column.
     * Telephone
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setTelephone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->telephone !== $v) {
            $this->telephone = $v;
            $this->modifiedColumns[] = PositionPeer::TELEPHONE;
        }


        return $this;
    } // setTelephone()

    /**
     * Set the value of [email] column.
     * e-mail
     * @param string $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[] = PositionPeer::EMAIL;
        }


        return $this;
    } // setEmail()

    /**
     * Set the value of [budget] column.
     * Budget (Presupuesto)
     * @param double $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setBudget($v)
    {
        if ($v !== null) {
            $v = (double) $v;
        }

        if ($this->budget !== $v) {
            $this->budget = $v;
            $this->modifiedColumns[] = PositionPeer::BUDGET;
        }


        return $this;
    } // setBudget()

    /**
     * Set the value of [personnel] column.
     * Planta permanente
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setPersonnel($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->personnel !== $v) {
            $this->personnel = $v;
            $this->modifiedColumns[] = PositionPeer::PERSONNEL;
        }


        return $this;
    } // setPersonnel()

    /**
     * Set the value of [hired] column.
     * Contratados
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setHired($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->hired !== $v) {
            $this->hired = $v;
            $this->modifiedColumns[] = PositionPeer::HIRED;
        }


        return $this;
    } // setHired()

    /**
     * Set the value of [consultant] column.
     * Asesores
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setConsultant($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->consultant !== $v) {
            $this->consultant = $v;
            $this->modifiedColumns[] = PositionPeer::CONSULTANT;
        }


        return $this;
    } // setConsultant()

    /**
     * Set the value of [other] column.
     * Otros
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setOther($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->other !== $v) {
            $this->other = $v;
            $this->modifiedColumns[] = PositionPeer::OTHER;
        }


        return $this;
    } // setOther()

    /**
     * Sets the value of the [planning] column.
     * Non-boolean arguments are converted using the following rules:
     *   * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *   * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     * Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * Indica si va a inicio de planificacion
     * @param boolean|integer|string $v The new value
     * @return Position The current object (for fluent API support)
     */
    public function setPlanning($v)
    {
        if ($v !== null) {
            if (is_string($v)) {
                $v = in_array(strtolower($v), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
            } else {
                $v = (boolean) $v;
            }
        }

        if ($this->planning !== $v) {
            $this->planning = $v;
            $this->modifiedColumns[] = PositionPeer::PLANNING;
        }


        return $this;
    } // setPlanning()

    /**
     * Set the value of [order] column.
     * Orden de aparicion en home
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setOrder($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->order !== $v) {
            $this->order = $v;
            $this->modifiedColumns[] = PositionPeer::ORDER;
        }


        return $this;
    } // setOrder()

    /**
     * Set the value of [tree_left] column.
     *
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setTreeLeft($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_left !== $v) {
            $this->tree_left = $v;
            $this->modifiedColumns[] = PositionPeer::TREE_LEFT;
        }


        return $this;
    } // setTreeLeft()

    /**
     * Set the value of [tree_right] column.
     *
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setTreeRight($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_right !== $v) {
            $this->tree_right = $v;
            $this->modifiedColumns[] = PositionPeer::TREE_RIGHT;
        }


        return $this;
    } // setTreeRight()

    /**
     * Set the value of [tree_level] column.
     *
     * @param int $v new value
     * @return Position The current object (for fluent API support)
     */
    public function setTreeLevel($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->tree_level !== $v) {
            $this->tree_level = $v;
            $this->modifiedColumns[] = PositionPeer::TREE_LEVEL;
        }


        return $this;
    } // setTreeLevel()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->kind !== 'hierarchical') {
                return false;
            }

            if ($this->budget !== 0) {
                return false;
            }

            if ($this->personnel !== 0) {
                return false;
            }

            if ($this->hired !== 0) {
                return false;
            }

            if ($this->consultant !== 0) {
                return false;
            }

            if ($this->other !== 0) {
                return false;
            }

            if ($this->order !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->name = ($row[$startcol + 1] !== null) ? (string) $row[$startcol + 1] : null;
            $this->code = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->usergroupid = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->versionid = ($row[$startcol + 4] !== null) ? (int) $row[$startcol + 4] : null;
            $this->internalcode = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->ownername = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->ownernamefemale = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->type = ($row[$startcol + 8] !== null) ? (int) $row[$startcol + 8] : null;
            $this->kind = ($row[$startcol + 9] !== null) ? (string) $row[$startcol + 9] : null;
            $this->address = ($row[$startcol + 10] !== null) ? (string) $row[$startcol + 10] : null;
            $this->telephone = ($row[$startcol + 11] !== null) ? (string) $row[$startcol + 11] : null;
            $this->email = ($row[$startcol + 12] !== null) ? (string) $row[$startcol + 12] : null;
            $this->budget = ($row[$startcol + 13] !== null) ? (double) $row[$startcol + 13] : null;
            $this->personnel = ($row[$startcol + 14] !== null) ? (int) $row[$startcol + 14] : null;
            $this->hired = ($row[$startcol + 15] !== null) ? (int) $row[$startcol + 15] : null;
            $this->consultant = ($row[$startcol + 16] !== null) ? (int) $row[$startcol + 16] : null;
            $this->other = ($row[$startcol + 17] !== null) ? (int) $row[$startcol + 17] : null;
            $this->planning = ($row[$startcol + 18] !== null) ? (boolean) $row[$startcol + 18] : null;
            $this->order = ($row[$startcol + 19] !== null) ? (int) $row[$startcol + 19] : null;
            $this->tree_left = ($row[$startcol + 20] !== null) ? (int) $row[$startcol + 20] : null;
            $this->tree_right = ($row[$startcol + 21] !== null) ? (int) $row[$startcol + 21] : null;
            $this->tree_level = ($row[$startcol + 22] !== null) ? (int) $row[$startcol + 22] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 23; // 23 = PositionPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Position object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aGroup !== null && $this->usergroupid !== $this->aGroup->getId()) {
            $this->aGroup = null;
        }
        if ($this->aPositionVersion !== null && $this->versionid !== $this->aPositionVersion->getId()) {
            $this->aPositionVersion = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = PositionPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aGroup = null;
            $this->aPositionVersion = null;
            $this->collIndicators = null;

            $this->collObjectives = null;

            $this->collObjectiveLogs = null;

            $this->collPositionTenures = null;

            $this->collPositionDocuments = null;

            $this->collProjects = null;

            $this->collProjectActivitys = null;

            $this->collProjectLogs = null;

            $this->collProjectActivityLogs = null;

            $this->collDocuments = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = PositionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // nested_set behavior
            if ($this->isRoot()) {
                throw new PropelException('Deletion of a root node is disabled for nested sets. Use PositionPeer::deleteTree($scope) instead to delete an entire tree');
            }

            if ($this->isInTree()) {
                $this->deleteDescendants($con);
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                // nested_set behavior
                if ($this->isInTree()) {
                    // fill up the room that was used by the node
                    PositionPeer::shiftRLValues(-2, $this->getRightValue() + 1, null, $this->getScopeValue(), $con);
                }

                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            // nested_set behavior
            if ($this->isNew() && $this->isRoot()) {
                // check if no other root exist in, the tree
                $nbRoots = PositionQuery::create()
                    ->addUsingAlias(PositionPeer::LEFT_COL, 1, Criteria::EQUAL)
                    ->addUsingAlias(PositionPeer::SCOPE_COL, $this->getScopeValue(), Criteria::EQUAL)
                    ->count($con);
                if ($nbRoots > 0) {
                        throw new PropelException(sprintf('A root node already exists in this tree with scope "%s".', $this->getScopeValue()));
                }
            }
            $this->processNestedSetQueries($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                PositionPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aGroup !== null) {
                if ($this->aGroup->isModified() || $this->aGroup->isNew()) {
                    $affectedRows += $this->aGroup->save($con);
                }
                $this->setGroup($this->aGroup);
            }

            if ($this->aPositionVersion !== null) {
                if ($this->aPositionVersion->isModified() || $this->aPositionVersion->isNew()) {
                    $affectedRows += $this->aPositionVersion->save($con);
                }
                $this->setPositionVersion($this->aPositionVersion);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    PositionDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->indicatorsScheduledForDeletion !== null) {
                if (!$this->indicatorsScheduledForDeletion->isEmpty()) {
                    foreach ($this->indicatorsScheduledForDeletion as $indicator) {
                        // need to save related object because we set the relation to null
                        $indicator->save($con);
                    }
                    $this->indicatorsScheduledForDeletion = null;
                }
            }

            if ($this->collIndicators !== null) {
                foreach ($this->collIndicators as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectivesScheduledForDeletion !== null) {
                if (!$this->objectivesScheduledForDeletion->isEmpty()) {
                    foreach ($this->objectivesScheduledForDeletion as $objective) {
                        // need to save related object because we set the relation to null
                        $objective->save($con);
                    }
                    $this->objectivesScheduledForDeletion = null;
                }
            }

            if ($this->collObjectives !== null) {
                foreach ($this->collObjectives as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->objectiveLogsScheduledForDeletion !== null) {
                if (!$this->objectiveLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLog) {
                        // need to save related object because we set the relation to null
                        $objectiveLog->save($con);
                    }
                    $this->objectiveLogsScheduledForDeletion = null;
                }
            }

            if ($this->collObjectiveLogs !== null) {
                foreach ($this->collObjectiveLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->positionTenuresScheduledForDeletion !== null) {
                if (!$this->positionTenuresScheduledForDeletion->isEmpty()) {
                    PositionTenureQuery::create()
                        ->filterByPrimaryKeys($this->positionTenuresScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->positionTenuresScheduledForDeletion = null;
                }
            }

            if ($this->collPositionTenures !== null) {
                foreach ($this->collPositionTenures as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->positionDocumentsScheduledForDeletion !== null) {
                if (!$this->positionDocumentsScheduledForDeletion->isEmpty()) {
                    PositionDocumentQuery::create()
                        ->filterByPrimaryKeys($this->positionDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->positionDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collPositionDocuments !== null) {
                foreach ($this->collPositionDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectsScheduledForDeletion !== null) {
                if (!$this->projectsScheduledForDeletion->isEmpty()) {
                    ProjectQuery::create()
                        ->filterByPrimaryKeys($this->projectsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->projectsScheduledForDeletion = null;
                }
            }

            if ($this->collProjects !== null) {
                foreach ($this->collProjects as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivitysScheduledForDeletion !== null) {
                if (!$this->projectActivitysScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectActivitysScheduledForDeletion as $projectActivity) {
                        // need to save related object because we set the relation to null
                        $projectActivity->save($con);
                    }
                    $this->projectActivitysScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivitys !== null) {
                foreach ($this->collProjectActivitys as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectLogsScheduledForDeletion !== null) {
                if (!$this->projectLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectLogsScheduledForDeletion as $projectLog) {
                        // need to save related object because we set the relation to null
                        $projectLog->save($con);
                    }
                    $this->projectLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectLogs !== null) {
                foreach ($this->collProjectLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->projectActivityLogsScheduledForDeletion !== null) {
                if (!$this->projectActivityLogsScheduledForDeletion->isEmpty()) {
                    foreach ($this->projectActivityLogsScheduledForDeletion as $projectActivityLog) {
                        // need to save related object because we set the relation to null
                        $projectActivityLog->save($con);
                    }
                    $this->projectActivityLogsScheduledForDeletion = null;
                }
            }

            if ($this->collProjectActivityLogs !== null) {
                foreach ($this->collProjectActivityLogs as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = PositionPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . PositionPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(PositionPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(PositionPeer::NAME)) {
            $modifiedColumns[':p' . $index++]  = '`NAME`';
        }
        if ($this->isColumnModified(PositionPeer::CODE)) {
            $modifiedColumns[':p' . $index++]  = '`CODE`';
        }
        if ($this->isColumnModified(PositionPeer::USERGROUPID)) {
            $modifiedColumns[':p' . $index++]  = '`USERGROUPID`';
        }
        if ($this->isColumnModified(PositionPeer::VERSIONID)) {
            $modifiedColumns[':p' . $index++]  = '`VERSIONID`';
        }
        if ($this->isColumnModified(PositionPeer::INTERNALCODE)) {
            $modifiedColumns[':p' . $index++]  = '`INTERNALCODE`';
        }
        if ($this->isColumnModified(PositionPeer::OWNERNAME)) {
            $modifiedColumns[':p' . $index++]  = '`OWNERNAME`';
        }
        if ($this->isColumnModified(PositionPeer::OWNERNAMEFEMALE)) {
            $modifiedColumns[':p' . $index++]  = '`OWNERNAMEFEMALE`';
        }
        if ($this->isColumnModified(PositionPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(PositionPeer::KIND)) {
            $modifiedColumns[':p' . $index++]  = '`KIND`';
        }
        if ($this->isColumnModified(PositionPeer::ADDRESS)) {
            $modifiedColumns[':p' . $index++]  = '`ADDRESS`';
        }
        if ($this->isColumnModified(PositionPeer::TELEPHONE)) {
            $modifiedColumns[':p' . $index++]  = '`TELEPHONE`';
        }
        if ($this->isColumnModified(PositionPeer::EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`EMAIL`';
        }
        if ($this->isColumnModified(PositionPeer::BUDGET)) {
            $modifiedColumns[':p' . $index++]  = '`BUDGET`';
        }
        if ($this->isColumnModified(PositionPeer::PERSONNEL)) {
            $modifiedColumns[':p' . $index++]  = '`PERSONNEL`';
        }
        if ($this->isColumnModified(PositionPeer::HIRED)) {
            $modifiedColumns[':p' . $index++]  = '`HIRED`';
        }
        if ($this->isColumnModified(PositionPeer::CONSULTANT)) {
            $modifiedColumns[':p' . $index++]  = '`CONSULTANT`';
        }
        if ($this->isColumnModified(PositionPeer::OTHER)) {
            $modifiedColumns[':p' . $index++]  = '`OTHER`';
        }
        if ($this->isColumnModified(PositionPeer::PLANNING)) {
            $modifiedColumns[':p' . $index++]  = '`PLANNING`';
        }
        if ($this->isColumnModified(PositionPeer::ORDER)) {
            $modifiedColumns[':p' . $index++]  = '`ORDER`';
        }
        if ($this->isColumnModified(PositionPeer::TREE_LEFT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEFT`';
        }
        if ($this->isColumnModified(PositionPeer::TREE_RIGHT)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_RIGHT`';
        }
        if ($this->isColumnModified(PositionPeer::TREE_LEVEL)) {
            $modifiedColumns[':p' . $index++]  = '`TREE_LEVEL`';
        }

        $sql = sprintf(
            'INSERT INTO `positions_position` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`NAME`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`CODE`':
                        $stmt->bindValue($identifier, $this->code, PDO::PARAM_INT);
                        break;
                    case '`USERGROUPID`':
                        $stmt->bindValue($identifier, $this->usergroupid, PDO::PARAM_INT);
                        break;
                    case '`VERSIONID`':
                        $stmt->bindValue($identifier, $this->versionid, PDO::PARAM_INT);
                        break;
                    case '`INTERNALCODE`':
                        $stmt->bindValue($identifier, $this->internalcode, PDO::PARAM_STR);
                        break;
                    case '`OWNERNAME`':
                        $stmt->bindValue($identifier, $this->ownername, PDO::PARAM_STR);
                        break;
                    case '`OWNERNAMEFEMALE`':
                        $stmt->bindValue($identifier, $this->ownernamefemale, PDO::PARAM_STR);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`KIND`':
                        $stmt->bindValue($identifier, $this->kind, PDO::PARAM_STR);
                        break;
                    case '`ADDRESS`':
                        $stmt->bindValue($identifier, $this->address, PDO::PARAM_STR);
                        break;
                    case '`TELEPHONE`':
                        $stmt->bindValue($identifier, $this->telephone, PDO::PARAM_STR);
                        break;
                    case '`EMAIL`':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case '`BUDGET`':
                        $stmt->bindValue($identifier, $this->budget, PDO::PARAM_STR);
                        break;
                    case '`PERSONNEL`':
                        $stmt->bindValue($identifier, $this->personnel, PDO::PARAM_INT);
                        break;
                    case '`HIRED`':
                        $stmt->bindValue($identifier, $this->hired, PDO::PARAM_INT);
                        break;
                    case '`CONSULTANT`':
                        $stmt->bindValue($identifier, $this->consultant, PDO::PARAM_INT);
                        break;
                    case '`OTHER`':
                        $stmt->bindValue($identifier, $this->other, PDO::PARAM_INT);
                        break;
                    case '`PLANNING`':
                        $stmt->bindValue($identifier, (int) $this->planning, PDO::PARAM_INT);
                        break;
                    case '`ORDER`':
                        $stmt->bindValue($identifier, $this->order, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEFT`':
                        $stmt->bindValue($identifier, $this->tree_left, PDO::PARAM_INT);
                        break;
                    case '`TREE_RIGHT`':
                        $stmt->bindValue($identifier, $this->tree_right, PDO::PARAM_INT);
                        break;
                    case '`TREE_LEVEL`':
                        $stmt->bindValue($identifier, $this->tree_level, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aGroup !== null) {
                if (!$this->aGroup->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aGroup->getValidationFailures());
                }
            }

            if ($this->aPositionVersion !== null) {
                if (!$this->aPositionVersion->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aPositionVersion->getValidationFailures());
                }
            }


            if (($retval = PositionPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collIndicators !== null) {
                    foreach ($this->collIndicators as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectives !== null) {
                    foreach ($this->collObjectives as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collObjectiveLogs !== null) {
                    foreach ($this->collObjectiveLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPositionTenures !== null) {
                    foreach ($this->collPositionTenures as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collPositionDocuments !== null) {
                    foreach ($this->collPositionDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjects !== null) {
                    foreach ($this->collProjects as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivitys !== null) {
                    foreach ($this->collProjectActivitys as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectLogs !== null) {
                    foreach ($this->collProjectLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collProjectActivityLogs !== null) {
                    foreach ($this->collProjectActivityLogs as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PositionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getName();
                break;
            case 2:
                return $this->getCode();
                break;
            case 3:
                return $this->getUsergroupid();
                break;
            case 4:
                return $this->getVersionid();
                break;
            case 5:
                return $this->getInternalcode();
                break;
            case 6:
                return $this->getOwnername();
                break;
            case 7:
                return $this->getOwnernamefemale();
                break;
            case 8:
                return $this->getType();
                break;
            case 9:
                return $this->getKind();
                break;
            case 10:
                return $this->getAddress();
                break;
            case 11:
                return $this->getTelephone();
                break;
            case 12:
                return $this->getEmail();
                break;
            case 13:
                return $this->getBudget();
                break;
            case 14:
                return $this->getPersonnel();
                break;
            case 15:
                return $this->getHired();
                break;
            case 16:
                return $this->getConsultant();
                break;
            case 17:
                return $this->getOther();
                break;
            case 18:
                return $this->getPlanning();
                break;
            case 19:
                return $this->getOrder();
                break;
            case 20:
                return $this->getTreeLeft();
                break;
            case 21:
                return $this->getTreeRight();
                break;
            case 22:
                return $this->getTreeLevel();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Position'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Position'][$this->getPrimaryKey()] = true;
        $keys = PositionPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getCode(),
            $keys[3] => $this->getUsergroupid(),
            $keys[4] => $this->getVersionid(),
            $keys[5] => $this->getInternalcode(),
            $keys[6] => $this->getOwnername(),
            $keys[7] => $this->getOwnernamefemale(),
            $keys[8] => $this->getType(),
            $keys[9] => $this->getKind(),
            $keys[10] => $this->getAddress(),
            $keys[11] => $this->getTelephone(),
            $keys[12] => $this->getEmail(),
            $keys[13] => $this->getBudget(),
            $keys[14] => $this->getPersonnel(),
            $keys[15] => $this->getHired(),
            $keys[16] => $this->getConsultant(),
            $keys[17] => $this->getOther(),
            $keys[18] => $this->getPlanning(),
            $keys[19] => $this->getOrder(),
            $keys[20] => $this->getTreeLeft(),
            $keys[21] => $this->getTreeRight(),
            $keys[22] => $this->getTreeLevel(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aGroup) {
                $result['Group'] = $this->aGroup->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPositionVersion) {
                $result['PositionVersion'] = $this->aPositionVersion->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collIndicators) {
                $result['Indicators'] = $this->collIndicators->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectives) {
                $result['Objectives'] = $this->collObjectives->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collObjectiveLogs) {
                $result['ObjectiveLogs'] = $this->collObjectiveLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPositionTenures) {
                $result['PositionTenures'] = $this->collPositionTenures->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPositionDocuments) {
                $result['PositionDocuments'] = $this->collPositionDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjects) {
                $result['Projects'] = $this->collProjects->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivitys) {
                $result['ProjectActivitys'] = $this->collProjectActivitys->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectLogs) {
                $result['ProjectLogs'] = $this->collProjectLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProjectActivityLogs) {
                $result['ProjectActivityLogs'] = $this->collProjectActivityLogs->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = PositionPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setCode($value);
                break;
            case 3:
                $this->setUsergroupid($value);
                break;
            case 4:
                $this->setVersionid($value);
                break;
            case 5:
                $this->setInternalcode($value);
                break;
            case 6:
                $this->setOwnername($value);
                break;
            case 7:
                $this->setOwnernamefemale($value);
                break;
            case 8:
                $this->setType($value);
                break;
            case 9:
                $this->setKind($value);
                break;
            case 10:
                $this->setAddress($value);
                break;
            case 11:
                $this->setTelephone($value);
                break;
            case 12:
                $this->setEmail($value);
                break;
            case 13:
                $this->setBudget($value);
                break;
            case 14:
                $this->setPersonnel($value);
                break;
            case 15:
                $this->setHired($value);
                break;
            case 16:
                $this->setConsultant($value);
                break;
            case 17:
                $this->setOther($value);
                break;
            case 18:
                $this->setPlanning($value);
                break;
            case 19:
                $this->setOrder($value);
                break;
            case 20:
                $this->setTreeLeft($value);
                break;
            case 21:
                $this->setTreeRight($value);
                break;
            case 22:
                $this->setTreeLevel($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = PositionPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setName($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setCode($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setUsergroupid($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setVersionid($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setInternalcode($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setOwnername($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setOwnernamefemale($arr[$keys[7]]);
        if (array_key_exists($keys[8], $arr)) $this->setType($arr[$keys[8]]);
        if (array_key_exists($keys[9], $arr)) $this->setKind($arr[$keys[9]]);
        if (array_key_exists($keys[10], $arr)) $this->setAddress($arr[$keys[10]]);
        if (array_key_exists($keys[11], $arr)) $this->setTelephone($arr[$keys[11]]);
        if (array_key_exists($keys[12], $arr)) $this->setEmail($arr[$keys[12]]);
        if (array_key_exists($keys[13], $arr)) $this->setBudget($arr[$keys[13]]);
        if (array_key_exists($keys[14], $arr)) $this->setPersonnel($arr[$keys[14]]);
        if (array_key_exists($keys[15], $arr)) $this->setHired($arr[$keys[15]]);
        if (array_key_exists($keys[16], $arr)) $this->setConsultant($arr[$keys[16]]);
        if (array_key_exists($keys[17], $arr)) $this->setOther($arr[$keys[17]]);
        if (array_key_exists($keys[18], $arr)) $this->setPlanning($arr[$keys[18]]);
        if (array_key_exists($keys[19], $arr)) $this->setOrder($arr[$keys[19]]);
        if (array_key_exists($keys[20], $arr)) $this->setTreeLeft($arr[$keys[20]]);
        if (array_key_exists($keys[21], $arr)) $this->setTreeRight($arr[$keys[21]]);
        if (array_key_exists($keys[22], $arr)) $this->setTreeLevel($arr[$keys[22]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(PositionPeer::DATABASE_NAME);

        if ($this->isColumnModified(PositionPeer::ID)) $criteria->add(PositionPeer::ID, $this->id);
        if ($this->isColumnModified(PositionPeer::NAME)) $criteria->add(PositionPeer::NAME, $this->name);
        if ($this->isColumnModified(PositionPeer::CODE)) $criteria->add(PositionPeer::CODE, $this->code);
        if ($this->isColumnModified(PositionPeer::USERGROUPID)) $criteria->add(PositionPeer::USERGROUPID, $this->usergroupid);
        if ($this->isColumnModified(PositionPeer::VERSIONID)) $criteria->add(PositionPeer::VERSIONID, $this->versionid);
        if ($this->isColumnModified(PositionPeer::INTERNALCODE)) $criteria->add(PositionPeer::INTERNALCODE, $this->internalcode);
        if ($this->isColumnModified(PositionPeer::OWNERNAME)) $criteria->add(PositionPeer::OWNERNAME, $this->ownername);
        if ($this->isColumnModified(PositionPeer::OWNERNAMEFEMALE)) $criteria->add(PositionPeer::OWNERNAMEFEMALE, $this->ownernamefemale);
        if ($this->isColumnModified(PositionPeer::TYPE)) $criteria->add(PositionPeer::TYPE, $this->type);
        if ($this->isColumnModified(PositionPeer::KIND)) $criteria->add(PositionPeer::KIND, $this->kind);
        if ($this->isColumnModified(PositionPeer::ADDRESS)) $criteria->add(PositionPeer::ADDRESS, $this->address);
        if ($this->isColumnModified(PositionPeer::TELEPHONE)) $criteria->add(PositionPeer::TELEPHONE, $this->telephone);
        if ($this->isColumnModified(PositionPeer::EMAIL)) $criteria->add(PositionPeer::EMAIL, $this->email);
        if ($this->isColumnModified(PositionPeer::BUDGET)) $criteria->add(PositionPeer::BUDGET, $this->budget);
        if ($this->isColumnModified(PositionPeer::PERSONNEL)) $criteria->add(PositionPeer::PERSONNEL, $this->personnel);
        if ($this->isColumnModified(PositionPeer::HIRED)) $criteria->add(PositionPeer::HIRED, $this->hired);
        if ($this->isColumnModified(PositionPeer::CONSULTANT)) $criteria->add(PositionPeer::CONSULTANT, $this->consultant);
        if ($this->isColumnModified(PositionPeer::OTHER)) $criteria->add(PositionPeer::OTHER, $this->other);
        if ($this->isColumnModified(PositionPeer::PLANNING)) $criteria->add(PositionPeer::PLANNING, $this->planning);
        if ($this->isColumnModified(PositionPeer::ORDER)) $criteria->add(PositionPeer::ORDER, $this->order);
        if ($this->isColumnModified(PositionPeer::TREE_LEFT)) $criteria->add(PositionPeer::TREE_LEFT, $this->tree_left);
        if ($this->isColumnModified(PositionPeer::TREE_RIGHT)) $criteria->add(PositionPeer::TREE_RIGHT, $this->tree_right);
        if ($this->isColumnModified(PositionPeer::TREE_LEVEL)) $criteria->add(PositionPeer::TREE_LEVEL, $this->tree_level);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(PositionPeer::DATABASE_NAME);
        $criteria->add(PositionPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Position (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setName($this->getName());
        $copyObj->setCode($this->getCode());
        $copyObj->setUsergroupid($this->getUsergroupid());
        $copyObj->setVersionid($this->getVersionid());
        $copyObj->setInternalcode($this->getInternalcode());
        $copyObj->setOwnername($this->getOwnername());
        $copyObj->setOwnernamefemale($this->getOwnernamefemale());
        $copyObj->setType($this->getType());
        $copyObj->setKind($this->getKind());
        $copyObj->setAddress($this->getAddress());
        $copyObj->setTelephone($this->getTelephone());
        $copyObj->setEmail($this->getEmail());
        $copyObj->setBudget($this->getBudget());
        $copyObj->setPersonnel($this->getPersonnel());
        $copyObj->setHired($this->getHired());
        $copyObj->setConsultant($this->getConsultant());
        $copyObj->setOther($this->getOther());
        $copyObj->setPlanning($this->getPlanning());
        $copyObj->setOrder($this->getOrder());
        $copyObj->setTreeLeft($this->getTreeLeft());
        $copyObj->setTreeRight($this->getTreeRight());
        $copyObj->setTreeLevel($this->getTreeLevel());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getIndicators() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addIndicator($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectives() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjective($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getObjectiveLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addObjectiveLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPositionTenures() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPositionTenure($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPositionDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPositionDocument($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjects() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProject($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivitys() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivity($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectLog($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProjectActivityLogs() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProjectActivityLog($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Position Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return PositionPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new PositionPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Group object.
     *
     * @param             Group $v
     * @return Position The current object (for fluent API support)
     * @throws PropelException
     */
    public function setGroup(Group $v = null)
    {
        if ($v === null) {
            $this->setUsergroupid(NULL);
        } else {
            $this->setUsergroupid($v->getId());
        }

        $this->aGroup = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Group object, it will not be re-added.
        if ($v !== null) {
            $v->addPosition($this);
        }


        return $this;
    }


    /**
     * Get the associated Group object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Group The associated Group object.
     * @throws PropelException
     */
    public function getGroup(PropelPDO $con = null)
    {
        if ($this->aGroup === null && ($this->usergroupid !== null)) {
            $this->aGroup = GroupQuery::create()->findPk($this->usergroupid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aGroup->addPositions($this);
             */
        }

        return $this->aGroup;
    }

    /**
     * Declares an association between this object and a PositionVersion object.
     *
     * @param             PositionVersion $v
     * @return Position The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPositionVersion(PositionVersion $v = null)
    {
        if ($v === null) {
            $this->setVersionid(NULL);
        } else {
            $this->setVersionid($v->getId());
        }

        $this->aPositionVersion = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PositionVersion object, it will not be re-added.
        if ($v !== null) {
            $v->addPosition($this);
        }


        return $this;
    }


    /**
     * Get the associated PositionVersion object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return PositionVersion The associated PositionVersion object.
     * @throws PropelException
     */
    public function getPositionVersion(PropelPDO $con = null)
    {
        if ($this->aPositionVersion === null && ($this->versionid !== null)) {
            $this->aPositionVersion = PositionVersionQuery::create()->findPk($this->versionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPositionVersion->addPositions($this);
             */
        }

        return $this->aPositionVersion;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Indicator' == $relationName) {
            $this->initIndicators();
        }
        if ('Objective' == $relationName) {
            $this->initObjectives();
        }
        if ('ObjectiveLog' == $relationName) {
            $this->initObjectiveLogs();
        }
        if ('PositionTenure' == $relationName) {
            $this->initPositionTenures();
        }
        if ('PositionDocument' == $relationName) {
            $this->initPositionDocuments();
        }
        if ('Project' == $relationName) {
            $this->initProjects();
        }
        if ('ProjectActivity' == $relationName) {
            $this->initProjectActivitys();
        }
        if ('ProjectLog' == $relationName) {
            $this->initProjectLogs();
        }
        if ('ProjectActivityLog' == $relationName) {
            $this->initProjectActivityLogs();
        }
    }

    /**
     * Clears out the collIndicators collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addIndicators()
     */
    public function clearIndicators()
    {
        $this->collIndicators = null; // important to set this to null since that means it is uninitialized
        $this->collIndicatorsPartial = null;
    }

    /**
     * reset is the collIndicators collection loaded partially
     *
     * @return void
     */
    public function resetPartialIndicators($v = true)
    {
        $this->collIndicatorsPartial = $v;
    }

    /**
     * Initializes the collIndicators collection.
     *
     * By default this just sets the collIndicators collection to an empty array (like clearcollIndicators());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initIndicators($overrideExisting = true)
    {
        if (null !== $this->collIndicators && !$overrideExisting) {
            return;
        }
        $this->collIndicators = new PropelObjectCollection();
        $this->collIndicators->setModel('Indicator');
    }

    /**
     * Gets an array of Indicator objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     * @throws PropelException
     */
    public function getIndicators($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorsPartial && !$this->isNew();
        if (null === $this->collIndicators || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collIndicators) {
                // return empty collection
                $this->initIndicators();
            } else {
                $collIndicators = IndicatorQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collIndicatorsPartial && count($collIndicators)) {
                      $this->initIndicators(false);

                      foreach($collIndicators as $obj) {
                        if (false == $this->collIndicators->contains($obj)) {
                          $this->collIndicators->append($obj);
                        }
                      }

                      $this->collIndicatorsPartial = true;
                    }

                    return $collIndicators;
                }

                if($partial && $this->collIndicators) {
                    foreach($this->collIndicators as $obj) {
                        if($obj->isNew()) {
                            $collIndicators[] = $obj;
                        }
                    }
                }

                $this->collIndicators = $collIndicators;
                $this->collIndicatorsPartial = false;
            }
        }

        return $this->collIndicators;
    }

    /**
     * Sets a collection of Indicator objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $indicators A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setIndicators(PropelCollection $indicators, PropelPDO $con = null)
    {
        $this->indicatorsScheduledForDeletion = $this->getIndicators(new Criteria(), $con)->diff($indicators);

        foreach ($this->indicatorsScheduledForDeletion as $indicatorRemoved) {
            $indicatorRemoved->setPosition(null);
        }

        $this->collIndicators = null;
        foreach ($indicators as $indicator) {
            $this->addIndicator($indicator);
        }

        $this->collIndicators = $indicators;
        $this->collIndicatorsPartial = false;
    }

    /**
     * Returns the number of related Indicator objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Indicator objects.
     * @throws PropelException
     */
    public function countIndicators(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collIndicatorsPartial && !$this->isNew();
        if (null === $this->collIndicators || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collIndicators) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getIndicators());
                }
                $query = IndicatorQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collIndicators);
        }
    }

    /**
     * Method called to associate a BaseIndicator object to this object
     * through the BaseIndicator foreign key attribute.
     *
     * @param    BaseIndicator $l BaseIndicator
     * @return Position The current object (for fluent API support)
     */
    public function addIndicator(BaseIndicator $l)
    {
        if ($this->collIndicators === null) {
            $this->initIndicators();
            $this->collIndicatorsPartial = true;
        }
        if (!$this->collIndicators->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddIndicator($l);
        }

        return $this;
    }

    /**
     * @param	Indicator $indicator The indicator object to add.
     */
    protected function doAddIndicator($indicator)
    {
        $this->collIndicators[]= $indicator;
        $indicator->setPosition($this);
    }

    /**
     * @param	Indicator $indicator The indicator object to remove.
     */
    public function removeIndicator($indicator)
    {
        if ($this->getIndicators()->contains($indicator)) {
            $this->collIndicators->remove($this->collIndicators->search($indicator));
            if (null === $this->indicatorsScheduledForDeletion) {
                $this->indicatorsScheduledForDeletion = clone $this->collIndicators;
                $this->indicatorsScheduledForDeletion->clear();
            }
            $this->indicatorsScheduledForDeletion[]= $indicator;
            $indicator->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Indicators from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Indicator[] List of Indicator objects
     */
    public function getIndicatorsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = IndicatorQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getIndicators($query, $con);
    }

    /**
     * Clears out the collObjectives collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectives()
     */
    public function clearObjectives()
    {
        $this->collObjectives = null; // important to set this to null since that means it is uninitialized
        $this->collObjectivesPartial = null;
    }

    /**
     * reset is the collObjectives collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectives($v = true)
    {
        $this->collObjectivesPartial = $v;
    }

    /**
     * Initializes the collObjectives collection.
     *
     * By default this just sets the collObjectives collection to an empty array (like clearcollObjectives());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectives($overrideExisting = true)
    {
        if (null !== $this->collObjectives && !$overrideExisting) {
            return;
        }
        $this->collObjectives = new PropelObjectCollection();
        $this->collObjectives->setModel('Objective');
    }

    /**
     * Gets an array of Objective objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Objective[] List of Objective objects
     * @throws PropelException
     */
    public function getObjectives($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                // return empty collection
                $this->initObjectives();
            } else {
                $collObjectives = ObjectiveQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectivesPartial && count($collObjectives)) {
                      $this->initObjectives(false);

                      foreach($collObjectives as $obj) {
                        if (false == $this->collObjectives->contains($obj)) {
                          $this->collObjectives->append($obj);
                        }
                      }

                      $this->collObjectivesPartial = true;
                    }

                    return $collObjectives;
                }

                if($partial && $this->collObjectives) {
                    foreach($this->collObjectives as $obj) {
                        if($obj->isNew()) {
                            $collObjectives[] = $obj;
                        }
                    }
                }

                $this->collObjectives = $collObjectives;
                $this->collObjectivesPartial = false;
            }
        }

        return $this->collObjectives;
    }

    /**
     * Sets a collection of Objective objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectives A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectives(PropelCollection $objectives, PropelPDO $con = null)
    {
        $this->objectivesScheduledForDeletion = $this->getObjectives(new Criteria(), $con)->diff($objectives);

        foreach ($this->objectivesScheduledForDeletion as $objectiveRemoved) {
            $objectiveRemoved->setPosition(null);
        }

        $this->collObjectives = null;
        foreach ($objectives as $objective) {
            $this->addObjective($objective);
        }

        $this->collObjectives = $objectives;
        $this->collObjectivesPartial = false;
    }

    /**
     * Returns the number of related Objective objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Objective objects.
     * @throws PropelException
     */
    public function countObjectives(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectivesPartial && !$this->isNew();
        if (null === $this->collObjectives || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectives) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectives());
                }
                $query = ObjectiveQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectives);
        }
    }

    /**
     * Method called to associate a Objective object to this object
     * through the Objective foreign key attribute.
     *
     * @param    Objective $l Objective
     * @return Position The current object (for fluent API support)
     */
    public function addObjective(Objective $l)
    {
        if ($this->collObjectives === null) {
            $this->initObjectives();
            $this->collObjectivesPartial = true;
        }
        if (!$this->collObjectives->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjective($l);
        }

        return $this;
    }

    /**
     * @param	Objective $objective The objective object to add.
     */
    protected function doAddObjective($objective)
    {
        $this->collObjectives[]= $objective;
        $objective->setPosition($this);
    }

    /**
     * @param	Objective $objective The objective object to remove.
     */
    public function removeObjective($objective)
    {
        if ($this->getObjectives()->contains($objective)) {
            $this->collObjectives->remove($this->collObjectives->search($objective));
            if (null === $this->objectivesScheduledForDeletion) {
                $this->objectivesScheduledForDeletion = clone $this->collObjectives;
                $this->objectivesScheduledForDeletion->clear();
            }
            $this->objectivesScheduledForDeletion[]= $objective;
            $objective->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectives($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Objectives from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Objective[] List of Objective objects
     */
    public function getObjectivesJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectives($query, $con);
    }

    /**
     * Clears out the collObjectiveLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addObjectiveLogs()
     */
    public function clearObjectiveLogs()
    {
        $this->collObjectiveLogs = null; // important to set this to null since that means it is uninitialized
        $this->collObjectiveLogsPartial = null;
    }

    /**
     * reset is the collObjectiveLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialObjectiveLogs($v = true)
    {
        $this->collObjectiveLogsPartial = $v;
    }

    /**
     * Initializes the collObjectiveLogs collection.
     *
     * By default this just sets the collObjectiveLogs collection to an empty array (like clearcollObjectiveLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initObjectiveLogs($overrideExisting = true)
    {
        if (null !== $this->collObjectiveLogs && !$overrideExisting) {
            return;
        }
        $this->collObjectiveLogs = new PropelObjectCollection();
        $this->collObjectiveLogs->setModel('ObjectiveLog');
    }

    /**
     * Gets an array of ObjectiveLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     * @throws PropelException
     */
    public function getObjectiveLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                // return empty collection
                $this->initObjectiveLogs();
            } else {
                $collObjectiveLogs = ObjectiveLogQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collObjectiveLogsPartial && count($collObjectiveLogs)) {
                      $this->initObjectiveLogs(false);

                      foreach($collObjectiveLogs as $obj) {
                        if (false == $this->collObjectiveLogs->contains($obj)) {
                          $this->collObjectiveLogs->append($obj);
                        }
                      }

                      $this->collObjectiveLogsPartial = true;
                    }

                    return $collObjectiveLogs;
                }

                if($partial && $this->collObjectiveLogs) {
                    foreach($this->collObjectiveLogs as $obj) {
                        if($obj->isNew()) {
                            $collObjectiveLogs[] = $obj;
                        }
                    }
                }

                $this->collObjectiveLogs = $collObjectiveLogs;
                $this->collObjectiveLogsPartial = false;
            }
        }

        return $this->collObjectiveLogs;
    }

    /**
     * Sets a collection of ObjectiveLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $objectiveLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setObjectiveLogs(PropelCollection $objectiveLogs, PropelPDO $con = null)
    {
        $this->objectiveLogsScheduledForDeletion = $this->getObjectiveLogs(new Criteria(), $con)->diff($objectiveLogs);

        foreach ($this->objectiveLogsScheduledForDeletion as $objectiveLogRemoved) {
            $objectiveLogRemoved->setPosition(null);
        }

        $this->collObjectiveLogs = null;
        foreach ($objectiveLogs as $objectiveLog) {
            $this->addObjectiveLog($objectiveLog);
        }

        $this->collObjectiveLogs = $objectiveLogs;
        $this->collObjectiveLogsPartial = false;
    }

    /**
     * Returns the number of related ObjectiveLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ObjectiveLog objects.
     * @throws PropelException
     */
    public function countObjectiveLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collObjectiveLogsPartial && !$this->isNew();
        if (null === $this->collObjectiveLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collObjectiveLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getObjectiveLogs());
                }
                $query = ObjectiveLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collObjectiveLogs);
        }
    }

    /**
     * Method called to associate a ObjectiveLog object to this object
     * through the ObjectiveLog foreign key attribute.
     *
     * @param    ObjectiveLog $l ObjectiveLog
     * @return Position The current object (for fluent API support)
     */
    public function addObjectiveLog(ObjectiveLog $l)
    {
        if ($this->collObjectiveLogs === null) {
            $this->initObjectiveLogs();
            $this->collObjectiveLogsPartial = true;
        }
        if (!$this->collObjectiveLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddObjectiveLog($l);
        }

        return $this;
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to add.
     */
    protected function doAddObjectiveLog($objectiveLog)
    {
        $this->collObjectiveLogs[]= $objectiveLog;
        $objectiveLog->setPosition($this);
    }

    /**
     * @param	ObjectiveLog $objectiveLog The objectiveLog object to remove.
     */
    public function removeObjectiveLog($objectiveLog)
    {
        if ($this->getObjectiveLogs()->contains($objectiveLog)) {
            $this->collObjectiveLogs->remove($this->collObjectiveLogs->search($objectiveLog));
            if (null === $this->objectiveLogsScheduledForDeletion) {
                $this->objectiveLogsScheduledForDeletion = clone $this->collObjectiveLogs;
                $this->objectiveLogsScheduledForDeletion->clear();
            }
            $this->objectiveLogsScheduledForDeletion[]= $objectiveLog;
            $objectiveLog->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinStrategicObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('StrategicObjective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinPolicyGuideline($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('PolicyGuideline', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ObjectiveLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ObjectiveLog[] List of ObjectiveLog objects
     */
    public function getObjectiveLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ObjectiveLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getObjectiveLogs($query, $con);
    }

    /**
     * Clears out the collPositionTenures collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPositionTenures()
     */
    public function clearPositionTenures()
    {
        $this->collPositionTenures = null; // important to set this to null since that means it is uninitialized
        $this->collPositionTenuresPartial = null;
    }

    /**
     * reset is the collPositionTenures collection loaded partially
     *
     * @return void
     */
    public function resetPartialPositionTenures($v = true)
    {
        $this->collPositionTenuresPartial = $v;
    }

    /**
     * Initializes the collPositionTenures collection.
     *
     * By default this just sets the collPositionTenures collection to an empty array (like clearcollPositionTenures());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPositionTenures($overrideExisting = true)
    {
        if (null !== $this->collPositionTenures && !$overrideExisting) {
            return;
        }
        $this->collPositionTenures = new PropelObjectCollection();
        $this->collPositionTenures->setModel('PositionTenure');
    }

    /**
     * Gets an array of PositionTenure objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PositionTenure[] List of PositionTenure objects
     * @throws PropelException
     */
    public function getPositionTenures($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPositionTenuresPartial && !$this->isNew();
        if (null === $this->collPositionTenures || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPositionTenures) {
                // return empty collection
                $this->initPositionTenures();
            } else {
                $collPositionTenures = PositionTenureQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPositionTenuresPartial && count($collPositionTenures)) {
                      $this->initPositionTenures(false);

                      foreach($collPositionTenures as $obj) {
                        if (false == $this->collPositionTenures->contains($obj)) {
                          $this->collPositionTenures->append($obj);
                        }
                      }

                      $this->collPositionTenuresPartial = true;
                    }

                    return $collPositionTenures;
                }

                if($partial && $this->collPositionTenures) {
                    foreach($this->collPositionTenures as $obj) {
                        if($obj->isNew()) {
                            $collPositionTenures[] = $obj;
                        }
                    }
                }

                $this->collPositionTenures = $collPositionTenures;
                $this->collPositionTenuresPartial = false;
            }
        }

        return $this->collPositionTenures;
    }

    /**
     * Sets a collection of PositionTenure objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $positionTenures A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPositionTenures(PropelCollection $positionTenures, PropelPDO $con = null)
    {
        $this->positionTenuresScheduledForDeletion = $this->getPositionTenures(new Criteria(), $con)->diff($positionTenures);

        foreach ($this->positionTenuresScheduledForDeletion as $positionTenureRemoved) {
            $positionTenureRemoved->setPosition(null);
        }

        $this->collPositionTenures = null;
        foreach ($positionTenures as $positionTenure) {
            $this->addPositionTenure($positionTenure);
        }

        $this->collPositionTenures = $positionTenures;
        $this->collPositionTenuresPartial = false;
    }

    /**
     * Returns the number of related PositionTenure objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PositionTenure objects.
     * @throws PropelException
     */
    public function countPositionTenures(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPositionTenuresPartial && !$this->isNew();
        if (null === $this->collPositionTenures || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPositionTenures) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPositionTenures());
                }
                $query = PositionTenureQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collPositionTenures);
        }
    }

    /**
     * Method called to associate a PositionTenure object to this object
     * through the PositionTenure foreign key attribute.
     *
     * @param    PositionTenure $l PositionTenure
     * @return Position The current object (for fluent API support)
     */
    public function addPositionTenure(PositionTenure $l)
    {
        if ($this->collPositionTenures === null) {
            $this->initPositionTenures();
            $this->collPositionTenuresPartial = true;
        }
        if (!$this->collPositionTenures->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPositionTenure($l);
        }

        return $this;
    }

    /**
     * @param	PositionTenure $positionTenure The positionTenure object to add.
     */
    protected function doAddPositionTenure($positionTenure)
    {
        $this->collPositionTenures[]= $positionTenure;
        $positionTenure->setPosition($this);
    }

    /**
     * @param	PositionTenure $positionTenure The positionTenure object to remove.
     */
    public function removePositionTenure($positionTenure)
    {
        if ($this->getPositionTenures()->contains($positionTenure)) {
            $this->collPositionTenures->remove($this->collPositionTenures->search($positionTenure));
            if (null === $this->positionTenuresScheduledForDeletion) {
                $this->positionTenuresScheduledForDeletion = clone $this->collPositionTenures;
                $this->positionTenuresScheduledForDeletion->clear();
            }
            $this->positionTenuresScheduledForDeletion[]= $positionTenure;
            $positionTenure->setPosition(null);
        }
    }

    /**
     * Clears out the collPositionDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addPositionDocuments()
     */
    public function clearPositionDocuments()
    {
        $this->collPositionDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collPositionDocumentsPartial = null;
    }

    /**
     * reset is the collPositionDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialPositionDocuments($v = true)
    {
        $this->collPositionDocumentsPartial = $v;
    }

    /**
     * Initializes the collPositionDocuments collection.
     *
     * By default this just sets the collPositionDocuments collection to an empty array (like clearcollPositionDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPositionDocuments($overrideExisting = true)
    {
        if (null !== $this->collPositionDocuments && !$overrideExisting) {
            return;
        }
        $this->collPositionDocuments = new PropelObjectCollection();
        $this->collPositionDocuments->setModel('PositionDocument');
    }

    /**
     * Gets an array of PositionDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|PositionDocument[] List of PositionDocument objects
     * @throws PropelException
     */
    public function getPositionDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collPositionDocumentsPartial && !$this->isNew();
        if (null === $this->collPositionDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collPositionDocuments) {
                // return empty collection
                $this->initPositionDocuments();
            } else {
                $collPositionDocuments = PositionDocumentQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collPositionDocumentsPartial && count($collPositionDocuments)) {
                      $this->initPositionDocuments(false);

                      foreach($collPositionDocuments as $obj) {
                        if (false == $this->collPositionDocuments->contains($obj)) {
                          $this->collPositionDocuments->append($obj);
                        }
                      }

                      $this->collPositionDocumentsPartial = true;
                    }

                    return $collPositionDocuments;
                }

                if($partial && $this->collPositionDocuments) {
                    foreach($this->collPositionDocuments as $obj) {
                        if($obj->isNew()) {
                            $collPositionDocuments[] = $obj;
                        }
                    }
                }

                $this->collPositionDocuments = $collPositionDocuments;
                $this->collPositionDocumentsPartial = false;
            }
        }

        return $this->collPositionDocuments;
    }

    /**
     * Sets a collection of PositionDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $positionDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setPositionDocuments(PropelCollection $positionDocuments, PropelPDO $con = null)
    {
        $this->positionDocumentsScheduledForDeletion = $this->getPositionDocuments(new Criteria(), $con)->diff($positionDocuments);

        foreach ($this->positionDocumentsScheduledForDeletion as $positionDocumentRemoved) {
            $positionDocumentRemoved->setPosition(null);
        }

        $this->collPositionDocuments = null;
        foreach ($positionDocuments as $positionDocument) {
            $this->addPositionDocument($positionDocument);
        }

        $this->collPositionDocuments = $positionDocuments;
        $this->collPositionDocumentsPartial = false;
    }

    /**
     * Returns the number of related PositionDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related PositionDocument objects.
     * @throws PropelException
     */
    public function countPositionDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collPositionDocumentsPartial && !$this->isNew();
        if (null === $this->collPositionDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPositionDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getPositionDocuments());
                }
                $query = PositionDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collPositionDocuments);
        }
    }

    /**
     * Method called to associate a PositionDocument object to this object
     * through the PositionDocument foreign key attribute.
     *
     * @param    PositionDocument $l PositionDocument
     * @return Position The current object (for fluent API support)
     */
    public function addPositionDocument(PositionDocument $l)
    {
        if ($this->collPositionDocuments === null) {
            $this->initPositionDocuments();
            $this->collPositionDocumentsPartial = true;
        }
        if (!$this->collPositionDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddPositionDocument($l);
        }

        return $this;
    }

    /**
     * @param	PositionDocument $positionDocument The positionDocument object to add.
     */
    protected function doAddPositionDocument($positionDocument)
    {
        $this->collPositionDocuments[]= $positionDocument;
        $positionDocument->setPosition($this);
    }

    /**
     * @param	PositionDocument $positionDocument The positionDocument object to remove.
     */
    public function removePositionDocument($positionDocument)
    {
        if ($this->getPositionDocuments()->contains($positionDocument)) {
            $this->collPositionDocuments->remove($this->collPositionDocuments->search($positionDocument));
            if (null === $this->positionDocumentsScheduledForDeletion) {
                $this->positionDocumentsScheduledForDeletion = clone $this->collPositionDocuments;
                $this->positionDocumentsScheduledForDeletion->clear();
            }
            $this->positionDocumentsScheduledForDeletion[]= $positionDocument;
            $positionDocument->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related PositionDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|PositionDocument[] List of PositionDocument objects
     */
    public function getPositionDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = PositionDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getPositionDocuments($query, $con);
    }

    /**
     * Clears out the collProjects collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjects()
     */
    public function clearProjects()
    {
        $this->collProjects = null; // important to set this to null since that means it is uninitialized
        $this->collProjectsPartial = null;
    }

    /**
     * reset is the collProjects collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjects($v = true)
    {
        $this->collProjectsPartial = $v;
    }

    /**
     * Initializes the collProjects collection.
     *
     * By default this just sets the collProjects collection to an empty array (like clearcollProjects());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjects($overrideExisting = true)
    {
        if (null !== $this->collProjects && !$overrideExisting) {
            return;
        }
        $this->collProjects = new PropelObjectCollection();
        $this->collProjects->setModel('Project');
    }

    /**
     * Gets an array of Project objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Project[] List of Project objects
     * @throws PropelException
     */
    public function getProjects($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                // return empty collection
                $this->initProjects();
            } else {
                $collProjects = ProjectQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectsPartial && count($collProjects)) {
                      $this->initProjects(false);

                      foreach($collProjects as $obj) {
                        if (false == $this->collProjects->contains($obj)) {
                          $this->collProjects->append($obj);
                        }
                      }

                      $this->collProjectsPartial = true;
                    }

                    return $collProjects;
                }

                if($partial && $this->collProjects) {
                    foreach($this->collProjects as $obj) {
                        if($obj->isNew()) {
                            $collProjects[] = $obj;
                        }
                    }
                }

                $this->collProjects = $collProjects;
                $this->collProjectsPartial = false;
            }
        }

        return $this->collProjects;
    }

    /**
     * Sets a collection of Project objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projects A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjects(PropelCollection $projects, PropelPDO $con = null)
    {
        $this->projectsScheduledForDeletion = $this->getProjects(new Criteria(), $con)->diff($projects);

        foreach ($this->projectsScheduledForDeletion as $projectRemoved) {
            $projectRemoved->setPosition(null);
        }

        $this->collProjects = null;
        foreach ($projects as $project) {
            $this->addProject($project);
        }

        $this->collProjects = $projects;
        $this->collProjectsPartial = false;
    }

    /**
     * Returns the number of related Project objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Project objects.
     * @throws PropelException
     */
    public function countProjects(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectsPartial && !$this->isNew();
        if (null === $this->collProjects || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjects) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjects());
                }
                $query = ProjectQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjects);
        }
    }

    /**
     * Method called to associate a Project object to this object
     * through the Project foreign key attribute.
     *
     * @param    Project $l Project
     * @return Position The current object (for fluent API support)
     */
    public function addProject(Project $l)
    {
        if ($this->collProjects === null) {
            $this->initProjects();
            $this->collProjectsPartial = true;
        }
        if (!$this->collProjects->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProject($l);
        }

        return $this;
    }

    /**
     * @param	Project $project The project object to add.
     */
    protected function doAddProject($project)
    {
        $this->collProjects[]= $project;
        $project->setPosition($this);
    }

    /**
     * @param	Project $project The project object to remove.
     */
    public function removeProject($project)
    {
        if ($this->getProjects()->contains($project)) {
            $this->collProjects->remove($this->collProjects->search($project));
            if (null === $this->projectsScheduledForDeletion) {
                $this->projectsScheduledForDeletion = clone $this->collProjects;
                $this->projectsScheduledForDeletion->clear();
            }
            $this->projectsScheduledForDeletion[]= $project;
            $project->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinIndicator($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('Indicator', $join_behavior);

        return $this->getProjects($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related Projects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Project[] List of Project objects
     */
    public function getProjectsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjects($query, $con);
    }

    /**
     * Clears out the collProjectActivitys collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivitys()
     */
    public function clearProjectActivitys()
    {
        $this->collProjectActivitys = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivitysPartial = null;
    }

    /**
     * reset is the collProjectActivitys collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivitys($v = true)
    {
        $this->collProjectActivitysPartial = $v;
    }

    /**
     * Initializes the collProjectActivitys collection.
     *
     * By default this just sets the collProjectActivitys collection to an empty array (like clearcollProjectActivitys());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivitys($overrideExisting = true)
    {
        if (null !== $this->collProjectActivitys && !$overrideExisting) {
            return;
        }
        $this->collProjectActivitys = new PropelObjectCollection();
        $this->collProjectActivitys->setModel('ProjectActivity');
    }

    /**
     * Gets an array of ProjectActivity objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     * @throws PropelException
     */
    public function getProjectActivitys($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                // return empty collection
                $this->initProjectActivitys();
            } else {
                $collProjectActivitys = ProjectActivityQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivitysPartial && count($collProjectActivitys)) {
                      $this->initProjectActivitys(false);

                      foreach($collProjectActivitys as $obj) {
                        if (false == $this->collProjectActivitys->contains($obj)) {
                          $this->collProjectActivitys->append($obj);
                        }
                      }

                      $this->collProjectActivitysPartial = true;
                    }

                    return $collProjectActivitys;
                }

                if($partial && $this->collProjectActivitys) {
                    foreach($this->collProjectActivitys as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivitys[] = $obj;
                        }
                    }
                }

                $this->collProjectActivitys = $collProjectActivitys;
                $this->collProjectActivitysPartial = false;
            }
        }

        return $this->collProjectActivitys;
    }

    /**
     * Sets a collection of ProjectActivity objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivitys A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivitys(PropelCollection $projectActivitys, PropelPDO $con = null)
    {
        $this->projectActivitysScheduledForDeletion = $this->getProjectActivitys(new Criteria(), $con)->diff($projectActivitys);

        foreach ($this->projectActivitysScheduledForDeletion as $projectActivityRemoved) {
            $projectActivityRemoved->setPosition(null);
        }

        $this->collProjectActivitys = null;
        foreach ($projectActivitys as $projectActivity) {
            $this->addProjectActivity($projectActivity);
        }

        $this->collProjectActivitys = $projectActivitys;
        $this->collProjectActivitysPartial = false;
    }

    /**
     * Returns the number of related ProjectActivity objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivity objects.
     * @throws PropelException
     */
    public function countProjectActivitys(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivitysPartial && !$this->isNew();
        if (null === $this->collProjectActivitys || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivitys) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivitys());
                }
                $query = ProjectActivityQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivitys);
        }
    }

    /**
     * Method called to associate a ProjectActivity object to this object
     * through the ProjectActivity foreign key attribute.
     *
     * @param    ProjectActivity $l ProjectActivity
     * @return Position The current object (for fluent API support)
     */
    public function addProjectActivity(ProjectActivity $l)
    {
        if ($this->collProjectActivitys === null) {
            $this->initProjectActivitys();
            $this->collProjectActivitysPartial = true;
        }
        if (!$this->collProjectActivitys->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivity($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to add.
     */
    protected function doAddProjectActivity($projectActivity)
    {
        $this->collProjectActivitys[]= $projectActivity;
        $projectActivity->setPosition($this);
    }

    /**
     * @param	ProjectActivity $projectActivity The projectActivity object to remove.
     */
    public function removeProjectActivity($projectActivity)
    {
        if ($this->getProjectActivitys()->contains($projectActivity)) {
            $this->collProjectActivitys->remove($this->collProjectActivitys->search($projectActivity));
            if (null === $this->projectActivitysScheduledForDeletion) {
                $this->projectActivitysScheduledForDeletion = clone $this->collProjectActivitys;
                $this->projectActivitysScheduledForDeletion->clear();
            }
            $this->projectActivitysScheduledForDeletion[]= $projectActivity;
            $projectActivity->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectActivitys from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivity[] List of ProjectActivity objects
     */
    public function getProjectActivitysJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectActivitys($query, $con);
    }

    /**
     * Clears out the collProjectLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectLogs()
     */
    public function clearProjectLogs()
    {
        $this->collProjectLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectLogsPartial = null;
    }

    /**
     * reset is the collProjectLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectLogs($v = true)
    {
        $this->collProjectLogsPartial = $v;
    }

    /**
     * Initializes the collProjectLogs collection.
     *
     * By default this just sets the collProjectLogs collection to an empty array (like clearcollProjectLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectLogs = new PropelObjectCollection();
        $this->collProjectLogs->setModel('ProjectLog');
    }

    /**
     * Gets an array of ProjectLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     * @throws PropelException
     */
    public function getProjectLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                // return empty collection
                $this->initProjectLogs();
            } else {
                $collProjectLogs = ProjectLogQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectLogsPartial && count($collProjectLogs)) {
                      $this->initProjectLogs(false);

                      foreach($collProjectLogs as $obj) {
                        if (false == $this->collProjectLogs->contains($obj)) {
                          $this->collProjectLogs->append($obj);
                        }
                      }

                      $this->collProjectLogsPartial = true;
                    }

                    return $collProjectLogs;
                }

                if($partial && $this->collProjectLogs) {
                    foreach($this->collProjectLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectLogs = $collProjectLogs;
                $this->collProjectLogsPartial = false;
            }
        }

        return $this->collProjectLogs;
    }

    /**
     * Sets a collection of ProjectLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectLogs(PropelCollection $projectLogs, PropelPDO $con = null)
    {
        $this->projectLogsScheduledForDeletion = $this->getProjectLogs(new Criteria(), $con)->diff($projectLogs);

        foreach ($this->projectLogsScheduledForDeletion as $projectLogRemoved) {
            $projectLogRemoved->setPosition(null);
        }

        $this->collProjectLogs = null;
        foreach ($projectLogs as $projectLog) {
            $this->addProjectLog($projectLog);
        }

        $this->collProjectLogs = $projectLogs;
        $this->collProjectLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectLog objects.
     * @throws PropelException
     */
    public function countProjectLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectLogsPartial && !$this->isNew();
        if (null === $this->collProjectLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectLogs());
                }
                $query = ProjectLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectLogs);
        }
    }

    /**
     * Method called to associate a ProjectLog object to this object
     * through the ProjectLog foreign key attribute.
     *
     * @param    ProjectLog $l ProjectLog
     * @return Position The current object (for fluent API support)
     */
    public function addProjectLog(ProjectLog $l)
    {
        if ($this->collProjectLogs === null) {
            $this->initProjectLogs();
            $this->collProjectLogsPartial = true;
        }
        if (!$this->collProjectLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to add.
     */
    protected function doAddProjectLog($projectLog)
    {
        $this->collProjectLogs[]= $projectLog;
        $projectLog->setPosition($this);
    }

    /**
     * @param	ProjectLog $projectLog The projectLog object to remove.
     */
    public function removeProjectLog($projectLog)
    {
        if ($this->getProjectLogs()->contains($projectLog)) {
            $this->collProjectLogs->remove($this->collProjectLogs->search($projectLog));
            if (null === $this->projectLogsScheduledForDeletion) {
                $this->projectLogsScheduledForDeletion = clone $this->collProjectLogs;
                $this->projectLogsScheduledForDeletion->clear();
            }
            $this->projectLogsScheduledForDeletion[]= $projectLog;
            $projectLog->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinObjective($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('Objective', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectLog[] List of ProjectLog objects
     */
    public function getProjectLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectLogs($query, $con);
    }

    /**
     * Clears out the collProjectActivityLogs collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProjectActivityLogs()
     */
    public function clearProjectActivityLogs()
    {
        $this->collProjectActivityLogs = null; // important to set this to null since that means it is uninitialized
        $this->collProjectActivityLogsPartial = null;
    }

    /**
     * reset is the collProjectActivityLogs collection loaded partially
     *
     * @return void
     */
    public function resetPartialProjectActivityLogs($v = true)
    {
        $this->collProjectActivityLogsPartial = $v;
    }

    /**
     * Initializes the collProjectActivityLogs collection.
     *
     * By default this just sets the collProjectActivityLogs collection to an empty array (like clearcollProjectActivityLogs());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProjectActivityLogs($overrideExisting = true)
    {
        if (null !== $this->collProjectActivityLogs && !$overrideExisting) {
            return;
        }
        $this->collProjectActivityLogs = new PropelObjectCollection();
        $this->collProjectActivityLogs->setModel('ProjectActivityLog');
    }

    /**
     * Gets an array of ProjectActivityLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     * @throws PropelException
     */
    public function getProjectActivityLogs($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                // return empty collection
                $this->initProjectActivityLogs();
            } else {
                $collProjectActivityLogs = ProjectActivityLogQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collProjectActivityLogsPartial && count($collProjectActivityLogs)) {
                      $this->initProjectActivityLogs(false);

                      foreach($collProjectActivityLogs as $obj) {
                        if (false == $this->collProjectActivityLogs->contains($obj)) {
                          $this->collProjectActivityLogs->append($obj);
                        }
                      }

                      $this->collProjectActivityLogsPartial = true;
                    }

                    return $collProjectActivityLogs;
                }

                if($partial && $this->collProjectActivityLogs) {
                    foreach($this->collProjectActivityLogs as $obj) {
                        if($obj->isNew()) {
                            $collProjectActivityLogs[] = $obj;
                        }
                    }
                }

                $this->collProjectActivityLogs = $collProjectActivityLogs;
                $this->collProjectActivityLogsPartial = false;
            }
        }

        return $this->collProjectActivityLogs;
    }

    /**
     * Sets a collection of ProjectActivityLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $projectActivityLogs A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setProjectActivityLogs(PropelCollection $projectActivityLogs, PropelPDO $con = null)
    {
        $this->projectActivityLogsScheduledForDeletion = $this->getProjectActivityLogs(new Criteria(), $con)->diff($projectActivityLogs);

        foreach ($this->projectActivityLogsScheduledForDeletion as $projectActivityLogRemoved) {
            $projectActivityLogRemoved->setPosition(null);
        }

        $this->collProjectActivityLogs = null;
        foreach ($projectActivityLogs as $projectActivityLog) {
            $this->addProjectActivityLog($projectActivityLog);
        }

        $this->collProjectActivityLogs = $projectActivityLogs;
        $this->collProjectActivityLogsPartial = false;
    }

    /**
     * Returns the number of related ProjectActivityLog objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related ProjectActivityLog objects.
     * @throws PropelException
     */
    public function countProjectActivityLogs(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collProjectActivityLogsPartial && !$this->isNew();
        if (null === $this->collProjectActivityLogs || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProjectActivityLogs) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getProjectActivityLogs());
                }
                $query = ProjectActivityLogQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collProjectActivityLogs);
        }
    }

    /**
     * Method called to associate a ProjectActivityLog object to this object
     * through the ProjectActivityLog foreign key attribute.
     *
     * @param    ProjectActivityLog $l ProjectActivityLog
     * @return Position The current object (for fluent API support)
     */
    public function addProjectActivityLog(ProjectActivityLog $l)
    {
        if ($this->collProjectActivityLogs === null) {
            $this->initProjectActivityLogs();
            $this->collProjectActivityLogsPartial = true;
        }
        if (!$this->collProjectActivityLogs->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddProjectActivityLog($l);
        }

        return $this;
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to add.
     */
    protected function doAddProjectActivityLog($projectActivityLog)
    {
        $this->collProjectActivityLogs[]= $projectActivityLog;
        $projectActivityLog->setPosition($this);
    }

    /**
     * @param	ProjectActivityLog $projectActivityLog The projectActivityLog object to remove.
     */
    public function removeProjectActivityLog($projectActivityLog)
    {
        if ($this->getProjectActivityLogs()->contains($projectActivityLog)) {
            $this->collProjectActivityLogs->remove($this->collProjectActivityLogs->search($projectActivityLog));
            if (null === $this->projectActivityLogsScheduledForDeletion) {
                $this->projectActivityLogsScheduledForDeletion = clone $this->collProjectActivityLogs;
                $this->projectActivityLogsScheduledForDeletion->clear();
            }
            $this->projectActivityLogsScheduledForDeletion[]= $projectActivityLog;
            $projectActivityLog->setPosition(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinProject($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('Project', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinProjectActivity($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('ProjectActivity', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ProjectActivityLogs from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|ProjectActivityLog[] List of ProjectActivityLog objects
     */
    public function getProjectActivityLogsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ProjectActivityLogQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getProjectActivityLogs($query, $con);
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Position is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the positions_document cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the positions_document cross reference table.
     *
     * @param  Document $document The PositionDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $positionDocument = new PositionDocument();
        $positionDocument->setDocument($document);
        $this->addPositionDocument($positionDocument);
    }

    /**
     * Remove a Document object to this object
     * through the positions_document cross reference table.
     *
     * @param Document $document The PositionDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->code = null;
        $this->usergroupid = null;
        $this->versionid = null;
        $this->internalcode = null;
        $this->ownername = null;
        $this->ownernamefemale = null;
        $this->type = null;
        $this->kind = null;
        $this->address = null;
        $this->telephone = null;
        $this->email = null;
        $this->budget = null;
        $this->personnel = null;
        $this->hired = null;
        $this->consultant = null;
        $this->other = null;
        $this->planning = null;
        $this->order = null;
        $this->tree_left = null;
        $this->tree_right = null;
        $this->tree_level = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collIndicators) {
                foreach ($this->collIndicators as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectives) {
                foreach ($this->collObjectives as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collObjectiveLogs) {
                foreach ($this->collObjectiveLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPositionTenures) {
                foreach ($this->collPositionTenures as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPositionDocuments) {
                foreach ($this->collPositionDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjects) {
                foreach ($this->collProjects as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivitys) {
                foreach ($this->collProjectActivitys as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectLogs) {
                foreach ($this->collProjectLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProjectActivityLogs) {
                foreach ($this->collProjectActivityLogs as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        // nested_set behavior
        $this->collNestedSetChildren = null;
        $this->aNestedSetParent = null;
        if ($this->collIndicators instanceof PropelCollection) {
            $this->collIndicators->clearIterator();
        }
        $this->collIndicators = null;
        if ($this->collObjectives instanceof PropelCollection) {
            $this->collObjectives->clearIterator();
        }
        $this->collObjectives = null;
        if ($this->collObjectiveLogs instanceof PropelCollection) {
            $this->collObjectiveLogs->clearIterator();
        }
        $this->collObjectiveLogs = null;
        if ($this->collPositionTenures instanceof PropelCollection) {
            $this->collPositionTenures->clearIterator();
        }
        $this->collPositionTenures = null;
        if ($this->collPositionDocuments instanceof PropelCollection) {
            $this->collPositionDocuments->clearIterator();
        }
        $this->collPositionDocuments = null;
        if ($this->collProjects instanceof PropelCollection) {
            $this->collProjects->clearIterator();
        }
        $this->collProjects = null;
        if ($this->collProjectActivitys instanceof PropelCollection) {
            $this->collProjectActivitys->clearIterator();
        }
        $this->collProjectActivitys = null;
        if ($this->collProjectLogs instanceof PropelCollection) {
            $this->collProjectLogs->clearIterator();
        }
        $this->collProjectLogs = null;
        if ($this->collProjectActivityLogs instanceof PropelCollection) {
            $this->collProjectActivityLogs->clearIterator();
        }
        $this->collProjectActivityLogs = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        $this->aGroup = null;
        $this->aPositionVersion = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string The value of the 'name' column
     */
    public function __toString()
    {
        return (string) $this->getName();
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // nested_set behavior

    /**
     * Execute queries that were saved to be run inside the save transaction
     */
    protected function processNestedSetQueries($con)
    {
        foreach ($this->nestedSetQueries as $query) {
            $query['arguments'][]= $con;
            call_user_func_array($query['callable'], $query['arguments']);
        }
        $this->nestedSetQueries = array();
    }

    /**
     * Proxy getter method for the left value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set left value
     */
    public function getLeftValue()
    {
        return $this->tree_left;
    }

    /**
     * Proxy getter method for the right value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set right value
     */
    public function getRightValue()
    {
        return $this->tree_right;
    }

    /**
     * Proxy getter method for the level value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set level value
     */
    public function getLevel()
    {
        return $this->tree_level;
    }

    /**
     * Proxy getter method for the scope value of the nested set model.
     * It provides a generic way to get the value, whatever the actual column name is.
     *
     * @return     int The nested set scope value
     */
    public function getScopeValue()
    {
        return $this->versionid;
    }

    /**
     * Proxy setter method for the left value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set left value
     * @return     Position The current object (for fluent API support)
     */
    public function setLeftValue($v)
    {
        return $this->setTreeLeft($v);
    }

    /**
     * Proxy setter method for the right value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set right value
     * @return     Position The current object (for fluent API support)
     */
    public function setRightValue($v)
    {
        return $this->setTreeRight($v);
    }

    /**
     * Proxy setter method for the level value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set level value
     * @return     Position The current object (for fluent API support)
     */
    public function setLevel($v)
    {
        return $this->setTreeLevel($v);
    }

    /**
     * Proxy setter method for the scope value of the nested set model.
     * It provides a generic way to set the value, whatever the actual column name is.
     *
     * @param      int $v The nested set scope value
     * @return     Position The current object (for fluent API support)
     */
    public function setScopeValue($v)
    {
        return $this->setVersionid($v);
    }

    /**
     * Creates the supplied node as the root node.
     *
     * @return     Position The current object (for fluent API support)
     * @throws     PropelException
     */
    public function makeRoot()
    {
        if ($this->getLeftValue() || $this->getRightValue()) {
            throw new PropelException('Cannot turn an existing node into a root node.');
        }

        $this->setLeftValue(1);
        $this->setRightValue(2);
        $this->setLevel(0);

        return $this;
    }

    /**
     * Tests if onbject is a node, i.e. if it is inserted in the tree
     *
     * @return     bool
     */
    public function isInTree()
    {
        return $this->getLeftValue() > 0 && $this->getRightValue() > $this->getLeftValue();
    }

    /**
     * Tests if node is a root
     *
     * @return     bool
     */
    public function isRoot()
    {
        return $this->isInTree() && $this->getLeftValue() == 1;
    }

    /**
     * Tests if node is a leaf
     *
     * @return     bool
     */
    public function isLeaf()
    {
        return $this->isInTree() &&  ($this->getRightValue() - $this->getLeftValue()) == 1;
    }

    /**
     * Tests if node is a descendant of another node
     *
     * @param      Position $node Propel node object
     * @return     bool
     */
    public function isDescendantOf($parent)
    {
        if ($this->getScopeValue() !== $parent->getScopeValue()) {
            throw new PropelException('Comparing two nodes of different trees');
        }

        return $this->isInTree() && $this->getLeftValue() > $parent->getLeftValue() && $this->getRightValue() < $parent->getRightValue();
    }

    /**
     * Tests if node is a ancestor of another node
     *
     * @param      Position $node Propel node object
     * @return     bool
     */
    public function isAncestorOf($child)
    {
        return $child->isDescendantOf($this);
    }

    /**
     * Tests if object has an ancestor
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasParent(PropelPDO $con = null)
    {
        return $this->getLevel() > 0;
    }

    /**
     * Sets the cache for parent node of the current object.
     * Warning: this does not move the current object in the tree.
     * Use moveTofirstChildOf() or moveToLastChildOf() for that purpose
     *
     * @param      Position $parent
     * @return     Position The current object, for fluid interface
     */
    public function setParent($parent = null)
    {
        $this->aNestedSetParent = $parent;

        return $this;
    }

    /**
     * Gets parent node for the current object if it exists
     * The result is cached so further calls to the same method don't issue any queries
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getParent(PropelPDO $con = null)
    {
        if ($this->aNestedSetParent === null && $this->hasParent()) {
            $this->aNestedSetParent = PositionQuery::create()
                ->ancestorsOf($this)
                ->orderByLevel(true)
                ->findOne($con);
        }

        return $this->aNestedSetParent;
    }

    /**
     * Determines if the node has previous sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasPrevSibling(PropelPDO $con = null)
    {
        if (!PositionPeer::isValid($this)) {
            return false;
        }

        return PositionQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets previous sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getPrevSibling(PropelPDO $con = null)
    {
        return PositionQuery::create()
            ->filterByTreeRight($this->getLeftValue() - 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Determines if the node has next sibling
     *
     * @param      PropelPDO $con Connection to use.
     * @return     bool
     */
    public function hasNextSibling(PropelPDO $con = null)
    {
        if (!PositionPeer::isValid($this)) {
            return false;
        }

        return PositionQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->count($con) > 0;
    }

    /**
     * Gets next sibling for the given node if it exists
     *
     * @param      PropelPDO $con Connection to use.
     * @return     mixed 		Propel object if exists else false
     */
    public function getNextSibling(PropelPDO $con = null)
    {
        return PositionQuery::create()
            ->filterByTreeLeft($this->getRightValue() + 1)
            ->inTree($this->getScopeValue())
            ->findOne($con);
    }

    /**
     * Clears out the $collNestedSetChildren collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return     void
     */
    public function clearNestedSetChildren()
    {
        $this->collNestedSetChildren = null;
    }

    /**
     * Initializes the $collNestedSetChildren collection.
     *
     * @return     void
     */
    public function initNestedSetChildren()
    {
        $this->collNestedSetChildren = new PropelObjectCollection();
        $this->collNestedSetChildren->setModel('Position');
    }

    /**
     * Adds an element to the internal $collNestedSetChildren collection.
     * Beware that this doesn't insert a node in the tree.
     * This method is only used to facilitate children hydration.
     *
     * @param      Position $position
     *
     * @return     void
     */
    public function addNestedSetChild($position)
    {
        if ($this->collNestedSetChildren === null) {
            $this->initNestedSetChildren();
        }
        if (!$this->collNestedSetChildren->contains($position)) { // only add it if the **same** object is not already associated
            $this->collNestedSetChildren[]= $position;
            $position->setParent($this);
        }
    }

    /**
     * Tests if node has children
     *
     * @return     bool
     */
    public function hasChildren()
    {
        return ($this->getRightValue() - $this->getLeftValue()) > 1;
    }

    /**
     * Gets the children of the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array     List of Position objects
     */
    public function getChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                // return empty collection
                $this->initNestedSetChildren();
            } else {
                $collNestedSetChildren = PositionQuery::create(null, $criteria)
                  ->childrenOf($this)
                  ->orderByBranch()
                    ->find($con);
                if (null !== $criteria) {
                    return $collNestedSetChildren;
                }
                $this->collNestedSetChildren = $collNestedSetChildren;
            }
        }

        return $this->collNestedSetChildren;
    }

    /**
     * Gets number of children for the given node
     *
     * @param      Criteria  $criteria Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int       Number of children
     */
    public function countChildren($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collNestedSetChildren || null !== $criteria) {
            if ($this->isLeaf() || ($this->isNew() && null === $this->collNestedSetChildren)) {
                return 0;
            } else {
                return PositionQuery::create(null, $criteria)
                    ->childrenOf($this)
                    ->count($con);
            }
        } else {
            return count($this->collNestedSetChildren);
        }
    }

    /**
     * Gets the first child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Position objects
     */
    public function getFirstChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return PositionQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch()
                ->findOne($con);
        }
    }

    /**
     * Gets the last child of the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Position objects
     */
    public function getLastChild($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return PositionQuery::create(null, $query)
                ->childrenOf($this)
                ->orderByBranch(true)
                ->findOne($con);
        }
    }

    /**
     * Gets the siblings of the given node
     *
     * @param      bool			$includeNode Whether to include the current node or not
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     *
     * @return     array 		List of Position objects
     */
    public function getSiblings($includeNode = false, $query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            return array();
        } else {
             $query = PositionQuery::create(null, $query)
                    ->childrenOf($this->getParent($con))
                    ->orderByBranch();
            if (!$includeNode) {
                $query->prune($this);
            }

            return $query->find($con);
        }
    }

    /**
     * Gets descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Position objects
     */
    public function getDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            return array();
        } else {
            return PositionQuery::create(null, $query)
                ->descendantsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Gets number of descendants for the given node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     int 		Number of descendants
     */
    public function countDescendants($query = null, PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return 0;
        } else {
            return PositionQuery::create(null, $query)
                ->descendantsOf($this)
                ->count($con);
        }
    }

    /**
     * Gets descendants for the given node, plus the current node
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Position objects
     */
    public function getBranch($query = null, PropelPDO $con = null)
    {
        return PositionQuery::create(null, $query)
            ->branchOf($this)
            ->orderByBranch()
            ->find($con);
    }

    /**
     * Gets ancestors for the given node, starting with the root node
     * Use it for breadcrumb paths for instance
     *
     * @param      Criteria $query Criteria to filter results.
     * @param      PropelPDO $con Connection to use.
     * @return     array 		List of Position objects
     */
    public function getAncestors($query = null, PropelPDO $con = null)
    {
        if ($this->isRoot()) {
            // save one query
            return array();
        } else {
            return PositionQuery::create(null, $query)
                ->ancestorsOf($this)
                ->orderByBranch()
                ->find($con);
        }
    }

    /**
     * Inserts the given $child node as first child of current
     * The modifications in the current object and the tree
     * are not persisted until the child object is saved.
     *
     * @param      Position $child	Propel object for child node
     *
     * @return     Position The current Propel object
     */
    public function addChild(Position $child)
    {
        if ($this->isNew()) {
            throw new PropelException('A Position object must not be new to accept children.');
        }
        $child->insertAsFirstChildOf($this);

        return $this;
    }

    /**
     * Inserts the current node as first child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Position $parent	Propel object for parent node
     *
     * @return     Position The current Propel object
     */
    public function insertAsFirstChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Position object must not already be in the tree to be inserted. Use the moveToFirstChildOf() instead.');
        }
        $left = $parent->getLeftValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('PositionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as last child of given $parent node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Position $parent	Propel object for parent node
     *
     * @return     Position The current Propel object
     */
    public function insertAsLastChildOf($parent)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Position object must not already be in the tree to be inserted. Use the moveToLastChildOf() instead.');
        }
        $left = $parent->getRightValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($parent->getLevel() + 1);
        $scope = $parent->getScopeValue();
        $this->setScopeValue($scope);
        // update the children collection of the parent
        $parent->addNestedSetChild($this);

        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('PositionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as prev sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Position $sibling	Propel object for parent node
     *
     * @return     Position The current Propel object
     */
    public function insertAsPrevSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Position object must not already be in the tree to be inserted. Use the moveToPrevSiblingOf() instead.');
        }
        $left = $sibling->getLeftValue();
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('PositionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Inserts the current node as next sibling given $sibling node
     * The modifications in the current object and the tree
     * are not persisted until the current object is saved.
     *
     * @param      Position $sibling	Propel object for parent node
     *
     * @return     Position The current Propel object
     */
    public function insertAsNextSiblingOf($sibling)
    {
        if ($this->isInTree()) {
            throw new PropelException('A Position object must not already be in the tree to be inserted. Use the moveToNextSiblingOf() instead.');
        }
        $left = $sibling->getRightValue() + 1;
        // Update node properties
        $this->setLeftValue($left);
        $this->setRightValue($left + 1);
        $this->setLevel($sibling->getLevel());
        $scope = $sibling->getScopeValue();
        $this->setScopeValue($scope);
        // Keep the tree modification query for the save() transaction
        $this->nestedSetQueries []= array(
            'callable'  => array('PositionPeer', 'makeRoomForLeaf'),
            'arguments' => array($left, $scope, $this->isNew() ? null : $this)
        );

        return $this;
    }

    /**
     * Moves current node and its subtree to be the first child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      Position $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Position The current Propel object
     */
    public function moveToFirstChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Position object must be already in the tree to be moved. Use the insertAsFirstChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getLeftValue() + 1, $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the last child of $parent
     * The modifications in the current object and the tree are immediate
     *
     * @param      Position $parent	Propel object for parent node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Position The current Propel object
     */
    public function moveToLastChildOf($parent, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Position object must be already in the tree to be moved. Use the insertAsLastChildOf() instead.');
        }
        if ($parent->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($parent->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as child of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($parent->getRightValue(), $parent->getLevel() - $this->getLevel() + 1, $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the previous sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      Position $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Position The current Propel object
     */
    public function moveToPrevSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Position object must be already in the tree to be moved. Use the insertAsPrevSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to previous sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getLeftValue(), $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Moves current node and its subtree to be the next sibling of $sibling
     * The modifications in the current object and the tree are immediate
     *
     * @param      Position $sibling	Propel object for sibling node
     * @param      PropelPDO $con	Connection to use.
     *
     * @return     Position The current Propel object
     */
    public function moveToNextSiblingOf($sibling, PropelPDO $con = null)
    {
        if (!$this->isInTree()) {
            throw new PropelException('A Position object must be already in the tree to be moved. Use the insertAsNextSiblingOf() instead.');
        }
        if ($sibling->isRoot()) {
            throw new PropelException('Cannot move to next sibling of a root node.');
        }
        if ($sibling->getScopeValue() != $this->getScopeValue()) {
            throw new PropelException('Moving nodes across trees is not supported');
        }
        if ($sibling->isDescendantOf($this)) {
            throw new PropelException('Cannot move a node as sibling of one of its subtree nodes.');
        }

        $this->moveSubtreeTo($sibling->getRightValue() + 1, $sibling->getLevel() - $this->getLevel(), $con);

        return $this;
    }

    /**
     * Move current node and its children to location $destLeft and updates rest of tree
     *
     * @param      int	$destLeft Destination left value
     * @param      int	$levelDelta Delta to add to the levels
     * @param      PropelPDO $con		Connection to use.
     */
    protected function moveSubtreeTo($destLeft, $levelDelta, PropelPDO $con = null)
    {
        $left  = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();

        $treeSize = $right - $left +1;

        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            // make room next to the target for the subtree
            PositionPeer::shiftRLValues($treeSize, $destLeft, null, $scope, $con);

            if ($left >= $destLeft) { // src was shifted too?
                $left += $treeSize;
                $right += $treeSize;
            }

            if ($levelDelta) {
                // update the levels of the subtree
                PositionPeer::shiftLevel($levelDelta, $left, $right, $scope, $con);
            }

            // move the subtree to the target
            PositionPeer::shiftRLValues($destLeft - $left, $left, $right, $scope, $con);

            // remove the empty room at the previous location of the subtree
            PositionPeer::shiftRLValues(-$treeSize, $right + 1, null, $scope, $con);

            // update all loaded nodes
            PositionPeer::updateLoadedNodes(null, $con);

            $con->commit();
        } catch (PropelException $e) {
            $con->rollback();
            throw $e;
        }
    }

    /**
     * Deletes all descendants for the given node
     * Instance pooling is wiped out by this command,
     * so existing Position instances are probably invalid (except for the current one)
     *
     * @param      PropelPDO $con Connection to use.
     *
     * @return     int 		number of deleted nodes
     */
    public function deleteDescendants(PropelPDO $con = null)
    {
        if ($this->isLeaf()) {
            // save one query
            return;
        }
        if ($con === null) {
            $con = Propel::getConnection(PositionPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $left = $this->getLeftValue();
        $right = $this->getRightValue();
        $scope = $this->getScopeValue();
        $con->beginTransaction();
        try {
            // delete descendant nodes (will empty the instance pool)
            $ret = PositionQuery::create()
                ->descendantsOf($this)
                ->delete($con);

            // fill up the room that was used by descendants
            PositionPeer::shiftRLValues($left - $right + 1, $right, null, $scope, $con);

            // fix the right value for the current node, which is now a leaf
            $this->setRightValue($left + 1);

            $con->commit();
        } catch (Exception $e) {
            $con->rollback();
            throw $e;
        }

        return $ret;
    }

    /**
     * Returns a pre-order iterator for this node and its children.
     *
     * @return     RecursiveIterator
     */
    public function getIterator()
    {
        return new NestedSetRecursiveIterator($this);
    }

}
