<?php

/**
 * PositionsInclude
 *
 * @package positions
 */
class PositionsInclude extends PositionPeer {

	function getHome($options) {
		$positionsLatetsVersion = PositionPeer::getLatestVersion();

/*		$positions = Positionquery::create()->filterByVersionId($positionsLatetsVersion)
																				->filterByType($options["type"])
																					->_or()
																				->filterByPlanning(1)
																				->find();
*/


		$positionQuery = Positionquery::create()->filterByVersionId($positionsLatetsVersion)
																				->filterByType($options["type"])
																					->_or()
																				->filterByPlanning(1);


		if (ConfigModule::get('users', 'useFilterByUserGroup')) {
			$user = Common::getAdminLogged();
			if (!empty($user) && !$user->isAdmin() && !$user->isSupervisor()) {
				$userGroupsIds = Common::getAdminGroupsIds();
				$positionQuery->filterByUsergroupid($userGroupsIds, Criteria::IN);
			}
		}



//		$positionPeer = new PositionPeer();
//		$positionPeer->setSearchType($options["type"]);
//		$positionPeer->setSearchVersion($positionsLatetsVersion);
//		$positions = $positionPeer->getAllFiltered();
		return $positionQuery->find();
	}

} // PositionsInclude
