<?php


/**
 * Base class that represents a query for the 'panel_missionParticipant' table.
 *
 * Base de participantes en misiones
 *
 * @method MissionParticipantQuery orderById($order = Criteria::ASC) Order by the id column
 * @method MissionParticipantQuery orderByMissionid($order = Criteria::ASC) Order by the missionId column
 * @method MissionParticipantQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method MissionParticipantQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 *
 * @method MissionParticipantQuery groupById() Group by the id column
 * @method MissionParticipantQuery groupByMissionid() Group by the missionId column
 * @method MissionParticipantQuery groupByObjecttype() Group by the objectType column
 * @method MissionParticipantQuery groupByObjectid() Group by the objectId column
 *
 * @method MissionParticipantQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionParticipantQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionParticipantQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionParticipantQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method MissionParticipantQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method MissionParticipantQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method MissionParticipantQuery leftJoinMissionCommitment($relationAlias = null) Adds a LEFT JOIN clause to the query using the MissionCommitment relation
 * @method MissionParticipantQuery rightJoinMissionCommitment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MissionCommitment relation
 * @method MissionParticipantQuery innerJoinMissionCommitment($relationAlias = null) Adds a INNER JOIN clause to the query using the MissionCommitment relation
 *
 * @method MissionParticipant findOne(PropelPDO $con = null) Return the first MissionParticipant matching the query
 * @method MissionParticipant findOneOrCreate(PropelPDO $con = null) Return the first MissionParticipant matching the query, or a new MissionParticipant object populated from the query conditions when no match is found
 *
 * @method MissionParticipant findOneById(int $id) Return the first MissionParticipant filtered by the id column
 * @method MissionParticipant findOneByMissionid(int $missionId) Return the first MissionParticipant filtered by the missionId column
 * @method MissionParticipant findOneByObjecttype(string $objectType) Return the first MissionParticipant filtered by the objectType column
 * @method MissionParticipant findOneByObjectid(int $objectId) Return the first MissionParticipant filtered by the objectId column
 *
 * @method array findById(int $id) Return MissionParticipant objects filtered by the id column
 * @method array findByMissionid(int $missionId) Return MissionParticipant objects filtered by the missionId column
 * @method array findByObjecttype(string $objectType) Return MissionParticipant objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return MissionParticipant objects filtered by the objectId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionParticipantQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseMissionParticipantQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'MissionParticipant', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionParticipantQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionParticipantQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionParticipantQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionParticipantQuery) {
            return $criteria;
        }
        $query = new MissionParticipantQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   MissionParticipant|MissionParticipant[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionParticipantPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionParticipantPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   MissionParticipant A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `MISSIONID`, `OBJECTTYPE`, `OBJECTID` FROM `panel_missionParticipant` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new MissionParticipant();
            $obj->hydrate($row);
            MissionParticipantPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return MissionParticipant|MissionParticipant[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|MissionParticipant[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MissionParticipantPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MissionParticipantPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionParticipantPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the missionId column
     *
     * Example usage:
     * <code>
     * $query->filterByMissionid(1234); // WHERE missionId = 1234
     * $query->filterByMissionid(array(12, 34)); // WHERE missionId IN (12, 34)
     * $query->filterByMissionid(array('min' => 12)); // WHERE missionId > 12
     * </code>
     *
     * @see       filterByMission()
     *
     * @param     mixed $missionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterByMissionid($missionid = null, $comparison = null)
    {
        if (is_array($missionid)) {
            $useMinMax = false;
            if (isset($missionid['min'])) {
                $this->addUsingAlias(MissionParticipantPeer::MISSIONID, $missionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($missionid['max'])) {
                $this->addUsingAlias(MissionParticipantPeer::MISSIONID, $missionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionParticipantPeer::MISSIONID, $missionid, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionParticipantPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(MissionParticipantPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(MissionParticipantPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionParticipantPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionParticipantQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(MissionParticipantPeer::MISSIONID, $mission->getId(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionParticipantPeer::MISSIONID, $mission->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related MissionCommitment object
     *
     * @param   MissionCommitment|PropelObjectCollection $missionCommitment  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionParticipantQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMissionCommitment($missionCommitment, $comparison = null)
    {
        if ($missionCommitment instanceof MissionCommitment) {
            return $this
                ->addUsingAlias(MissionParticipantPeer::ID, $missionCommitment->getParticipantid(), $comparison);
        } elseif ($missionCommitment instanceof PropelObjectCollection) {
            return $this
                ->useMissionCommitmentQuery()
                ->filterByPrimaryKeys($missionCommitment->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMissionCommitment() only accepts arguments of type MissionCommitment or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MissionCommitment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function joinMissionCommitment($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MissionCommitment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MissionCommitment');
        }

        return $this;
    }

    /**
     * Use the MissionCommitment relation MissionCommitment object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionCommitmentQuery A secondary query class using the current class as primary query
     */
    public function useMissionCommitmentQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMissionCommitment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MissionCommitment', 'MissionCommitmentQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   MissionParticipant $missionParticipant Object to remove from the list of results
     *
     * @return MissionParticipantQuery The current query, for fluid interface
     */
    public function prune($missionParticipant = null)
    {
        if ($missionParticipant) {
            $this->addUsingAlias(MissionParticipantPeer::ID, $missionParticipant->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
