<?php


/**
 * Base class that represents a row from the 'panel_administrativeAct' table.
 *
 * Base de Actos Administrativos
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseAdministrativeAct extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'AdministrativeActPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        AdministrativeActPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the type field.
     * @var        int
     */
    protected $type;

    /**
     * The value for the object field.
     * @var        string
     */
    protected $object;

    /**
     * The value for the actdate field.
     * @var        string
     */
    protected $actdate;

    /**
     * The value for the description field.
     * @var        string
     */
    protected $description;

    /**
     * The value for the projectid field.
     * @var        int
     */
    protected $projectid;

    /**
     * The value for the deleted_at field.
     * @var        string
     */
    protected $deleted_at;

    /**
     * @var        Project
     */
    protected $aProject;

    /**
     * @var        PropelObjectCollection|AdminActParticipant[] Collection to store aggregation of AdminActParticipant objects.
     */
    protected $collAdminActParticipants;
    protected $collAdminActParticipantsPartial;

    /**
     * @var        PropelObjectCollection|AdministrativeActDocument[] Collection to store aggregation of AdministrativeActDocument objects.
     */
    protected $collAdministrativeActDocuments;
    protected $collAdministrativeActDocumentsPartial;

    /**
     * @var        PropelObjectCollection|Document[] Collection to store aggregation of Document objects.
     */
    protected $collDocuments;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $documentsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $adminActParticipantsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $administrativeActDocumentsScheduledForDeletion = null;

    /**
     * Get the [id] column value.
     * Identificacion del Acto Administrativo
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [type] column value.
     * Tipo de acto
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [object] column value.
     * Objeto del Acto
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Get the [optionally formatted] temporal [actdate] column value.
     * Fecha del acto
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getActdate($format = '%Y/%m/%d')
    {
        if ($this->actdate === null) {
            return null;
        }

        if ($this->actdate === '0000-00-00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->actdate);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->actdate, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Get the [description] column value.
     * Descripcion del Acto
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the [projectid] column value.
     * Id del proyecto
     * @return int
     */
    public function getProjectid()
    {
        return $this->projectid;
    }

    /**
     * Get the [optionally formatted] temporal [deleted_at] column value.
     *
     *
     * @param string $format The date/time format string (either date()-style or strftime()-style).
     *				 If format is null, then the raw DateTime object will be returned.
     * @return mixed Formatted date/time value as string or DateTime object (if format is null), null if column is null, and 0 if column value is 0000-00-00 00:00:00
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDeletedAt($format = 'Y-m-d H:i:s')
    {
        if ($this->deleted_at === null) {
            return null;
        }

        if ($this->deleted_at === '0000-00-00 00:00:00') {
            // while technically this is not a default value of null,
            // this seems to be closest in meaning.
            return null;
        } else {
            try {
                $dt = new DateTime($this->deleted_at);
            } catch (Exception $x) {
                throw new PropelException("Internally stored date/time/timestamp value could not be converted to DateTime: " . var_export($this->deleted_at, true), $x);
            }
        }

        if ($format === null) {
            // Because propel.useDateTimeClass is true, we return a DateTime object.
            return $dt;
        } elseif (strpos($format, '%') !== false) {
            return strftime($format, $dt->format('U'));
        } else {
            return $dt->format($format);
        }
    }

    /**
     * Set the value of [id] column.
     * Identificacion del Acto Administrativo
     * @param int $v new value
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = AdministrativeActPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [type] column.
     * Tipo de acto
     * @param int $v new value
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[] = AdministrativeActPeer::TYPE;
        }


        return $this;
    } // setType()

    /**
     * Set the value of [object] column.
     * Objeto del Acto
     * @param string $v new value
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setObject($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->object !== $v) {
            $this->object = $v;
            $this->modifiedColumns[] = AdministrativeActPeer::OBJECT;
        }


        return $this;
    } // setObject()

    /**
     * Sets the value of [actdate] column to a normalized version of the date/time value specified.
     * Fecha del acto
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setActdate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->actdate !== null || $dt !== null) {
            $currentDateAsString = ($this->actdate !== null && $tmpDt = new DateTime($this->actdate)) ? $tmpDt->format('Y-m-d') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->actdate = $newDateAsString;
                $this->modifiedColumns[] = AdministrativeActPeer::ACTDATE;
            }
        } // if either are not null


        return $this;
    } // setActdate()

    /**
     * Set the value of [description] column.
     * Descripcion del Acto
     * @param string $v new value
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->description !== $v) {
            $this->description = $v;
            $this->modifiedColumns[] = AdministrativeActPeer::DESCRIPTION;
        }


        return $this;
    } // setDescription()

    /**
     * Set the value of [projectid] column.
     * Id del proyecto
     * @param int $v new value
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setProjectid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->projectid !== $v) {
            $this->projectid = $v;
            $this->modifiedColumns[] = AdministrativeActPeer::PROJECTID;
        }

        if ($this->aProject !== null && $this->aProject->getId() !== $v) {
            $this->aProject = null;
        }


        return $this;
    } // setProjectid()

    /**
     * Sets the value of [deleted_at] column to a normalized version of the date/time value specified.
     *
     * @param mixed $v string, integer (timestamp), or DateTime value.
     *               Empty strings are treated as null.
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function setDeletedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->deleted_at !== null || $dt !== null) {
            $currentDateAsString = ($this->deleted_at !== null && $tmpDt = new DateTime($this->deleted_at)) ? $tmpDt->format('Y-m-d H:i:s') : null;
            $newDateAsString = $dt ? $dt->format('Y-m-d H:i:s') : null;
            if ($currentDateAsString !== $newDateAsString) {
                $this->deleted_at = $newDateAsString;
                $this->modifiedColumns[] = AdministrativeActPeer::DELETED_AT;
            }
        } // if either are not null


        return $this;
    } // setDeletedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->type = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->object = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->actdate = ($row[$startcol + 3] !== null) ? (string) $row[$startcol + 3] : null;
            $this->description = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->projectid = ($row[$startcol + 5] !== null) ? (int) $row[$startcol + 5] : null;
            $this->deleted_at = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 7; // 7 = AdministrativeActPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating AdministrativeAct object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aProject !== null && $this->projectid !== $this->aProject->getId()) {
            $this->aProject = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AdministrativeActPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = AdministrativeActPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aProject = null;
            $this->collAdminActParticipants = null;

            $this->collAdministrativeActDocuments = null;

            $this->collDocuments = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AdministrativeActPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = AdministrativeActQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // soft_delete behavior
            if (!empty($ret) && AdministrativeActQuery::isSoftDeleteEnabled()) {
                $this->setDeletedAt(time());
                $this->save($con);
                $this->postDelete($con);
                $con->commit();
                AdministrativeActPeer::removeInstanceFromPool($this);

                return;
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(AdministrativeActPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                AdministrativeActPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if ($this->aProject->isModified() || $this->aProject->isNew()) {
                    $affectedRows += $this->aProject->save($con);
                }
                $this->setProject($this->aProject);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->documentsScheduledForDeletion !== null) {
                if (!$this->documentsScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    $pk = $this->getPrimaryKey();
                    foreach ($this->documentsScheduledForDeletion->getPrimaryKeys(false) as $remotePk) {
                        $pks[] = array($pk, $remotePk);
                    }
                    AdministrativeActDocumentQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);
                    $this->documentsScheduledForDeletion = null;
                }

                foreach ($this->getDocuments() as $document) {
                    if ($document->isModified()) {
                        $document->save($con);
                    }
                }
            }

            if ($this->adminActParticipantsScheduledForDeletion !== null) {
                if (!$this->adminActParticipantsScheduledForDeletion->isEmpty()) {
                    AdminActParticipantQuery::create()
                        ->filterByPrimaryKeys($this->adminActParticipantsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->adminActParticipantsScheduledForDeletion = null;
                }
            }

            if ($this->collAdminActParticipants !== null) {
                foreach ($this->collAdminActParticipants as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->administrativeActDocumentsScheduledForDeletion !== null) {
                if (!$this->administrativeActDocumentsScheduledForDeletion->isEmpty()) {
                    AdministrativeActDocumentQuery::create()
                        ->filterByPrimaryKeys($this->administrativeActDocumentsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->administrativeActDocumentsScheduledForDeletion = null;
                }
            }

            if ($this->collAdministrativeActDocuments !== null) {
                foreach ($this->collAdministrativeActDocuments as $referrerFK) {
                    if (!$referrerFK->isDeleted()) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = AdministrativeActPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . AdministrativeActPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(AdministrativeActPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`TYPE`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::OBJECT)) {
            $modifiedColumns[':p' . $index++]  = '`OBJECT`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::ACTDATE)) {
            $modifiedColumns[':p' . $index++]  = '`ACTDATE`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`DESCRIPTION`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::PROJECTID)) {
            $modifiedColumns[':p' . $index++]  = '`PROJECTID`';
        }
        if ($this->isColumnModified(AdministrativeActPeer::DELETED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`DELETED_AT`';
        }

        $sql = sprintf(
            'INSERT INTO `panel_administrativeAct` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`TYPE`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_INT);
                        break;
                    case '`OBJECT`':
                        $stmt->bindValue($identifier, $this->object, PDO::PARAM_STR);
                        break;
                    case '`ACTDATE`':
                        $stmt->bindValue($identifier, $this->actdate, PDO::PARAM_STR);
                        break;
                    case '`DESCRIPTION`':
                        $stmt->bindValue($identifier, $this->description, PDO::PARAM_STR);
                        break;
                    case '`PROJECTID`':
                        $stmt->bindValue($identifier, $this->projectid, PDO::PARAM_INT);
                        break;
                    case '`DELETED_AT`':
                        $stmt->bindValue($identifier, $this->deleted_at, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aProject !== null) {
                if (!$this->aProject->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aProject->getValidationFailures());
                }
            }


            if (($retval = AdministrativeActPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collAdminActParticipants !== null) {
                    foreach ($this->collAdminActParticipants as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collAdministrativeActDocuments !== null) {
                    foreach ($this->collAdministrativeActDocuments as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = AdministrativeActPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getType();
                break;
            case 2:
                return $this->getObject();
                break;
            case 3:
                return $this->getActdate();
                break;
            case 4:
                return $this->getDescription();
                break;
            case 5:
                return $this->getProjectid();
                break;
            case 6:
                return $this->getDeletedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['AdministrativeAct'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['AdministrativeAct'][$this->getPrimaryKey()] = true;
        $keys = AdministrativeActPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getType(),
            $keys[2] => $this->getObject(),
            $keys[3] => $this->getActdate(),
            $keys[4] => $this->getDescription(),
            $keys[5] => $this->getProjectid(),
            $keys[6] => $this->getDeletedAt(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aProject) {
                $result['Project'] = $this->aProject->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collAdminActParticipants) {
                $result['AdminActParticipants'] = $this->collAdminActParticipants->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collAdministrativeActDocuments) {
                $result['AdministrativeActDocuments'] = $this->collAdministrativeActDocuments->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = AdministrativeActPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setType($value);
                break;
            case 2:
                $this->setObject($value);
                break;
            case 3:
                $this->setActdate($value);
                break;
            case 4:
                $this->setDescription($value);
                break;
            case 5:
                $this->setProjectid($value);
                break;
            case 6:
                $this->setDeletedAt($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = AdministrativeActPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setType($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setObject($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setActdate($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setDescription($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setProjectid($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setDeletedAt($arr[$keys[6]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(AdministrativeActPeer::DATABASE_NAME);

        if ($this->isColumnModified(AdministrativeActPeer::ID)) $criteria->add(AdministrativeActPeer::ID, $this->id);
        if ($this->isColumnModified(AdministrativeActPeer::TYPE)) $criteria->add(AdministrativeActPeer::TYPE, $this->type);
        if ($this->isColumnModified(AdministrativeActPeer::OBJECT)) $criteria->add(AdministrativeActPeer::OBJECT, $this->object);
        if ($this->isColumnModified(AdministrativeActPeer::ACTDATE)) $criteria->add(AdministrativeActPeer::ACTDATE, $this->actdate);
        if ($this->isColumnModified(AdministrativeActPeer::DESCRIPTION)) $criteria->add(AdministrativeActPeer::DESCRIPTION, $this->description);
        if ($this->isColumnModified(AdministrativeActPeer::PROJECTID)) $criteria->add(AdministrativeActPeer::PROJECTID, $this->projectid);
        if ($this->isColumnModified(AdministrativeActPeer::DELETED_AT)) $criteria->add(AdministrativeActPeer::DELETED_AT, $this->deleted_at);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(AdministrativeActPeer::DATABASE_NAME);
        $criteria->add(AdministrativeActPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of AdministrativeAct (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setType($this->getType());
        $copyObj->setObject($this->getObject());
        $copyObj->setActdate($this->getActdate());
        $copyObj->setDescription($this->getDescription());
        $copyObj->setProjectid($this->getProjectid());
        $copyObj->setDeletedAt($this->getDeletedAt());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getAdminActParticipants() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAdminActParticipant($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getAdministrativeActDocuments() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addAdministrativeActDocument($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return AdministrativeAct Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return AdministrativeActPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new AdministrativeActPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Project object.
     *
     * @param             Project $v
     * @return AdministrativeAct The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProject(Project $v = null)
    {
        if ($v === null) {
            $this->setProjectid(NULL);
        } else {
            $this->setProjectid($v->getId());
        }

        $this->aProject = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Project object, it will not be re-added.
        if ($v !== null) {
            $v->addAdministrativeAct($this);
        }


        return $this;
    }


    /**
     * Get the associated Project object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Project The associated Project object.
     * @throws PropelException
     */
    public function getProject(PropelPDO $con = null)
    {
        if ($this->aProject === null && ($this->projectid !== null)) {
            $this->aProject = ProjectQuery::create()->findPk($this->projectid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProject->addAdministrativeActs($this);
             */
        }

        return $this->aProject;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('AdminActParticipant' == $relationName) {
            $this->initAdminActParticipants();
        }
        if ('AdministrativeActDocument' == $relationName) {
            $this->initAdministrativeActDocuments();
        }
    }

    /**
     * Clears out the collAdminActParticipants collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAdminActParticipants()
     */
    public function clearAdminActParticipants()
    {
        $this->collAdminActParticipants = null; // important to set this to null since that means it is uninitialized
        $this->collAdminActParticipantsPartial = null;
    }

    /**
     * reset is the collAdminActParticipants collection loaded partially
     *
     * @return void
     */
    public function resetPartialAdminActParticipants($v = true)
    {
        $this->collAdminActParticipantsPartial = $v;
    }

    /**
     * Initializes the collAdminActParticipants collection.
     *
     * By default this just sets the collAdminActParticipants collection to an empty array (like clearcollAdminActParticipants());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAdminActParticipants($overrideExisting = true)
    {
        if (null !== $this->collAdminActParticipants && !$overrideExisting) {
            return;
        }
        $this->collAdminActParticipants = new PropelObjectCollection();
        $this->collAdminActParticipants->setModel('AdminActParticipant');
    }

    /**
     * Gets an array of AdminActParticipant objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this AdministrativeAct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AdminActParticipant[] List of AdminActParticipant objects
     * @throws PropelException
     */
    public function getAdminActParticipants($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAdminActParticipantsPartial && !$this->isNew();
        if (null === $this->collAdminActParticipants || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAdminActParticipants) {
                // return empty collection
                $this->initAdminActParticipants();
            } else {
                $collAdminActParticipants = AdminActParticipantQuery::create(null, $criteria)
                    ->filterByAdministrativeAct($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAdminActParticipantsPartial && count($collAdminActParticipants)) {
                      $this->initAdminActParticipants(false);

                      foreach($collAdminActParticipants as $obj) {
                        if (false == $this->collAdminActParticipants->contains($obj)) {
                          $this->collAdminActParticipants->append($obj);
                        }
                      }

                      $this->collAdminActParticipantsPartial = true;
                    }

                    return $collAdminActParticipants;
                }

                if($partial && $this->collAdminActParticipants) {
                    foreach($this->collAdminActParticipants as $obj) {
                        if($obj->isNew()) {
                            $collAdminActParticipants[] = $obj;
                        }
                    }
                }

                $this->collAdminActParticipants = $collAdminActParticipants;
                $this->collAdminActParticipantsPartial = false;
            }
        }

        return $this->collAdminActParticipants;
    }

    /**
     * Sets a collection of AdminActParticipant objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $adminActParticipants A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAdminActParticipants(PropelCollection $adminActParticipants, PropelPDO $con = null)
    {
        $this->adminActParticipantsScheduledForDeletion = $this->getAdminActParticipants(new Criteria(), $con)->diff($adminActParticipants);

        foreach ($this->adminActParticipantsScheduledForDeletion as $adminActParticipantRemoved) {
            $adminActParticipantRemoved->setAdministrativeAct(null);
        }

        $this->collAdminActParticipants = null;
        foreach ($adminActParticipants as $adminActParticipant) {
            $this->addAdminActParticipant($adminActParticipant);
        }

        $this->collAdminActParticipants = $adminActParticipants;
        $this->collAdminActParticipantsPartial = false;
    }

    /**
     * Returns the number of related AdminActParticipant objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AdminActParticipant objects.
     * @throws PropelException
     */
    public function countAdminActParticipants(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAdminActParticipantsPartial && !$this->isNew();
        if (null === $this->collAdminActParticipants || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAdminActParticipants) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAdminActParticipants());
                }
                $query = AdminActParticipantQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByAdministrativeAct($this)
                    ->count($con);
            }
        } else {
            return count($this->collAdminActParticipants);
        }
    }

    /**
     * Method called to associate a AdminActParticipant object to this object
     * through the AdminActParticipant foreign key attribute.
     *
     * @param    AdminActParticipant $l AdminActParticipant
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function addAdminActParticipant(AdminActParticipant $l)
    {
        if ($this->collAdminActParticipants === null) {
            $this->initAdminActParticipants();
            $this->collAdminActParticipantsPartial = true;
        }
        if (!$this->collAdminActParticipants->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAdminActParticipant($l);
        }

        return $this;
    }

    /**
     * @param	AdminActParticipant $adminActParticipant The adminActParticipant object to add.
     */
    protected function doAddAdminActParticipant($adminActParticipant)
    {
        $this->collAdminActParticipants[]= $adminActParticipant;
        $adminActParticipant->setAdministrativeAct($this);
    }

    /**
     * @param	AdminActParticipant $adminActParticipant The adminActParticipant object to remove.
     */
    public function removeAdminActParticipant($adminActParticipant)
    {
        if ($this->getAdminActParticipants()->contains($adminActParticipant)) {
            $this->collAdminActParticipants->remove($this->collAdminActParticipants->search($adminActParticipant));
            if (null === $this->adminActParticipantsScheduledForDeletion) {
                $this->adminActParticipantsScheduledForDeletion = clone $this->collAdminActParticipants;
                $this->adminActParticipantsScheduledForDeletion->clear();
            }
            $this->adminActParticipantsScheduledForDeletion[]= $adminActParticipant;
            $adminActParticipant->setAdministrativeAct(null);
        }
    }

    /**
     * Clears out the collAdministrativeActDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addAdministrativeActDocuments()
     */
    public function clearAdministrativeActDocuments()
    {
        $this->collAdministrativeActDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collAdministrativeActDocumentsPartial = null;
    }

    /**
     * reset is the collAdministrativeActDocuments collection loaded partially
     *
     * @return void
     */
    public function resetPartialAdministrativeActDocuments($v = true)
    {
        $this->collAdministrativeActDocumentsPartial = $v;
    }

    /**
     * Initializes the collAdministrativeActDocuments collection.
     *
     * By default this just sets the collAdministrativeActDocuments collection to an empty array (like clearcollAdministrativeActDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initAdministrativeActDocuments($overrideExisting = true)
    {
        if (null !== $this->collAdministrativeActDocuments && !$overrideExisting) {
            return;
        }
        $this->collAdministrativeActDocuments = new PropelObjectCollection();
        $this->collAdministrativeActDocuments->setModel('AdministrativeActDocument');
    }

    /**
     * Gets an array of AdministrativeActDocument objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this AdministrativeAct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|AdministrativeActDocument[] List of AdministrativeActDocument objects
     * @throws PropelException
     */
    public function getAdministrativeActDocuments($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActDocumentsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActDocuments || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActDocuments) {
                // return empty collection
                $this->initAdministrativeActDocuments();
            } else {
                $collAdministrativeActDocuments = AdministrativeActDocumentQuery::create(null, $criteria)
                    ->filterByAdministrativeAct($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collAdministrativeActDocumentsPartial && count($collAdministrativeActDocuments)) {
                      $this->initAdministrativeActDocuments(false);

                      foreach($collAdministrativeActDocuments as $obj) {
                        if (false == $this->collAdministrativeActDocuments->contains($obj)) {
                          $this->collAdministrativeActDocuments->append($obj);
                        }
                      }

                      $this->collAdministrativeActDocumentsPartial = true;
                    }

                    return $collAdministrativeActDocuments;
                }

                if($partial && $this->collAdministrativeActDocuments) {
                    foreach($this->collAdministrativeActDocuments as $obj) {
                        if($obj->isNew()) {
                            $collAdministrativeActDocuments[] = $obj;
                        }
                    }
                }

                $this->collAdministrativeActDocuments = $collAdministrativeActDocuments;
                $this->collAdministrativeActDocumentsPartial = false;
            }
        }

        return $this->collAdministrativeActDocuments;
    }

    /**
     * Sets a collection of AdministrativeActDocument objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $administrativeActDocuments A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setAdministrativeActDocuments(PropelCollection $administrativeActDocuments, PropelPDO $con = null)
    {
        $this->administrativeActDocumentsScheduledForDeletion = $this->getAdministrativeActDocuments(new Criteria(), $con)->diff($administrativeActDocuments);

        foreach ($this->administrativeActDocumentsScheduledForDeletion as $administrativeActDocumentRemoved) {
            $administrativeActDocumentRemoved->setAdministrativeAct(null);
        }

        $this->collAdministrativeActDocuments = null;
        foreach ($administrativeActDocuments as $administrativeActDocument) {
            $this->addAdministrativeActDocument($administrativeActDocument);
        }

        $this->collAdministrativeActDocuments = $administrativeActDocuments;
        $this->collAdministrativeActDocumentsPartial = false;
    }

    /**
     * Returns the number of related AdministrativeActDocument objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related AdministrativeActDocument objects.
     * @throws PropelException
     */
    public function countAdministrativeActDocuments(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collAdministrativeActDocumentsPartial && !$this->isNew();
        if (null === $this->collAdministrativeActDocuments || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collAdministrativeActDocuments) {
                return 0;
            } else {
                if($partial && !$criteria) {
                    return count($this->getAdministrativeActDocuments());
                }
                $query = AdministrativeActDocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByAdministrativeAct($this)
                    ->count($con);
            }
        } else {
            return count($this->collAdministrativeActDocuments);
        }
    }

    /**
     * Method called to associate a AdministrativeActDocument object to this object
     * through the AdministrativeActDocument foreign key attribute.
     *
     * @param    AdministrativeActDocument $l AdministrativeActDocument
     * @return AdministrativeAct The current object (for fluent API support)
     */
    public function addAdministrativeActDocument(AdministrativeActDocument $l)
    {
        if ($this->collAdministrativeActDocuments === null) {
            $this->initAdministrativeActDocuments();
            $this->collAdministrativeActDocumentsPartial = true;
        }
        if (!$this->collAdministrativeActDocuments->contains($l)) { // only add it if the **same** object is not already associated
            $this->doAddAdministrativeActDocument($l);
        }

        return $this;
    }

    /**
     * @param	AdministrativeActDocument $administrativeActDocument The administrativeActDocument object to add.
     */
    protected function doAddAdministrativeActDocument($administrativeActDocument)
    {
        $this->collAdministrativeActDocuments[]= $administrativeActDocument;
        $administrativeActDocument->setAdministrativeAct($this);
    }

    /**
     * @param	AdministrativeActDocument $administrativeActDocument The administrativeActDocument object to remove.
     */
    public function removeAdministrativeActDocument($administrativeActDocument)
    {
        if ($this->getAdministrativeActDocuments()->contains($administrativeActDocument)) {
            $this->collAdministrativeActDocuments->remove($this->collAdministrativeActDocuments->search($administrativeActDocument));
            if (null === $this->administrativeActDocumentsScheduledForDeletion) {
                $this->administrativeActDocumentsScheduledForDeletion = clone $this->collAdministrativeActDocuments;
                $this->administrativeActDocumentsScheduledForDeletion->clear();
            }
            $this->administrativeActDocumentsScheduledForDeletion[]= $administrativeActDocument;
            $administrativeActDocument->setAdministrativeAct(null);
        }
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this AdministrativeAct is new, it will return
     * an empty collection; or if this AdministrativeAct has previously
     * been saved, it will retrieve related AdministrativeActDocuments from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in AdministrativeAct.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|AdministrativeActDocument[] List of AdministrativeActDocument objects
     */
    public function getAdministrativeActDocumentsJoinDocument($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = AdministrativeActDocumentQuery::create(null, $criteria);
        $query->joinWith('Document', $join_behavior);

        return $this->getAdministrativeActDocuments($query, $con);
    }

    /**
     * Clears out the collDocuments collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addDocuments()
     */
    public function clearDocuments()
    {
        $this->collDocuments = null; // important to set this to null since that means it is uninitialized
        $this->collDocumentsPartial = null;
    }

    /**
     * Initializes the collDocuments collection.
     *
     * By default this just sets the collDocuments collection to an empty collection (like clearDocuments());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initDocuments()
    {
        $this->collDocuments = new PropelObjectCollection();
        $this->collDocuments->setModel('Document');
    }

    /**
     * Gets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this AdministrativeAct is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param PropelPDO $con Optional connection object
     *
     * @return PropelObjectCollection|Document[] List of Document objects
     */
    public function getDocuments($criteria = null, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                // return empty collection
                $this->initDocuments();
            } else {
                $collDocuments = DocumentQuery::create(null, $criteria)
                    ->filterByAdministrativeAct($this)
                    ->find($con);
                if (null !== $criteria) {
                    return $collDocuments;
                }
                $this->collDocuments = $collDocuments;
            }
        }

        return $this->collDocuments;
    }

    /**
     * Sets a collection of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $documents A Propel collection.
     * @param PropelPDO $con Optional connection object
     */
    public function setDocuments(PropelCollection $documents, PropelPDO $con = null)
    {
        $this->clearDocuments();
        $currentDocuments = $this->getDocuments();

        $this->documentsScheduledForDeletion = $currentDocuments->diff($documents);

        foreach ($documents as $document) {
            if (!$currentDocuments->contains($document)) {
                $this->doAddDocument($document);
            }
        }

        $this->collDocuments = $documents;
    }

    /**
     * Gets the number of Document objects related by a many-to-many relationship
     * to the current object by way of the panel_administrativeActDocument cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param boolean $distinct Set to true to force count distinct
     * @param PropelPDO $con Optional connection object
     *
     * @return int the number of related Document objects
     */
    public function countDocuments($criteria = null, $distinct = false, PropelPDO $con = null)
    {
        if (null === $this->collDocuments || null !== $criteria) {
            if ($this->isNew() && null === $this->collDocuments) {
                return 0;
            } else {
                $query = DocumentQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByAdministrativeAct($this)
                    ->count($con);
            }
        } else {
            return count($this->collDocuments);
        }
    }

    /**
     * Associate a Document object to this object
     * through the panel_administrativeActDocument cross reference table.
     *
     * @param  Document $document The AdministrativeActDocument object to relate
     * @return void
     */
    public function addDocument(Document $document)
    {
        if ($this->collDocuments === null) {
            $this->initDocuments();
        }
        if (!$this->collDocuments->contains($document)) { // only add it if the **same** object is not already associated
            $this->doAddDocument($document);

            $this->collDocuments[]= $document;
        }
    }

    /**
     * @param	Document $document The document object to add.
     */
    protected function doAddDocument($document)
    {
        $administrativeActDocument = new AdministrativeActDocument();
        $administrativeActDocument->setDocument($document);
        $this->addAdministrativeActDocument($administrativeActDocument);
    }

    /**
     * Remove a Document object to this object
     * through the panel_administrativeActDocument cross reference table.
     *
     * @param Document $document The AdministrativeActDocument object to relate
     * @return void
     */
    public function removeDocument(Document $document)
    {
        if ($this->getDocuments()->contains($document)) {
            $this->collDocuments->remove($this->collDocuments->search($document));
            if (null === $this->documentsScheduledForDeletion) {
                $this->documentsScheduledForDeletion = clone $this->collDocuments;
                $this->documentsScheduledForDeletion->clear();
            }
            $this->documentsScheduledForDeletion[]= $document;
        }
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->type = null;
        $this->object = null;
        $this->actdate = null;
        $this->description = null;
        $this->projectid = null;
        $this->deleted_at = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collAdminActParticipants) {
                foreach ($this->collAdminActParticipants as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collAdministrativeActDocuments) {
                foreach ($this->collAdministrativeActDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDocuments) {
                foreach ($this->collDocuments as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        if ($this->collAdminActParticipants instanceof PropelCollection) {
            $this->collAdminActParticipants->clearIterator();
        }
        $this->collAdminActParticipants = null;
        if ($this->collAdministrativeActDocuments instanceof PropelCollection) {
            $this->collAdministrativeActDocuments->clearIterator();
        }
        $this->collAdministrativeActDocuments = null;
        if ($this->collDocuments instanceof PropelCollection) {
            $this->collDocuments->clearIterator();
        }
        $this->collDocuments = null;
        $this->aProject = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(AdministrativeActPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

    // soft_delete behavior

    /**
     * Bypass the soft_delete behavior and force a hard delete of the current object
     */
    public function forceDelete(PropelPDO $con = null)
    {
        if ($isSoftDeleteEnabled = AdministrativeActPeer::isSoftDeleteEnabled()) {
            AdministrativeActPeer::disableSoftDelete();
        }
        $this->delete($con);
        if ($isSoftDeleteEnabled) {
            AdministrativeActPeer::enableSoftDelete();
        }
    }

    /**
     * Undelete a row that was soft_deleted
     *
     * @return		 int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        $this->setDeletedAt(null);

        return $this->save($con);
    }

}
