<?php


/**
 * Base class that represents a query for the 'panel_adminActParticipant' table.
 *
 * Base de participantes en actos administrativos
 *
 * @method AdminActParticipantQuery orderById($order = Criteria::ASC) Order by the id column
 * @method AdminActParticipantQuery orderByAdminactid($order = Criteria::ASC) Order by the adminActId column
 * @method AdminActParticipantQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method AdminActParticipantQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 *
 * @method AdminActParticipantQuery groupById() Group by the id column
 * @method AdminActParticipantQuery groupByAdminactid() Group by the adminActId column
 * @method AdminActParticipantQuery groupByObjecttype() Group by the objectType column
 * @method AdminActParticipantQuery groupByObjectid() Group by the objectId column
 *
 * @method AdminActParticipantQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method AdminActParticipantQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method AdminActParticipantQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method AdminActParticipantQuery leftJoinAdministrativeAct($relationAlias = null) Adds a LEFT JOIN clause to the query using the AdministrativeAct relation
 * @method AdminActParticipantQuery rightJoinAdministrativeAct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the AdministrativeAct relation
 * @method AdminActParticipantQuery innerJoinAdministrativeAct($relationAlias = null) Adds a INNER JOIN clause to the query using the AdministrativeAct relation
 *
 * @method AdminActParticipant findOne(PropelPDO $con = null) Return the first AdminActParticipant matching the query
 * @method AdminActParticipant findOneOrCreate(PropelPDO $con = null) Return the first AdminActParticipant matching the query, or a new AdminActParticipant object populated from the query conditions when no match is found
 *
 * @method AdminActParticipant findOneById(int $id) Return the first AdminActParticipant filtered by the id column
 * @method AdminActParticipant findOneByAdminactid(int $adminActId) Return the first AdminActParticipant filtered by the adminActId column
 * @method AdminActParticipant findOneByObjecttype(string $objectType) Return the first AdminActParticipant filtered by the objectType column
 * @method AdminActParticipant findOneByObjectid(int $objectId) Return the first AdminActParticipant filtered by the objectId column
 *
 * @method array findById(int $id) Return AdminActParticipant objects filtered by the id column
 * @method array findByAdminactid(int $adminActId) Return AdminActParticipant objects filtered by the adminActId column
 * @method array findByObjecttype(string $objectType) Return AdminActParticipant objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return AdminActParticipant objects filtered by the objectId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseAdminActParticipantQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseAdminActParticipantQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'AdminActParticipant', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new AdminActParticipantQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     AdminActParticipantQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return AdminActParticipantQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof AdminActParticipantQuery) {
            return $criteria;
        }
        $query = new AdminActParticipantQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   AdminActParticipant|AdminActParticipant[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = AdminActParticipantPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(AdminActParticipantPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   AdminActParticipant A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `ADMINACTID`, `OBJECTTYPE`, `OBJECTID` FROM `panel_adminActParticipant` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new AdminActParticipant();
            $obj->hydrate($row);
            AdminActParticipantPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return AdminActParticipant|AdminActParticipant[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|AdminActParticipant[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(AdminActParticipantPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(AdminActParticipantPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(AdminActParticipantPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the adminActId column
     *
     * Example usage:
     * <code>
     * $query->filterByAdminactid(1234); // WHERE adminActId = 1234
     * $query->filterByAdminactid(array(12, 34)); // WHERE adminActId IN (12, 34)
     * $query->filterByAdminactid(array('min' => 12)); // WHERE adminActId > 12
     * </code>
     *
     * @see       filterByAdministrativeAct()
     *
     * @param     mixed $adminactid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterByAdminactid($adminactid = null, $comparison = null)
    {
        if (is_array($adminactid)) {
            $useMinMax = false;
            if (isset($adminactid['min'])) {
                $this->addUsingAlias(AdminActParticipantPeer::ADMINACTID, $adminactid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($adminactid['max'])) {
                $this->addUsingAlias(AdminActParticipantPeer::ADMINACTID, $adminactid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdminActParticipantPeer::ADMINACTID, $adminactid, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(AdminActParticipantPeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(AdminActParticipantPeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(AdminActParticipantPeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(AdminActParticipantPeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query by a related AdministrativeAct object
     *
     * @param   AdministrativeAct|PropelObjectCollection $administrativeAct The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   AdminActParticipantQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByAdministrativeAct($administrativeAct, $comparison = null)
    {
        if ($administrativeAct instanceof AdministrativeAct) {
            return $this
                ->addUsingAlias(AdminActParticipantPeer::ADMINACTID, $administrativeAct->getId(), $comparison);
        } elseif ($administrativeAct instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(AdminActParticipantPeer::ADMINACTID, $administrativeAct->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByAdministrativeAct() only accepts arguments of type AdministrativeAct or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the AdministrativeAct relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function joinAdministrativeAct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('AdministrativeAct');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'AdministrativeAct');
        }

        return $this;
    }

    /**
     * Use the AdministrativeAct relation AdministrativeAct object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   AdministrativeActQuery A secondary query class using the current class as primary query
     */
    public function useAdministrativeActQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinAdministrativeAct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'AdministrativeAct', 'AdministrativeActQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   AdminActParticipant $adminActParticipant Object to remove from the list of results
     *
     * @return AdminActParticipantQuery The current query, for fluid interface
     */
    public function prune($adminActParticipant = null)
    {
        if ($adminActParticipant) {
            $this->addUsingAlias(AdminActParticipantPeer::ID, $adminActParticipant->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
