<?php


/**
 * Base class that represents a query for the 'objectives_policyGuideline' table.
 *
 * Policy Guidelines
 *
 * @method PolicyGuidelineQuery orderById($order = Criteria::ASC) Order by the id column
 * @method PolicyGuidelineQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method PolicyGuidelineQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method PolicyGuidelineQuery orderByExchangerate($order = Criteria::ASC) Order by the exchangeRate column
 * @method PolicyGuidelineQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method PolicyGuidelineQuery orderByObjecttype($order = Criteria::ASC) Order by the objectType column
 * @method PolicyGuidelineQuery orderByObjectid($order = Criteria::ASC) Order by the objectId column
 * @method PolicyGuidelineQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method PolicyGuidelineQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method PolicyGuidelineQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method PolicyGuidelineQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method PolicyGuidelineQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method PolicyGuidelineQuery groupById() Group by the id column
 * @method PolicyGuidelineQuery groupByName() Group by the name column
 * @method PolicyGuidelineQuery groupByDescription() Group by the description column
 * @method PolicyGuidelineQuery groupByExchangerate() Group by the exchangeRate column
 * @method PolicyGuidelineQuery groupByUserid() Group by the userId column
 * @method PolicyGuidelineQuery groupByObjecttype() Group by the objectType column
 * @method PolicyGuidelineQuery groupByObjectid() Group by the objectId column
 * @method PolicyGuidelineQuery groupByStartingyear() Group by the startingYear column
 * @method PolicyGuidelineQuery groupByEndingyear() Group by the endingYear column
 * @method PolicyGuidelineQuery groupByUpdated() Group by the updated column
 * @method PolicyGuidelineQuery groupByChanges() Group by the changes column
 * @method PolicyGuidelineQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method PolicyGuidelineQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method PolicyGuidelineQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method PolicyGuidelineQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method PolicyGuidelineQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method PolicyGuidelineQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method PolicyGuidelineQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method PolicyGuidelineQuery leftJoinPolicyGuidelineIndicators($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuidelineIndicators relation
 * @method PolicyGuidelineQuery rightJoinPolicyGuidelineIndicators($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuidelineIndicators relation
 * @method PolicyGuidelineQuery innerJoinPolicyGuidelineIndicators($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuidelineIndicators relation
 *
 * @method PolicyGuidelineQuery leftJoinStrategicObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjective relation
 * @method PolicyGuidelineQuery rightJoinStrategicObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjective relation
 * @method PolicyGuidelineQuery innerJoinStrategicObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjective relation
 *
 * @method PolicyGuidelineQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method PolicyGuidelineQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method PolicyGuidelineQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method PolicyGuidelineQuery leftJoinPolicyGuidelineLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuidelineLog relation
 * @method PolicyGuidelineQuery rightJoinPolicyGuidelineLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuidelineLog relation
 * @method PolicyGuidelineQuery innerJoinPolicyGuidelineLog($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuidelineLog relation
 *
 * @method PolicyGuidelineQuery leftJoinStrategicObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjectiveLog relation
 * @method PolicyGuidelineQuery rightJoinStrategicObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjectiveLog relation
 * @method PolicyGuidelineQuery innerJoinStrategicObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjectiveLog relation
 *
 * @method PolicyGuidelineQuery leftJoinObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveLog relation
 * @method PolicyGuidelineQuery rightJoinObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveLog relation
 * @method PolicyGuidelineQuery innerJoinObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveLog relation
 *
 * @method PolicyGuidelineQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method PolicyGuidelineQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method PolicyGuidelineQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method PolicyGuideline findOne(PropelPDO $con = null) Return the first PolicyGuideline matching the query
 * @method PolicyGuideline findOneOrCreate(PropelPDO $con = null) Return the first PolicyGuideline matching the query, or a new PolicyGuideline object populated from the query conditions when no match is found
 *
 * @method PolicyGuideline findOneById(int $id) Return the first PolicyGuideline filtered by the id column
 * @method PolicyGuideline findOneByName(string $name) Return the first PolicyGuideline filtered by the name column
 * @method PolicyGuideline findOneByDescription(string $description) Return the first PolicyGuideline filtered by the description column
 * @method PolicyGuideline findOneByExchangerate(double $exchangeRate) Return the first PolicyGuideline filtered by the exchangeRate column
 * @method PolicyGuideline findOneByUserid(int $userId) Return the first PolicyGuideline filtered by the userId column
 * @method PolicyGuideline findOneByObjecttype(string $objectType) Return the first PolicyGuideline filtered by the objectType column
 * @method PolicyGuideline findOneByObjectid(int $objectId) Return the first PolicyGuideline filtered by the objectId column
 * @method PolicyGuideline findOneByStartingyear(int $startingYear) Return the first PolicyGuideline filtered by the startingYear column
 * @method PolicyGuideline findOneByEndingyear(int $endingYear) Return the first PolicyGuideline filtered by the endingYear column
 * @method PolicyGuideline findOneByUpdated(string $updated) Return the first PolicyGuideline filtered by the updated column
 * @method PolicyGuideline findOneByChanges(int $changes) Return the first PolicyGuideline filtered by the changes column
 * @method PolicyGuideline findOneByDeletedAt(string $deleted_at) Return the first PolicyGuideline filtered by the deleted_at column
 *
 * @method array findById(int $id) Return PolicyGuideline objects filtered by the id column
 * @method array findByName(string $name) Return PolicyGuideline objects filtered by the name column
 * @method array findByDescription(string $description) Return PolicyGuideline objects filtered by the description column
 * @method array findByExchangerate(double $exchangeRate) Return PolicyGuideline objects filtered by the exchangeRate column
 * @method array findByUserid(int $userId) Return PolicyGuideline objects filtered by the userId column
 * @method array findByObjecttype(string $objectType) Return PolicyGuideline objects filtered by the objectType column
 * @method array findByObjectid(int $objectId) Return PolicyGuideline objects filtered by the objectId column
 * @method array findByStartingyear(int $startingYear) Return PolicyGuideline objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return PolicyGuideline objects filtered by the endingYear column
 * @method array findByUpdated(string $updated) Return PolicyGuideline objects filtered by the updated column
 * @method array findByChanges(int $changes) Return PolicyGuideline objects filtered by the changes column
 * @method array findByDeletedAt(string $deleted_at) Return PolicyGuideline objects filtered by the deleted_at column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BasePolicyGuidelineQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BasePolicyGuidelineQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'PolicyGuideline', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new PolicyGuidelineQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     PolicyGuidelineQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return PolicyGuidelineQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof PolicyGuidelineQuery) {
            return $criteria;
        }
        $query = new PolicyGuidelineQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   PolicyGuideline|PolicyGuideline[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = PolicyGuidelinePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(PolicyGuidelinePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   PolicyGuideline A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `DESCRIPTION`, `EXCHANGERATE`, `USERID`, `OBJECTTYPE`, `OBJECTID`, `STARTINGYEAR`, `ENDINGYEAR`, `UPDATED`, `CHANGES`, `DELETED_AT` FROM `objectives_policyGuideline` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new PolicyGuideline();
            $obj->hydrate($row);
            PolicyGuidelinePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return PolicyGuideline|PolicyGuideline[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|PolicyGuideline[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PolicyGuidelinePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PolicyGuidelinePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the exchangeRate column
     *
     * Example usage:
     * <code>
     * $query->filterByExchangerate(1234); // WHERE exchangeRate = 1234
     * $query->filterByExchangerate(array(12, 34)); // WHERE exchangeRate IN (12, 34)
     * $query->filterByExchangerate(array('min' => 12)); // WHERE exchangeRate > 12
     * </code>
     *
     * @param     mixed $exchangerate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByExchangerate($exchangerate = null, $comparison = null)
    {
        if (is_array($exchangerate)) {
            $useMinMax = false;
            if (isset($exchangerate['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::EXCHANGERATE, $exchangerate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($exchangerate['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::EXCHANGERATE, $exchangerate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::EXCHANGERATE, $exchangerate, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the objectType column
     *
     * Example usage:
     * <code>
     * $query->filterByObjecttype('fooValue');   // WHERE objectType = 'fooValue'
     * $query->filterByObjecttype('%fooValue%'); // WHERE objectType LIKE '%fooValue%'
     * </code>
     *
     * @param     string $objecttype The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByObjecttype($objecttype = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objecttype)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $objecttype)) {
                $objecttype = str_replace('*', '%', $objecttype);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::OBJECTTYPE, $objecttype, $comparison);
    }

    /**
     * Filter the query on the objectId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectid(1234); // WHERE objectId = 1234
     * $query->filterByObjectid(array(12, 34)); // WHERE objectId IN (12, 34)
     * $query->filterByObjectid(array('min' => 12)); // WHERE objectId > 12
     * </code>
     *
     * @param     mixed $objectid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByObjectid($objectid = null, $comparison = null)
    {
        if (is_array($objectid)) {
            $useMinMax = false;
            if (isset($objectid['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::OBJECTID, $objectid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectid['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::OBJECTID, $objectid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::OBJECTID, $objectid, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(PolicyGuidelinePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PolicyGuidelinePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PolicyGuidelinePeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related PolicyGuidelineIndicators object
     *
     * @param   PolicyGuidelineIndicators|PropelObjectCollection $policyGuidelineIndicators  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuidelineIndicators($policyGuidelineIndicators, $comparison = null)
    {
        if ($policyGuidelineIndicators instanceof PolicyGuidelineIndicators) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $policyGuidelineIndicators->getPolicyguidelineid(), $comparison);
        } elseif ($policyGuidelineIndicators instanceof PropelObjectCollection) {
            return $this
                ->usePolicyGuidelineIndicatorsQuery()
                ->filterByPrimaryKeys($policyGuidelineIndicators->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPolicyGuidelineIndicators() only accepts arguments of type PolicyGuidelineIndicators or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuidelineIndicators relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinPolicyGuidelineIndicators($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuidelineIndicators');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuidelineIndicators');
        }

        return $this;
    }

    /**
     * Use the PolicyGuidelineIndicators relation PolicyGuidelineIndicators object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineIndicatorsQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineIndicatorsQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPolicyGuidelineIndicators($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuidelineIndicators', 'PolicyGuidelineIndicatorsQuery');
    }

    /**
     * Filter the query by a related StrategicObjective object
     *
     * @param   StrategicObjective|PropelObjectCollection $strategicObjective  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjective($strategicObjective, $comparison = null)
    {
        if ($strategicObjective instanceof StrategicObjective) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $strategicObjective->getPolicyguidelineid(), $comparison);
        } elseif ($strategicObjective instanceof PropelObjectCollection) {
            return $this
                ->useStrategicObjectiveQuery()
                ->filterByPrimaryKeys($strategicObjective->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByStrategicObjective() only accepts arguments of type StrategicObjective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinStrategicObjective($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjective');
        }

        return $this;
    }

    /**
     * Use the StrategicObjective relation StrategicObjective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinStrategicObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjective', 'StrategicObjectiveQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $objective->getPolicyguidelineid(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveQuery()
                ->filterByPrimaryKeys($objective->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related PolicyGuidelineLog object
     *
     * @param   PolicyGuidelineLog|PropelObjectCollection $policyGuidelineLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuidelineLog($policyGuidelineLog, $comparison = null)
    {
        if ($policyGuidelineLog instanceof PolicyGuidelineLog) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $policyGuidelineLog->getPolicyguidelineid(), $comparison);
        } elseif ($policyGuidelineLog instanceof PropelObjectCollection) {
            return $this
                ->usePolicyGuidelineLogQuery()
                ->filterByPrimaryKeys($policyGuidelineLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPolicyGuidelineLog() only accepts arguments of type PolicyGuidelineLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuidelineLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinPolicyGuidelineLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuidelineLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuidelineLog');
        }

        return $this;
    }

    /**
     * Use the PolicyGuidelineLog relation PolicyGuidelineLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineLogQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPolicyGuidelineLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuidelineLog', 'PolicyGuidelineLogQuery');
    }

    /**
     * Filter the query by a related StrategicObjectiveLog object
     *
     * @param   StrategicObjectiveLog|PropelObjectCollection $strategicObjectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjectiveLog($strategicObjectiveLog, $comparison = null)
    {
        if ($strategicObjectiveLog instanceof StrategicObjectiveLog) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $strategicObjectiveLog->getPolicyguidelineid(), $comparison);
        } elseif ($strategicObjectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useStrategicObjectiveLogQuery()
                ->filterByPrimaryKeys($strategicObjectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByStrategicObjectiveLog() only accepts arguments of type StrategicObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinStrategicObjectiveLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the StrategicObjectiveLog relation StrategicObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinStrategicObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjectiveLog', 'StrategicObjectiveLogQuery');
    }

    /**
     * Filter the query by a related ObjectiveLog object
     *
     * @param   ObjectiveLog|PropelObjectCollection $objectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveLog($objectiveLog, $comparison = null)
    {
        if ($objectiveLog instanceof ObjectiveLog) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $objectiveLog->getPolicyguidelineid(), $comparison);
        } elseif ($objectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveLogQuery()
                ->filterByPrimaryKeys($objectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveLog() only accepts arguments of type ObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinObjectiveLog($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the ObjectiveLog relation ObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveLogQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveLog', 'ObjectiveLogQuery');
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(PolicyGuidelinePeer::ID, $mission->getPolicyguidelineid(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            return $this
                ->useMissionQuery()
                ->filterByPrimaryKeys($mission->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related Indicator object
     * using the objectives_policyGuidelineIndicators table as cross reference
     *
     * @param   Indicator $indicator the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   PolicyGuidelineQuery The current query, for fluid interface
     */
    public function filterByIndicator($indicator, $comparison = Criteria::EQUAL)
    {
        return $this
            ->usePolicyGuidelineIndicatorsQuery()
            ->filterByIndicator($indicator, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   PolicyGuideline $policyGuideline Object to remove from the list of results
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function prune($policyGuideline = null)
    {
        if ($policyGuideline) {
            $this->addUsingAlias(PolicyGuidelinePeer::ID, $policyGuideline->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(PolicyGuidelinePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            PolicyGuidelinePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (PolicyGuidelineQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see PolicyGuidelineQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return PolicyGuidelineQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return PolicyGuidelinePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return PolicyGuidelinePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
