<?php


/**
 * Base class that represents a query for the 'objectives_objective' table.
 *
 * Objective
 *
 * @method ObjectiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ObjectiveQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method ObjectiveQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 * @method ObjectiveQuery orderByStrategicobjectiveid($order = Criteria::ASC) Order by the strategicObjectiveId column
 * @method ObjectiveQuery orderByAffiliateid($order = Criteria::ASC) Order by the affiliateId column
 * @method ObjectiveQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method ObjectiveQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method ObjectiveQuery orderByExpirationdate($order = Criteria::ASC) Order by the expirationDate column
 * @method ObjectiveQuery orderByAchieved($order = Criteria::ASC) Order by the achieved column
 * @method ObjectiveQuery orderByNotes($order = Criteria::ASC) Order by the notes column
 * @method ObjectiveQuery orderByResponsiblecode($order = Criteria::ASC) Order by the responsibleCode column
 * @method ObjectiveQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method ObjectiveQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method ObjectiveQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method ObjectiveQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method ObjectiveQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method ObjectiveQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method ObjectiveQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 * @method ObjectiveQuery orderByDeletedAt($order = Criteria::ASC) Order by the deleted_at column
 *
 * @method ObjectiveQuery groupById() Group by the id column
 * @method ObjectiveQuery groupByName() Group by the name column
 * @method ObjectiveQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 * @method ObjectiveQuery groupByStrategicobjectiveid() Group by the strategicObjectiveId column
 * @method ObjectiveQuery groupByAffiliateid() Group by the affiliateId column
 * @method ObjectiveQuery groupByDescription() Group by the description column
 * @method ObjectiveQuery groupByDate() Group by the date column
 * @method ObjectiveQuery groupByExpirationdate() Group by the expirationDate column
 * @method ObjectiveQuery groupByAchieved() Group by the achieved column
 * @method ObjectiveQuery groupByNotes() Group by the notes column
 * @method ObjectiveQuery groupByResponsiblecode() Group by the responsibleCode column
 * @method ObjectiveQuery groupByUserid() Group by the userId column
 * @method ObjectiveQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method ObjectiveQuery groupByUpdated() Group by the updated column
 * @method ObjectiveQuery groupByChanges() Group by the changes column
 * @method ObjectiveQuery groupByOldid() Group by the oldId column
 * @method ObjectiveQuery groupByStartingyear() Group by the startingYear column
 * @method ObjectiveQuery groupByEndingyear() Group by the endingYear column
 * @method ObjectiveQuery groupByDeletedAt() Group by the deleted_at column
 *
 * @method ObjectiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ObjectiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ObjectiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ObjectiveQuery leftJoinStrategicObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjective relation
 * @method ObjectiveQuery rightJoinStrategicObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjective relation
 * @method ObjectiveQuery innerJoinStrategicObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjective relation
 *
 * @method ObjectiveQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method ObjectiveQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method ObjectiveQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method ObjectiveQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method ObjectiveQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method ObjectiveQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method ObjectiveQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method ObjectiveQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method ObjectiveQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method ObjectiveQuery leftJoinIndicator($relationAlias = null) Adds a LEFT JOIN clause to the query using the Indicator relation
 * @method ObjectiveQuery rightJoinIndicator($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Indicator relation
 * @method ObjectiveQuery innerJoinIndicator($relationAlias = null) Adds a INNER JOIN clause to the query using the Indicator relation
 *
 * @method ObjectiveQuery leftJoinObjectiveRegion($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveRegion relation
 * @method ObjectiveQuery rightJoinObjectiveRegion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveRegion relation
 * @method ObjectiveQuery innerJoinObjectiveRegion($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveRegion relation
 *
 * @method ObjectiveQuery leftJoinObjectiveLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ObjectiveLog relation
 * @method ObjectiveQuery rightJoinObjectiveLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ObjectiveLog relation
 * @method ObjectiveQuery innerJoinObjectiveLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ObjectiveLog relation
 *
 * @method ObjectiveQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method ObjectiveQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method ObjectiveQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method ObjectiveQuery leftJoinProjectLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProjectLog relation
 * @method ObjectiveQuery rightJoinProjectLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProjectLog relation
 * @method ObjectiveQuery innerJoinProjectLog($relationAlias = null) Adds a INNER JOIN clause to the query using the ProjectLog relation
 *
 * @method Objective findOne(PropelPDO $con = null) Return the first Objective matching the query
 * @method Objective findOneOrCreate(PropelPDO $con = null) Return the first Objective matching the query, or a new Objective object populated from the query conditions when no match is found
 *
 * @method Objective findOneById(int $id) Return the first Objective filtered by the id column
 * @method Objective findOneByName(string $name) Return the first Objective filtered by the name column
 * @method Objective findOneByPolicyguidelineid(int $policyGuidelineId) Return the first Objective filtered by the policyGuidelineId column
 * @method Objective findOneByStrategicobjectiveid(int $strategicObjectiveId) Return the first Objective filtered by the strategicObjectiveId column
 * @method Objective findOneByAffiliateid(int $affiliateId) Return the first Objective filtered by the affiliateId column
 * @method Objective findOneByDescription(string $description) Return the first Objective filtered by the description column
 * @method Objective findOneByDate(string $date) Return the first Objective filtered by the date column
 * @method Objective findOneByExpirationdate(string $expirationDate) Return the first Objective filtered by the expirationDate column
 * @method Objective findOneByAchieved(boolean $achieved) Return the first Objective filtered by the achieved column
 * @method Objective findOneByNotes(string $notes) Return the first Objective filtered by the notes column
 * @method Objective findOneByResponsiblecode(int $responsibleCode) Return the first Objective filtered by the responsibleCode column
 * @method Objective findOneByUserid(int $userId) Return the first Objective filtered by the userId column
 * @method Objective findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first Objective filtered by the userByAffiliatesId column
 * @method Objective findOneByUpdated(string $updated) Return the first Objective filtered by the updated column
 * @method Objective findOneByChanges(int $changes) Return the first Objective filtered by the changes column
 * @method Objective findOneByOldid(int $oldId) Return the first Objective filtered by the oldId column
 * @method Objective findOneByStartingyear(int $startingYear) Return the first Objective filtered by the startingYear column
 * @method Objective findOneByEndingyear(int $endingYear) Return the first Objective filtered by the endingYear column
 * @method Objective findOneByDeletedAt(string $deleted_at) Return the first Objective filtered by the deleted_at column
 *
 * @method array findById(int $id) Return Objective objects filtered by the id column
 * @method array findByName(string $name) Return Objective objects filtered by the name column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return Objective objects filtered by the policyGuidelineId column
 * @method array findByStrategicobjectiveid(int $strategicObjectiveId) Return Objective objects filtered by the strategicObjectiveId column
 * @method array findByAffiliateid(int $affiliateId) Return Objective objects filtered by the affiliateId column
 * @method array findByDescription(string $description) Return Objective objects filtered by the description column
 * @method array findByDate(string $date) Return Objective objects filtered by the date column
 * @method array findByExpirationdate(string $expirationDate) Return Objective objects filtered by the expirationDate column
 * @method array findByAchieved(boolean $achieved) Return Objective objects filtered by the achieved column
 * @method array findByNotes(string $notes) Return Objective objects filtered by the notes column
 * @method array findByResponsiblecode(int $responsibleCode) Return Objective objects filtered by the responsibleCode column
 * @method array findByUserid(int $userId) Return Objective objects filtered by the userId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return Objective objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return Objective objects filtered by the updated column
 * @method array findByChanges(int $changes) Return Objective objects filtered by the changes column
 * @method array findByOldid(int $oldId) Return Objective objects filtered by the oldId column
 * @method array findByStartingyear(int $startingYear) Return Objective objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return Objective objects filtered by the endingYear column
 * @method array findByDeletedAt(string $deleted_at) Return Objective objects filtered by the deleted_at column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseObjectiveQuery extends \Egytca\Propel\Query
{
    // soft_delete behavior
    protected static $softDelete = true;
    protected $localSoftDelete = true;

    /**
     * Initializes internal state of BaseObjectiveQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Objective', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ObjectiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ObjectiveQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ObjectiveQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ObjectiveQuery) {
            return $criteria;
        }
        $query = new ObjectiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Objective|Objective[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ObjectivePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ObjectivePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Objective A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `POLICYGUIDELINEID`, `STRATEGICOBJECTIVEID`, `AFFILIATEID`, `DESCRIPTION`, `DATE`, `EXPIRATIONDATE`, `ACHIEVED`, `NOTES`, `RESPONSIBLECODE`, `USERID`, `USERBYAFFILIATESID`, `UPDATED`, `CHANGES`, `OLDID`, `STARTINGYEAR`, `ENDINGYEAR`, `DELETED_AT` FROM `objectives_objective` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new Objective();
            $obj->hydrate($row);
            ObjectivePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Objective|Objective[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Objective[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ObjectivePeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ObjectivePeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ObjectivePeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid)) {
            $useMinMax = false;
            if (isset($policyguidelineid['min'])) {
                $this->addUsingAlias(ObjectivePeer::POLICYGUIDELINEID, $policyguidelineid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($policyguidelineid['max'])) {
                $this->addUsingAlias(ObjectivePeer::POLICYGUIDELINEID, $policyguidelineid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query on the strategicObjectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByStrategicobjectiveid(1234); // WHERE strategicObjectiveId = 1234
     * $query->filterByStrategicobjectiveid(array(12, 34)); // WHERE strategicObjectiveId IN (12, 34)
     * $query->filterByStrategicobjectiveid(array('min' => 12)); // WHERE strategicObjectiveId > 12
     * </code>
     *
     * @see       filterByStrategicObjective()
     *
     * @param     mixed $strategicobjectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByStrategicobjectiveid($strategicobjectiveid = null, $comparison = null)
    {
        if (is_array($strategicobjectiveid)) {
            $useMinMax = false;
            if (isset($strategicobjectiveid['min'])) {
                $this->addUsingAlias(ObjectivePeer::STRATEGICOBJECTIVEID, $strategicobjectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($strategicobjectiveid['max'])) {
                $this->addUsingAlias(ObjectivePeer::STRATEGICOBJECTIVEID, $strategicobjectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::STRATEGICOBJECTIVEID, $strategicobjectiveid, $comparison);
    }

    /**
     * Filter the query on the affiliateId column
     *
     * Example usage:
     * <code>
     * $query->filterByAffiliateid(1234); // WHERE affiliateId = 1234
     * $query->filterByAffiliateid(array(12, 34)); // WHERE affiliateId IN (12, 34)
     * $query->filterByAffiliateid(array('min' => 12)); // WHERE affiliateId > 12
     * </code>
     *
     * @param     mixed $affiliateid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByAffiliateid($affiliateid = null, $comparison = null)
    {
        if (is_array($affiliateid)) {
            $useMinMax = false;
            if (isset($affiliateid['min'])) {
                $this->addUsingAlias(ObjectivePeer::AFFILIATEID, $affiliateid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($affiliateid['max'])) {
                $this->addUsingAlias(ObjectivePeer::AFFILIATEID, $affiliateid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::AFFILIATEID, $affiliateid, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param     mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByDate($date = null, $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(ObjectivePeer::DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(ObjectivePeer::DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::DATE, $date, $comparison);
    }

    /**
     * Filter the query on the expirationDate column
     *
     * Example usage:
     * <code>
     * $query->filterByExpirationdate('2011-03-14'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate('now'); // WHERE expirationDate = '2011-03-14'
     * $query->filterByExpirationdate(array('max' => 'yesterday')); // WHERE expirationDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $expirationdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByExpirationdate($expirationdate = null, $comparison = null)
    {
        if (is_array($expirationdate)) {
            $useMinMax = false;
            if (isset($expirationdate['min'])) {
                $this->addUsingAlias(ObjectivePeer::EXPIRATIONDATE, $expirationdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($expirationdate['max'])) {
                $this->addUsingAlias(ObjectivePeer::EXPIRATIONDATE, $expirationdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::EXPIRATIONDATE, $expirationdate, $comparison);
    }

    /**
     * Filter the query on the achieved column
     *
     * Example usage:
     * <code>
     * $query->filterByAchieved(true); // WHERE achieved = true
     * $query->filterByAchieved('yes'); // WHERE achieved = true
     * </code>
     *
     * @param     boolean|string $achieved The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByAchieved($achieved = null, $comparison = null)
    {
        if (is_string($achieved)) {
            $achieved = in_array(strtolower($achieved), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(ObjectivePeer::ACHIEVED, $achieved, $comparison);
    }

    /**
     * Filter the query on the notes column
     *
     * Example usage:
     * <code>
     * $query->filterByNotes('fooValue');   // WHERE notes = 'fooValue'
     * $query->filterByNotes('%fooValue%'); // WHERE notes LIKE '%fooValue%'
     * </code>
     *
     * @param     string $notes The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByNotes($notes = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($notes)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $notes)) {
                $notes = str_replace('*', '%', $notes);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::NOTES, $notes, $comparison);
    }

    /**
     * Filter the query on the responsibleCode column
     *
     * Example usage:
     * <code>
     * $query->filterByResponsiblecode(1234); // WHERE responsibleCode = 1234
     * $query->filterByResponsiblecode(array(12, 34)); // WHERE responsibleCode IN (12, 34)
     * $query->filterByResponsiblecode(array('min' => 12)); // WHERE responsibleCode > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $responsiblecode The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByResponsiblecode($responsiblecode = null, $comparison = null)
    {
        if (is_array($responsiblecode)) {
            $useMinMax = false;
            if (isset($responsiblecode['min'])) {
                $this->addUsingAlias(ObjectivePeer::RESPONSIBLECODE, $responsiblecode['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($responsiblecode['max'])) {
                $this->addUsingAlias(ObjectivePeer::RESPONSIBLECODE, $responsiblecode['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::RESPONSIBLECODE, $responsiblecode, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(ObjectivePeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(ObjectivePeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(ObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(ObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(ObjectivePeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(ObjectivePeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(ObjectivePeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(ObjectivePeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(ObjectivePeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(ObjectivePeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(ObjectivePeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(ObjectivePeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(ObjectivePeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(ObjectivePeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query on the deleted_at column
     *
     * Example usage:
     * <code>
     * $query->filterByDeletedAt('2011-03-14'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt('now'); // WHERE deleted_at = '2011-03-14'
     * $query->filterByDeletedAt(array('max' => 'yesterday')); // WHERE deleted_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $deletedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function filterByDeletedAt($deletedAt = null, $comparison = null)
    {
        if (is_array($deletedAt)) {
            $useMinMax = false;
            if (isset($deletedAt['min'])) {
                $this->addUsingAlias(ObjectivePeer::DELETED_AT, $deletedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($deletedAt['max'])) {
                $this->addUsingAlias(ObjectivePeer::DELETED_AT, $deletedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ObjectivePeer::DELETED_AT, $deletedAt, $comparison);
    }

    /**
     * Filter the query by a related StrategicObjective object
     *
     * @param   StrategicObjective|PropelObjectCollection $strategicObjective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjective($strategicObjective, $comparison = null)
    {
        if ($strategicObjective instanceof StrategicObjective) {
            return $this
                ->addUsingAlias(ObjectivePeer::STRATEGICOBJECTIVEID, $strategicObjective->getId(), $comparison);
        } elseif ($strategicObjective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectivePeer::STRATEGICOBJECTIVEID, $strategicObjective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByStrategicObjective() only accepts arguments of type StrategicObjective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinStrategicObjective($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjective');
        }

        return $this;
    }

    /**
     * Use the StrategicObjective relation StrategicObjective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinStrategicObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjective', 'StrategicObjectiveQuery');
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(ObjectivePeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectivePeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(ObjectivePeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectivePeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(ObjectivePeer::RESPONSIBLECODE, $position->getCode(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ObjectivePeer::RESPONSIBLECODE, $position->toKeyValue('PrimaryKey', 'Code'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Filter the query by a related Indicator object
     *
     * @param   Indicator|PropelObjectCollection $indicator  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicator($indicator, $comparison = null)
    {
        if ($indicator instanceof Indicator) {
            return $this
                ->addUsingAlias(ObjectivePeer::ID, $indicator->getObjectiveid(), $comparison);
        } elseif ($indicator instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorQuery()
                ->filterByPrimaryKeys($indicator->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicator() only accepts arguments of type Indicator or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Indicator relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinIndicator($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Indicator');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Indicator');
        }

        return $this;
    }

    /**
     * Use the Indicator relation Indicator object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinIndicator($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Indicator', 'IndicatorQuery');
    }

    /**
     * Filter the query by a related ObjectiveRegion object
     *
     * @param   ObjectiveRegion|PropelObjectCollection $objectiveRegion  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveRegion($objectiveRegion, $comparison = null)
    {
        if ($objectiveRegion instanceof ObjectiveRegion) {
            return $this
                ->addUsingAlias(ObjectivePeer::ID, $objectiveRegion->getObjectiveid(), $comparison);
        } elseif ($objectiveRegion instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveRegionQuery()
                ->filterByPrimaryKeys($objectiveRegion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveRegion() only accepts arguments of type ObjectiveRegion or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveRegion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinObjectiveRegion($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveRegion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveRegion');
        }

        return $this;
    }

    /**
     * Use the ObjectiveRegion relation ObjectiveRegion object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveRegionQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveRegionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjectiveRegion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveRegion', 'ObjectiveRegionQuery');
    }

    /**
     * Filter the query by a related ObjectiveLog object
     *
     * @param   ObjectiveLog|PropelObjectCollection $objectiveLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjectiveLog($objectiveLog, $comparison = null)
    {
        if ($objectiveLog instanceof ObjectiveLog) {
            return $this
                ->addUsingAlias(ObjectivePeer::ID, $objectiveLog->getObjectiveid(), $comparison);
        } elseif ($objectiveLog instanceof PropelObjectCollection) {
            return $this
                ->useObjectiveLogQuery()
                ->filterByPrimaryKeys($objectiveLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByObjectiveLog() only accepts arguments of type ObjectiveLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ObjectiveLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinObjectiveLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ObjectiveLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ObjectiveLog');
        }

        return $this;
    }

    /**
     * Use the ObjectiveLog relation ObjectiveLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveLogQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinObjectiveLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ObjectiveLog', 'ObjectiveLogQuery');
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(ObjectivePeer::ID, $project->getObjectiveid(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            return $this
                ->useProjectQuery()
                ->filterByPrimaryKeys($project->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related ProjectLog object
     *
     * @param   ProjectLog|PropelObjectCollection $projectLog  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProjectLog($projectLog, $comparison = null)
    {
        if ($projectLog instanceof ProjectLog) {
            return $this
                ->addUsingAlias(ObjectivePeer::ID, $projectLog->getObjectiveid(), $comparison);
        } elseif ($projectLog instanceof PropelObjectCollection) {
            return $this
                ->useProjectLogQuery()
                ->filterByPrimaryKeys($projectLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProjectLog() only accepts arguments of type ProjectLog or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProjectLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function joinProjectLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProjectLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProjectLog');
        }

        return $this;
    }

    /**
     * Use the ProjectLog relation ProjectLog object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectLogQuery A secondary query class using the current class as primary query
     */
    public function useProjectLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProjectLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProjectLog', 'ProjectLogQuery');
    }

    /**
     * Filter the query by a related Region object
     * using the objectives_region table as cross reference
     *
     * @param   Region $region the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ObjectiveQuery The current query, for fluid interface
     */
    public function filterByRegion($region, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useObjectiveRegionQuery()
            ->filterByRegion($region, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Objective $objective Object to remove from the list of results
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function prune($objective = null)
    {
        if ($objective) {
            $this->addUsingAlias(ObjectivePeer::ID, $objective->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every SELECT statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreSelect(PropelPDO $con)
    {
        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            $this->addUsingAlias(ObjectivePeer::DELETED_AT, null, Criteria::ISNULL);
        } else {
            ObjectivePeer::enableSoftDelete();
        }

        return $this->preSelect($con);
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     PropelPDO $con The connection object used by the query
     */
    protected function basePreDelete(PropelPDO $con)
    {
        // soft_delete behavior
        if (ObjectiveQuery::isSoftDeleteEnabled() && $this->localSoftDelete) {
            return $this->softDelete($con);
        } else {
            return $this->hasWhereClause() ? $this->forceDelete($con) : $this->forceDeleteAll($con);
        }

        return $this->preDelete($con);
    }

    // soft_delete behavior

    /**
     * Temporarily disable the filter on deleted rows
     * Valid only for the current query
     *
     * @see ObjectiveQuery::disableSoftDelete() to disable the filter for more than one query
     *
     * @return ObjectiveQuery The current query, for fluid interface
     */
    public function includeDeleted()
    {
        $this->localSoftDelete = false;

        return $this;
    }

    /**
     * Soft delete the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of updated rows
     */
    public function softDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => time()), $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of the selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDelete(PropelPDO $con = null)
    {
        return ObjectivePeer::doForceDelete($this, $con);
    }

    /**
     * Bypass the soft_delete behavior and force a hard delete of all the rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int Number of deleted rows
     */
    public function forceDeleteAll(PropelPDO $con = null)
    {
        return ObjectivePeer::doForceDeleteAll($con);}

    /**
     * Undelete selected rows
     *
     * @param			PropelPDO $con an optional connection object
     *
     * @return		int The number of rows affected by this update and any referring fk objects' save() operations.
     */
    public function unDelete(PropelPDO $con = null)
    {
        return $this->update(array('DeletedAt' => null), $con);
    }

    /**
     * Enable the soft_delete behavior for this model
     */
    public static function enableSoftDelete()
    {
        self::$softDelete = true;
    }

    /**
     * Disable the soft_delete behavior for this model
     */
    public static function disableSoftDelete()
    {
        self::$softDelete = false;
    }

    /**
     * Check the soft_delete behavior for this model
     *
     * @return boolean true if the soft_delete behavior is enabled
     */
    public static function isSoftDeleteEnabled()
    {
        return self::$softDelete;
    }

}
