|-counter name="numericIndicatorValuesGraphId" assign="graphId"-|
<style>
	#numericIndicatorValuesGraph-|-$graphId-| svg {
		width: 100%;
		height: 300px;
	}
</style>
<div id="numericIndicatorValuesGraph-|-$graphId-|"></div>
<script>

var dateFormat = d3.time.format('|-$dateFormat-|');
nv.addGraph(function() {
	var chart = nv.models.lineChart()
		.margin({ left: 100 })
		.useInteractiveGuideline(true)
		.transitionDuration(350)
		.interpolate("cardinal") 
		.showLegend(true)
		.showYAxis(true)
		.showXAxis(true);

	chart.xAxis
		.axisLabel('##indicators,36,Date## (|-$dateFormatLabel-|)')
		.tickFormat(function(d) {
			var date = new Date(d * 1000);
			return dateFormat(date)
			return dateFormat(new Date(d * 1000))
		});

	chart.yAxis
		.axisLabel('##indicators,37,Value##')
		.tickFormat(d3.format('.02f'));

	var myData = indicatorValuesData();

	d3.select('#numericIndicatorValuesGraph-|-$graphId-|')
		.append('svg')
		.datum(myData)
		.call(chart);

	// Update the chart when window resizes.
	//nv.utils.windowResize(function() { chart.update() });

	return chart;
});
|-$colors = ['blue', 'red', 'green', 'orange', 'grey', 'brown']-|
var indicatorValuesData = function() {
	return [
		|-foreach from=$indicatorGraph->getIndicators() item=serie name=series-||-$mappedValues = NULL-|
		{
			values: |-$indicatorValues = ExpectedIndicatorValueQuery::create()->orderByDate(Criteria::ASC)->findByNumericIndicatorId($serie->getId())-||-foreach from=$indicatorValues item=indicatorValue-||-$mappedValues[] = ['x' => $indicatorValue->getDate('U'), 'y' => $indicatorValue->getValue()]-||-/foreach-||-json_encode($mappedValues)-|,
			key: '|-$serie->getName()|escape-|',
			color: '|-$colors[$smarty.foreach.series.index]-|'
		}|-if !$serie@last-|,|-/if-|
		|-/foreach-|
	];
};
</script>