<?php


/**
 * Base class that represents a query for the 'indicators_indicator' table.
 *
 * Indicators
 *
 * @method IndicatorQuery orderById($order = Criteria::ASC) Order by the id column
 * @method IndicatorQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method IndicatorQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method IndicatorQuery orderByArchived($order = Criteria::ASC) Order by the archived column
 * @method IndicatorQuery orderByMethodology($order = Criteria::ASC) Order by the methodology column
 * @method IndicatorQuery orderByDecimals($order = Criteria::ASC) Order by the decimals column
 * @method IndicatorQuery orderByGoal($order = Criteria::ASC) Order by the goal column
 * @method IndicatorQuery orderByGoaldate($order = Criteria::ASC) Order by the goalDate column
 * @method IndicatorQuery orderByIdealbehavior($order = Criteria::ASC) Order by the idealBehavior column
 * @method IndicatorQuery orderByPositionid($order = Criteria::ASC) Order by the positionId column
 * @method IndicatorQuery orderByObjectiveid($order = Criteria::ASC) Order by the objectiveId column
 * @method IndicatorQuery orderByDuedate($order = Criteria::ASC) Order by the dueDate column
 * @method IndicatorQuery orderByFinisheddate($order = Criteria::ASC) Order by the finishedDate column
 * @method IndicatorQuery orderByClasskey($order = Criteria::ASC) Order by the classKey column
 *
 * @method IndicatorQuery groupById() Group by the id column
 * @method IndicatorQuery groupByName() Group by the name column
 * @method IndicatorQuery groupByDescription() Group by the description column
 * @method IndicatorQuery groupByArchived() Group by the archived column
 * @method IndicatorQuery groupByMethodology() Group by the methodology column
 * @method IndicatorQuery groupByDecimals() Group by the decimals column
 * @method IndicatorQuery groupByGoal() Group by the goal column
 * @method IndicatorQuery groupByGoaldate() Group by the goalDate column
 * @method IndicatorQuery groupByIdealbehavior() Group by the idealBehavior column
 * @method IndicatorQuery groupByPositionid() Group by the positionId column
 * @method IndicatorQuery groupByObjectiveid() Group by the objectiveId column
 * @method IndicatorQuery groupByDuedate() Group by the dueDate column
 * @method IndicatorQuery groupByFinisheddate() Group by the finishedDate column
 * @method IndicatorQuery groupByClasskey() Group by the classKey column
 *
 * @method IndicatorQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method IndicatorQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method IndicatorQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method IndicatorQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method IndicatorQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method IndicatorQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method IndicatorQuery leftJoinObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the Objective relation
 * @method IndicatorQuery rightJoinObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Objective relation
 * @method IndicatorQuery innerJoinObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the Objective relation
 *
 * @method IndicatorQuery leftJoinIndicatorValue($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorValue relation
 * @method IndicatorQuery rightJoinIndicatorValue($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorValue relation
 * @method IndicatorQuery innerJoinIndicatorValue($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorValue relation
 *
 * @method IndicatorQuery leftJoinIndicatorGraphSerie($relationAlias = null) Adds a LEFT JOIN clause to the query using the IndicatorGraphSerie relation
 * @method IndicatorQuery rightJoinIndicatorGraphSerie($relationAlias = null) Adds a RIGHT JOIN clause to the query using the IndicatorGraphSerie relation
 * @method IndicatorQuery innerJoinIndicatorGraphSerie($relationAlias = null) Adds a INNER JOIN clause to the query using the IndicatorGraphSerie relation
 *
 * @method IndicatorQuery leftJoinPolicyGuidelineIndicators($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuidelineIndicators relation
 * @method IndicatorQuery rightJoinPolicyGuidelineIndicators($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuidelineIndicators relation
 * @method IndicatorQuery innerJoinPolicyGuidelineIndicators($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuidelineIndicators relation
 *
 * @method IndicatorQuery leftJoinProject($relationAlias = null) Adds a LEFT JOIN clause to the query using the Project relation
 * @method IndicatorQuery rightJoinProject($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Project relation
 * @method IndicatorQuery innerJoinProject($relationAlias = null) Adds a INNER JOIN clause to the query using the Project relation
 *
 * @method Indicator findOne(PropelPDO $con = null) Return the first Indicator matching the query
 * @method Indicator findOneOrCreate(PropelPDO $con = null) Return the first Indicator matching the query, or a new Indicator object populated from the query conditions when no match is found
 *
 * @method Indicator findOneById(int $id) Return the first Indicator filtered by the id column
 * @method Indicator findOneByName(string $name) Return the first Indicator filtered by the name column
 * @method Indicator findOneByDescription(string $description) Return the first Indicator filtered by the description column
 * @method Indicator findOneByArchived(boolean $archived) Return the first Indicator filtered by the archived column
 * @method Indicator findOneByMethodology(string $methodology) Return the first Indicator filtered by the methodology column
 * @method Indicator findOneByDecimals(int $decimals) Return the first Indicator filtered by the decimals column
 * @method Indicator findOneByGoal(double $goal) Return the first Indicator filtered by the goal column
 * @method Indicator findOneByGoaldate(string $goalDate) Return the first Indicator filtered by the goalDate column
 * @method Indicator findOneByIdealbehavior(int $idealBehavior) Return the first Indicator filtered by the idealBehavior column
 * @method Indicator findOneByPositionid(int $positionId) Return the first Indicator filtered by the positionId column
 * @method Indicator findOneByObjectiveid(int $objectiveId) Return the first Indicator filtered by the objectiveId column
 * @method Indicator findOneByDuedate(string $dueDate) Return the first Indicator filtered by the dueDate column
 * @method Indicator findOneByFinisheddate(string $finishedDate) Return the first Indicator filtered by the finishedDate column
 * @method Indicator findOneByClasskey(int $classKey) Return the first Indicator filtered by the classKey column
 *
 * @method array findById(int $id) Return Indicator objects filtered by the id column
 * @method array findByName(string $name) Return Indicator objects filtered by the name column
 * @method array findByDescription(string $description) Return Indicator objects filtered by the description column
 * @method array findByArchived(boolean $archived) Return Indicator objects filtered by the archived column
 * @method array findByMethodology(string $methodology) Return Indicator objects filtered by the methodology column
 * @method array findByDecimals(int $decimals) Return Indicator objects filtered by the decimals column
 * @method array findByGoal(double $goal) Return Indicator objects filtered by the goal column
 * @method array findByGoaldate(string $goalDate) Return Indicator objects filtered by the goalDate column
 * @method array findByIdealbehavior(int $idealBehavior) Return Indicator objects filtered by the idealBehavior column
 * @method array findByPositionid(int $positionId) Return Indicator objects filtered by the positionId column
 * @method array findByObjectiveid(int $objectiveId) Return Indicator objects filtered by the objectiveId column
 * @method array findByDuedate(string $dueDate) Return Indicator objects filtered by the dueDate column
 * @method array findByFinisheddate(string $finishedDate) Return Indicator objects filtered by the finishedDate column
 * @method array findByClasskey(int $classKey) Return Indicator objects filtered by the classKey column
 *
 * @package    propel.generator.indicators.classes.om
 */
abstract class BaseIndicatorQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseIndicatorQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'Indicator', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new IndicatorQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     IndicatorQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return IndicatorQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof IndicatorQuery) {
            return $criteria;
        }
        $query = new IndicatorQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   Indicator|Indicator[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = IndicatorPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(IndicatorPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   Indicator A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `NAME`, `DESCRIPTION`, `ARCHIVED`, `METHODOLOGY`, `DECIMALS`, `GOAL`, `GOALDATE`, `IDEALBEHAVIOR`, `POSITIONID`, `OBJECTIVEID`, `DUEDATE`, `FINISHEDDATE`, `CLASSKEY` FROM `indicators_indicator` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $cls = IndicatorPeer::getOMClass($row, 0);
            $obj = new $cls();
            $obj->hydrate($row);
            IndicatorPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return Indicator|Indicator[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|Indicator[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(IndicatorPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(IndicatorPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(IndicatorPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the archived column
     *
     * Example usage:
     * <code>
     * $query->filterByArchived(true); // WHERE archived = true
     * $query->filterByArchived('yes'); // WHERE archived = true
     * </code>
     *
     * @param     boolean|string $archived The value to use as filter.
     *              Non-boolean arguments are converted using the following rules:
     *                * 1, '1', 'true',  'on',  and 'yes' are converted to boolean true
     *                * 0, '0', 'false', 'off', and 'no'  are converted to boolean false
     *              Check on string values is case insensitive (so 'FaLsE' is seen as 'false').
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByArchived($archived = null, $comparison = null)
    {
        if (is_string($archived)) {
            $archived = in_array(strtolower($archived), array('false', 'off', '-', 'no', 'n', '0', '')) ? false : true;
        }

        return $this->addUsingAlias(IndicatorPeer::ARCHIVED, $archived, $comparison);
    }

    /**
     * Filter the query on the methodology column
     *
     * Example usage:
     * <code>
     * $query->filterByMethodology('fooValue');   // WHERE methodology = 'fooValue'
     * $query->filterByMethodology('%fooValue%'); // WHERE methodology LIKE '%fooValue%'
     * </code>
     *
     * @param     string $methodology The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByMethodology($methodology = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($methodology)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $methodology)) {
                $methodology = str_replace('*', '%', $methodology);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::METHODOLOGY, $methodology, $comparison);
    }

    /**
     * Filter the query on the decimals column
     *
     * Example usage:
     * <code>
     * $query->filterByDecimals(1234); // WHERE decimals = 1234
     * $query->filterByDecimals(array(12, 34)); // WHERE decimals IN (12, 34)
     * $query->filterByDecimals(array('min' => 12)); // WHERE decimals > 12
     * </code>
     *
     * @param     mixed $decimals The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByDecimals($decimals = null, $comparison = null)
    {
        if (is_array($decimals)) {
            $useMinMax = false;
            if (isset($decimals['min'])) {
                $this->addUsingAlias(IndicatorPeer::DECIMALS, $decimals['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($decimals['max'])) {
                $this->addUsingAlias(IndicatorPeer::DECIMALS, $decimals['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::DECIMALS, $decimals, $comparison);
    }

    /**
     * Filter the query on the goal column
     *
     * Example usage:
     * <code>
     * $query->filterByGoal(1234); // WHERE goal = 1234
     * $query->filterByGoal(array(12, 34)); // WHERE goal IN (12, 34)
     * $query->filterByGoal(array('min' => 12)); // WHERE goal > 12
     * </code>
     *
     * @param     mixed $goal The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByGoal($goal = null, $comparison = null)
    {
        if (is_array($goal)) {
            $useMinMax = false;
            if (isset($goal['min'])) {
                $this->addUsingAlias(IndicatorPeer::GOAL, $goal['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goal['max'])) {
                $this->addUsingAlias(IndicatorPeer::GOAL, $goal['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::GOAL, $goal, $comparison);
    }

    /**
     * Filter the query on the goalDate column
     *
     * Example usage:
     * <code>
     * $query->filterByGoaldate('2011-03-14'); // WHERE goalDate = '2011-03-14'
     * $query->filterByGoaldate('now'); // WHERE goalDate = '2011-03-14'
     * $query->filterByGoaldate(array('max' => 'yesterday')); // WHERE goalDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $goaldate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByGoaldate($goaldate = null, $comparison = null)
    {
        if (is_array($goaldate)) {
            $useMinMax = false;
            if (isset($goaldate['min'])) {
                $this->addUsingAlias(IndicatorPeer::GOALDATE, $goaldate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($goaldate['max'])) {
                $this->addUsingAlias(IndicatorPeer::GOALDATE, $goaldate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::GOALDATE, $goaldate, $comparison);
    }

    /**
     * Filter the query on the idealBehavior column
     *
     * Example usage:
     * <code>
     * $query->filterByIdealbehavior(1234); // WHERE idealBehavior = 1234
     * $query->filterByIdealbehavior(array(12, 34)); // WHERE idealBehavior IN (12, 34)
     * $query->filterByIdealbehavior(array('min' => 12)); // WHERE idealBehavior > 12
     * </code>
     *
     * @param     mixed $idealbehavior The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByIdealbehavior($idealbehavior = null, $comparison = null)
    {
        if (is_array($idealbehavior)) {
            $useMinMax = false;
            if (isset($idealbehavior['min'])) {
                $this->addUsingAlias(IndicatorPeer::IDEALBEHAVIOR, $idealbehavior['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($idealbehavior['max'])) {
                $this->addUsingAlias(IndicatorPeer::IDEALBEHAVIOR, $idealbehavior['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::IDEALBEHAVIOR, $idealbehavior, $comparison);
    }

    /**
     * Filter the query on the positionId column
     *
     * Example usage:
     * <code>
     * $query->filterByPositionid(1234); // WHERE positionId = 1234
     * $query->filterByPositionid(array(12, 34)); // WHERE positionId IN (12, 34)
     * $query->filterByPositionid(array('min' => 12)); // WHERE positionId > 12
     * </code>
     *
     * @see       filterByPosition()
     *
     * @param     mixed $positionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByPositionid($positionid = null, $comparison = null)
    {
        if (is_array($positionid)) {
            $useMinMax = false;
            if (isset($positionid['min'])) {
                $this->addUsingAlias(IndicatorPeer::POSITIONID, $positionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positionid['max'])) {
                $this->addUsingAlias(IndicatorPeer::POSITIONID, $positionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::POSITIONID, $positionid, $comparison);
    }

    /**
     * Filter the query on the objectiveId column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectiveid(1234); // WHERE objectiveId = 1234
     * $query->filterByObjectiveid(array(12, 34)); // WHERE objectiveId IN (12, 34)
     * $query->filterByObjectiveid(array('min' => 12)); // WHERE objectiveId > 12
     * </code>
     *
     * @see       filterByObjective()
     *
     * @param     mixed $objectiveid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByObjectiveid($objectiveid = null, $comparison = null)
    {
        if (is_array($objectiveid)) {
            $useMinMax = false;
            if (isset($objectiveid['min'])) {
                $this->addUsingAlias(IndicatorPeer::OBJECTIVEID, $objectiveid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectiveid['max'])) {
                $this->addUsingAlias(IndicatorPeer::OBJECTIVEID, $objectiveid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::OBJECTIVEID, $objectiveid, $comparison);
    }

    /**
     * Filter the query on the dueDate column
     *
     * Example usage:
     * <code>
     * $query->filterByDuedate('2011-03-14'); // WHERE dueDate = '2011-03-14'
     * $query->filterByDuedate('now'); // WHERE dueDate = '2011-03-14'
     * $query->filterByDuedate(array('max' => 'yesterday')); // WHERE dueDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $duedate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByDuedate($duedate = null, $comparison = null)
    {
        if (is_array($duedate)) {
            $useMinMax = false;
            if (isset($duedate['min'])) {
                $this->addUsingAlias(IndicatorPeer::DUEDATE, $duedate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($duedate['max'])) {
                $this->addUsingAlias(IndicatorPeer::DUEDATE, $duedate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::DUEDATE, $duedate, $comparison);
    }

    /**
     * Filter the query on the finishedDate column
     *
     * Example usage:
     * <code>
     * $query->filterByFinisheddate('2011-03-14'); // WHERE finishedDate = '2011-03-14'
     * $query->filterByFinisheddate('now'); // WHERE finishedDate = '2011-03-14'
     * $query->filterByFinisheddate(array('max' => 'yesterday')); // WHERE finishedDate > '2011-03-13'
     * </code>
     *
     * @param     mixed $finisheddate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByFinisheddate($finisheddate = null, $comparison = null)
    {
        if (is_array($finisheddate)) {
            $useMinMax = false;
            if (isset($finisheddate['min'])) {
                $this->addUsingAlias(IndicatorPeer::FINISHEDDATE, $finisheddate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($finisheddate['max'])) {
                $this->addUsingAlias(IndicatorPeer::FINISHEDDATE, $finisheddate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::FINISHEDDATE, $finisheddate, $comparison);
    }

    /**
     * Filter the query on the classKey column
     *
     * Example usage:
     * <code>
     * $query->filterByClasskey(1234); // WHERE classKey = 1234
     * $query->filterByClasskey(array(12, 34)); // WHERE classKey IN (12, 34)
     * $query->filterByClasskey(array('min' => 12)); // WHERE classKey > 12
     * </code>
     *
     * @param     mixed $classkey The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function filterByClasskey($classkey = null, $comparison = null)
    {
        if (is_array($classkey)) {
            $useMinMax = false;
            if (isset($classkey['min'])) {
                $this->addUsingAlias(IndicatorPeer::CLASSKEY, $classkey['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($classkey['max'])) {
                $this->addUsingAlias(IndicatorPeer::CLASSKEY, $classkey['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(IndicatorPeer::CLASSKEY, $classkey, $comparison);
    }

    /**
     * Filter the query by a related Position object
     *
     * @param   Position|PropelObjectCollection $position The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof Position) {
            return $this
                ->addUsingAlias(IndicatorPeer::POSITIONID, $position->getId(), $comparison);
        } elseif ($position instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorPeer::POSITIONID, $position->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type Position or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', 'PositionQuery');
    }

    /**
     * Filter the query by a related Objective object
     *
     * @param   Objective|PropelObjectCollection $objective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByObjective($objective, $comparison = null)
    {
        if ($objective instanceof Objective) {
            return $this
                ->addUsingAlias(IndicatorPeer::OBJECTIVEID, $objective->getId(), $comparison);
        } elseif ($objective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(IndicatorPeer::OBJECTIVEID, $objective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByObjective() only accepts arguments of type Objective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Objective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinObjective($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Objective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Objective');
        }

        return $this;
    }

    /**
     * Use the Objective relation Objective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useObjectiveQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Objective', 'ObjectiveQuery');
    }

    /**
     * Filter the query by a related IndicatorValue object
     *
     * @param   IndicatorValue|PropelObjectCollection $indicatorValue  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorValue($indicatorValue, $comparison = null)
    {
        if ($indicatorValue instanceof IndicatorValue) {
            return $this
                ->addUsingAlias(IndicatorPeer::ID, $indicatorValue->getNumericindicatorid(), $comparison);
        } elseif ($indicatorValue instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorValueQuery()
                ->filterByPrimaryKeys($indicatorValue->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicatorValue() only accepts arguments of type IndicatorValue or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorValue relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinIndicatorValue($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorValue');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorValue');
        }

        return $this;
    }

    /**
     * Use the IndicatorValue relation IndicatorValue object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorValueQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorValueQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinIndicatorValue($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorValue', 'IndicatorValueQuery');
    }

    /**
     * Filter the query by a related IndicatorGraphSerie object
     *
     * @param   IndicatorGraphSerie|PropelObjectCollection $indicatorGraphSerie  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByIndicatorGraphSerie($indicatorGraphSerie, $comparison = null)
    {
        if ($indicatorGraphSerie instanceof IndicatorGraphSerie) {
            return $this
                ->addUsingAlias(IndicatorPeer::ID, $indicatorGraphSerie->getIndicatorid(), $comparison);
        } elseif ($indicatorGraphSerie instanceof PropelObjectCollection) {
            return $this
                ->useIndicatorGraphSerieQuery()
                ->filterByPrimaryKeys($indicatorGraphSerie->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByIndicatorGraphSerie() only accepts arguments of type IndicatorGraphSerie or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the IndicatorGraphSerie relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinIndicatorGraphSerie($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('IndicatorGraphSerie');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'IndicatorGraphSerie');
        }

        return $this;
    }

    /**
     * Use the IndicatorGraphSerie relation IndicatorGraphSerie object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   IndicatorGraphSerieQuery A secondary query class using the current class as primary query
     */
    public function useIndicatorGraphSerieQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinIndicatorGraphSerie($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'IndicatorGraphSerie', 'IndicatorGraphSerieQuery');
    }

    /**
     * Filter the query by a related PolicyGuidelineIndicators object
     *
     * @param   PolicyGuidelineIndicators|PropelObjectCollection $policyGuidelineIndicators  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuidelineIndicators($policyGuidelineIndicators, $comparison = null)
    {
        if ($policyGuidelineIndicators instanceof PolicyGuidelineIndicators) {
            return $this
                ->addUsingAlias(IndicatorPeer::ID, $policyGuidelineIndicators->getIndicatorid(), $comparison);
        } elseif ($policyGuidelineIndicators instanceof PropelObjectCollection) {
            return $this
                ->usePolicyGuidelineIndicatorsQuery()
                ->filterByPrimaryKeys($policyGuidelineIndicators->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPolicyGuidelineIndicators() only accepts arguments of type PolicyGuidelineIndicators or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuidelineIndicators relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinPolicyGuidelineIndicators($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuidelineIndicators');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuidelineIndicators');
        }

        return $this;
    }

    /**
     * Use the PolicyGuidelineIndicators relation PolicyGuidelineIndicators object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineIndicatorsQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineIndicatorsQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPolicyGuidelineIndicators($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuidelineIndicators', 'PolicyGuidelineIndicatorsQuery');
    }

    /**
     * Filter the query by a related Project object
     *
     * @param   Project|PropelObjectCollection $project  the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByProject($project, $comparison = null)
    {
        if ($project instanceof Project) {
            return $this
                ->addUsingAlias(IndicatorPeer::ID, $project->getIndicatorid(), $comparison);
        } elseif ($project instanceof PropelObjectCollection) {
            return $this
                ->useProjectQuery()
                ->filterByPrimaryKeys($project->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByProject() only accepts arguments of type Project or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Project relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function joinProject($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Project');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Project');
        }

        return $this;
    }

    /**
     * Use the Project relation Project object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ProjectQuery A secondary query class using the current class as primary query
     */
    public function useProjectQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinProject($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Project', 'ProjectQuery');
    }

    /**
     * Filter the query by a related IndicatorGraph object
     * using the indicators_graphSerie table as cross reference
     *
     * @param   IndicatorGraph $indicatorGraph the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     */
    public function filterByIndicatorGraph($indicatorGraph, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useIndicatorGraphSerieQuery()
            ->filterByIndicatorGraph($indicatorGraph, $comparison)
            ->endUse();
    }

    /**
     * Filter the query by a related PolicyGuideline object
     * using the objectives_policyGuidelineIndicators table as cross reference
     *
     * @param   PolicyGuideline $policyGuideline the related object to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   IndicatorQuery The current query, for fluid interface
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = Criteria::EQUAL)
    {
        return $this
            ->usePolicyGuidelineIndicatorsQuery()
            ->filterByPolicyGuideline($policyGuideline, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   Indicator $indicator Object to remove from the list of results
     *
     * @return IndicatorQuery The current query, for fluid interface
     */
    public function prune($indicator = null)
    {
        if ($indicator) {
            $this->addUsingAlias(IndicatorPeer::ID, $indicator->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
