<?php

use Egytca\Statements\Factory as StmntFactory;
use Egytca\Statements\StringStatement;
use Egytca\Status\OnTheFly\Query\StatusQuery;

/**
 * Numeric Indicators
 */
class NumericIndicatorQuery extends BaseNumericIndicatorQuery {

	use StatusQuery;

	private function sqlForSelectLastValue($selectFields = '*', $additionalCondition = null, $classKey = null) {
		$sql = "(SELECT $selectFields FROM indicators_value WHERE ("
				. ' (indicators_indicator.id=indicators_value.numericIndicatorId)';
				if ($classKey !== null) {
					$sql .= " AND (indicators_value.classKey=$classKey)";
				}
				if ($additionalCondition !== null) {
					$sql .= " AND ($additionalCondition)";
				}
		$sql .= ')'
			. ' ORDER BY indicators_value.date DESC'
			. ' LIMIT 1'
		 	. ')';
		return $sql;
	}

	private function sqlForSelectLastExpectedValue($selectFields = '*', $additionalCondition = null) {
		$classKey = IndicatorValuePeer::CLASSKEY_EXPECTEDINDICATORVALUE;
		return $this->sqlForSelectLastValue($selectFields, $additionalCondition, $classKey);
	}

	private function sqlForSelectLastExpectedValuePastDue($selectFields = '*') {
		$today = date('Y-m-d');
		$pastDueCondition = "indicators_value.date < '$today'";
		return $this->sqlForSelectLastExpectedValue($selectFields, $pastDueCondition);
	}

	private function sqlForSelectLastRealValue($selectFields = '*', $additionalCondition = null) {
		$classKey = IndicatorValuePeer::CLASSKEY_REALINDICATORVALUE;
		return $this->sqlForSelectLastValue($selectFields, $additionalCondition, $classKey);
	}

	private function stmntForExpectedValuesExist() {
		$this->joinIndicatorValue();
		$classKey = IndicatorValuePeer::CLASSKEY_EXPECTEDINDICATORVALUE;
		return StmntFactory::create($this->sqlForSelectLastExpectedValue(), 'EXISTS');
	}

	private function stmntForExpectedValuesPastDueExist() {
		$this->joinIndicatorValue();
		return StmntFactory::create($this->sqlForSelectLastExpectedValuePastDue(), 'EXISTS');
	}

	private function stmntForRealValuesExist() {
		$this->joinIndicatorValue();
		return StmntFactory::create($this->sqlForSelectLastRealValue(), 'EXISTS');
	}

	private function stmntForLastExpectedValueIsPastDue() {
		$this->joinIndicatorValue();
		$today = date('Y-m-d');
		$dateOflastExpectedValue = $this->sqlForSelectLastExpectedValue('date');
		return StmntFactory::create($dateOflastExpectedValue, '<', "'$today'");
	}

	private function stmntForAcceptedLastRealValue() {
		$this->joinIndicatorValue();
		$lastExpectedValue = $this->sqlForSelectLastExpectedValue('value');
		$lastRealValue = $this->sqlForSelectLastRealValue('value');
		return StmntFactory::create($lastRealValue, '>=', $lastExpectedValue);
	}

	private function stmntForAcceptedLastRealValueVsTolerance($toleranceType, $comparison) {

		$validToleranceTypes = ['ontime', 'delayed'];
		if (!in_array($toleranceType, $validToleranceTypes))
			throw new Exception("invalid tolerance type '$toleranceType'");

		$timeTolerances = ConfigModule::get('indicators', 'valueTolerances');
		$tolerance = $timeTolerances[$toleranceType];

		$this->joinIndicatorValue();

		$coefficient = 1 - $tolerance;
		$lastExpectedValuePastDue = $this->sqlForSelectLastExpectedValuePastDue('value');
		$minValue = "$coefficient * $lastExpectedValuePastDue";
		$lastRealValue = $this->sqlForSelectLastRealValue('value');
		return StmntFactory::create($lastRealValue, $comparison, $minValue);
	}

	/* ******************** status undefined ******************** */
	function statementForStatusUndefined($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()->invert();
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusUndefined($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusUndefined($comparison)->toString())
			->distinct();
	}
	/* ****************** end status undefined ****************** */

	/* ******************** status planned ******************** */
	function statementForStatusPlanned($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()
			->andWith($this->stmntForExpectedValuesPastDueExist()->invert());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusPlanned($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusPlanned($comparison)->toString())
			->distinct();
	}
	/* ****************** end status planned ****************** */

	/* ******************** status late ******************** */
	function statementForStatusLate($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()
			->andWith($this->stmntForExpectedValuesPastDueExist())
			->andWith(
				$this->stmntForRealValuesExist()->invert()
					->orWith(
						$this->statusFinishedOnlyPart()->invert()
							->andWith($this->stmntForAcceptedLastRealValueVsTolerance('delayed', '<'))
					)
			);
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusLate($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusLate($comparison)->toString())
			->distinct();
	}
	/* ****************** end status late ****************** */

	/* ******************** status finished ******************** */
	private function statusFinishedOnlyPart() {
		return $this->stmntForLastExpectedValueIsPastDue()
			->andWith($this->stmntForAcceptedLastRealValue());
	}

	function statementForStatusFinished($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()
			->andWith($this->stmntForExpectedValuesPastDueExist())
			->andWith($this->stmntForRealValuesExist())
			->andWith($this->statusFinishedOnlyPart());
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusFinished($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusFinished($comparison)->toString())
			->distinct();
	}
	/* ****************** end status finished ****************** */

	/* ******************** status ontime ******************** */
	function statementForStatusOntime($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()
			->andWith($this->stmntForExpectedValuesPastDueExist())
			->andWith($this->stmntForRealValuesExist())
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->stmntForAcceptedLastRealValueVsTolerance('ontime', '>='));
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusOntime($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusOntime($comparison)->toString())
			->distinct();
	}
	/* ****************** end status ontime ****************** */

	/* ******************** status delayed ******************** */
	function statementForStatusDelayed($comparison = Criteria::EQUAL) {
		$statement = $this->stmntForExpectedValuesExist()
			->andWith($this->stmntForExpectedValuesPastDueExist())
			->andWith($this->stmntForRealValuesExist())
			->andWith($this->statusFinishedOnlyPart()->invert())
			->andWith($this->stmntForAcceptedLastRealValueVsTolerance('ontime', '<'))
			->andWith($this->stmntForAcceptedLastRealValueVsTolerance('delayed', '>='));
		return $comparison == Criteria::EQUAL ? $statement : $statement->invert();
	}

	function filterByStatusDelayed($comparison = Criteria::EQUAL) {
		return $this->where($this->statementForStatusDelayed($comparison)->toString())
			->distinct();
	}
	/* ****************** end status delayed ****************** */

	function stmntForUnmetDueDate($value, $comparison = null) {

		$peer = $this->getModelPeerName();

		$sqlMinDate = "'" . $value['min'] . "'";
		$sqlMaxDate = "'" . $value['max'] . "'";

		$this->joinIndicatorValue();


		$noRealValues = $this->stmntForRealValuesExist()->invert();

		$expectedClassKey = IndicatorValuePeer::CLASSKEY_EXPECTEDINDICATORVALUE;
		$isExpectedValue = new StringStatement("indicators_value.classKey=$expectedClassKey");

		$lastRealValue = $this->sqlForSelectLastRealValue('value');
		$notAchieved = StmntFactory::create('indicators_value.value',  '>', "($lastRealValue)");

		$greaterEqualThanMinDate = StmntFactory::create('indicators_value.date', '>=', $sqlMinDate);
		$lessEqualThanMaxDate = StmntFactory::create('indicators_value.date', '<=', $sqlMaxDate);
		$beetweenMinMaxDate = StmntFactory::create($greaterEqualThanMinDate, 'AND', $lessEqualThanMaxDate);

		$statement = $isExpectedValue
			->andWith(
				$noRealValues
				->orWith($notAchieved)
			)
			->andWith($beetweenMinMaxDate);

		return $statement;
	}

	function filterByUnmetDueDate($value, $comparison = null) {
		return $this->where($this->stmntForUnmetDueDate($value, $comparison)->toString());
	}
}
