<?php

use Egytca\Interfaces\Node;
use Egytca\Interfaces\Status;

use Egytca\Archivable\ArchivableEntity;
use Egytca\VirtualColumns;

abstract class Indicator extends BaseIndicator implements Node, Status {

	use ArchivableEntity { _preSave as archivableEntityPreSave; }
	use VirtualColumns;

	function __construct() {
		$this->addVirtualColumn('canArchivate', 'canArchivate');
		$this->addVirtualColumn('status', 'getStatus');
	}

	function preSave(PropelPDO $con = null) {
		return parent::preSave() && $this->archivableEntityPreSave();
	}

	function getChildren() {
		return new PropelObjectCollection();
	}

	function getParent() {
		return $this->getObjective();
	}

 /**
	 * Obtiene ultimo registro de valor planificado hasta la fecha
	 */
	function getExpectedIndicatorValue(){
		return ExpectedIndicatorValueQuery::create()
								->orderByDate(Criteria::DESC)
								->filterByIndicator($this)
								->filterByDate(array('max' => time()))
								->findOne();
	}

 /**
	 * Obtiene ultimo registro de valor real hasta la fecha
	 */
	function getRealIndicatorValue(){
		return RealIndicatorValueQuery::create()
								->orderByDate(Criteria::DESC)
								->filterByIndicator($this)
								->filterByDate(array('max' => time()))
								->findOne();
	}

}
