<?php

use Egytca\API\Action;

class IndicatorsValuesAutoCreateAction extends Action {

	private $intervalMap = [
		'daily' => NumericIndicator::INTERVAL_DAILY,
		'weekly' => NumericIndicator::INTERVAL_WEEKLY,
		'monthly' => NumericIndicator::INTERVAL_MONTHLY,
		'quarterly' => NumericIndicator::INTERVAL_QUARTERLY,
		'semiannual' => NumericIndicator::INTERVAL_SEMIANNUAL,
		'yearly' => NumericIndicator::INTERVAL_YEARLY
	];

	function __construct() {
		parent::__construct();
		$this->templateName = 'API/Entities.tpl';
	}

	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		$params = [];

		$notEmptyParams = [
			'startDate', 'endDate', 'startValue', 'endValue',
			'interval', 'numericIndicatorId'
		];

		foreach ($notEmptyParams as $param) {
			if (!isset($_POST[$param]))
				return $this->returnFailure(HTTPError::BAD_REQUEST, "missing param: '$param'");
			else
				$params[$param] = $_POST[$param];
		}

		if (!in_array($params['interval'], array_keys($this->intervalMap)))
			return $this->returnFailure(HTTPError::BAD_REQUEST, "invalid interval option: '".$params['interval']."'");
		else
			$interval = $this->intervalMap[$params['interval']];

		$numericIndicator = NumericIndicatorQuery::create()->findOneById($params['numericIndicatorId']);
		if (!$numericIndicator)
			return $this->returnFailure(HTTPError::BAD_REQUEST, "invalid id: '$numericIndicatorId'");

		$expectedIndicatorValues = $numericIndicator->autocreateExpectedIndicatorValues(
			$params['startDate'], $params['endDate'],
			$params['startValue'], $params['endValue'],
			$interval
		);

		$this->smarty->assign('entities', $expectedIndicatorValues);

		return $this->returnSuccess();
	}
}