<?php


/**
 * Base class that represents a query for the 'constructions_inspectionPhoto' table.
 *
 * Relacion de inspecciones y fotos
 *
 * @method InspectionPhotoQuery orderByInspectionid($order = Criteria::ASC) Order by the inspectionId column
 * @method InspectionPhotoQuery orderByPhotoid($order = Criteria::ASC) Order by the photoId column
 *
 * @method InspectionPhotoQuery groupByInspectionid() Group by the inspectionId column
 * @method InspectionPhotoQuery groupByPhotoid() Group by the photoId column
 *
 * @method InspectionPhotoQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method InspectionPhotoQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method InspectionPhotoQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method InspectionPhotoQuery leftJoinInspection($relationAlias = null) Adds a LEFT JOIN clause to the query using the Inspection relation
 * @method InspectionPhotoQuery rightJoinInspection($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Inspection relation
 * @method InspectionPhotoQuery innerJoinInspection($relationAlias = null) Adds a INNER JOIN clause to the query using the Inspection relation
 *
 * @method InspectionPhotoQuery leftJoinResource($relationAlias = null) Adds a LEFT JOIN clause to the query using the Resource relation
 * @method InspectionPhotoQuery rightJoinResource($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Resource relation
 * @method InspectionPhotoQuery innerJoinResource($relationAlias = null) Adds a INNER JOIN clause to the query using the Resource relation
 *
 * @method InspectionPhoto findOne(PropelPDO $con = null) Return the first InspectionPhoto matching the query
 * @method InspectionPhoto findOneOrCreate(PropelPDO $con = null) Return the first InspectionPhoto matching the query, or a new InspectionPhoto object populated from the query conditions when no match is found
 *
 * @method InspectionPhoto findOneByInspectionid(int $inspectionId) Return the first InspectionPhoto filtered by the inspectionId column
 * @method InspectionPhoto findOneByPhotoid(int $photoId) Return the first InspectionPhoto filtered by the photoId column
 *
 * @method array findByInspectionid(int $inspectionId) Return InspectionPhoto objects filtered by the inspectionId column
 * @method array findByPhotoid(int $photoId) Return InspectionPhoto objects filtered by the photoId column
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseInspectionPhotoQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseInspectionPhotoQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'InspectionPhoto', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new InspectionPhotoQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     InspectionPhotoQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return InspectionPhotoQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof InspectionPhotoQuery) {
            return $criteria;
        }
        $query = new InspectionPhotoQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array $key Primary key to use for the query
                         A Primary key composition: [$inspectionId, $photoId]
     * @param     PropelPDO $con an optional connection object
     *
     * @return   InspectionPhoto|InspectionPhoto[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = InspectionPhotoPeer::getInstanceFromPool(serialize(array((string) $key[0], (string) $key[1]))))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(InspectionPhotoPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   InspectionPhoto A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `INSPECTIONID`, `PHOTOID` FROM `constructions_inspectionPhoto` WHERE `INSPECTIONID` = :p0 AND `PHOTOID` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new InspectionPhoto();
            $obj->hydrate($row);
            InspectionPhotoPeer::addInstanceToPool($obj, serialize(array((string) $key[0], (string) $key[1])));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return InspectionPhoto|InspectionPhoto[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|InspectionPhoto[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(InspectionPhotoPeer::INSPECTIONID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(InspectionPhotoPeer::PHOTOID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(InspectionPhotoPeer::INSPECTIONID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(InspectionPhotoPeer::PHOTOID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the inspectionId column
     *
     * Example usage:
     * <code>
     * $query->filterByInspectionid(1234); // WHERE inspectionId = 1234
     * $query->filterByInspectionid(array(12, 34)); // WHERE inspectionId IN (12, 34)
     * $query->filterByInspectionid(array('min' => 12)); // WHERE inspectionId > 12
     * </code>
     *
     * @see       filterByInspection()
     *
     * @param     mixed $inspectionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function filterByInspectionid($inspectionid = null, $comparison = null)
    {
        if (is_array($inspectionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(InspectionPhotoPeer::INSPECTIONID, $inspectionid, $comparison);
    }

    /**
     * Filter the query on the photoId column
     *
     * Example usage:
     * <code>
     * $query->filterByPhotoid(1234); // WHERE photoId = 1234
     * $query->filterByPhotoid(array(12, 34)); // WHERE photoId IN (12, 34)
     * $query->filterByPhotoid(array('min' => 12)); // WHERE photoId > 12
     * </code>
     *
     * @see       filterByResource()
     *
     * @param     mixed $photoid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function filterByPhotoid($photoid = null, $comparison = null)
    {
        if (is_array($photoid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(InspectionPhotoPeer::PHOTOID, $photoid, $comparison);
    }

    /**
     * Filter the query by a related Inspection object
     *
     * @param   Inspection|PropelObjectCollection $inspection The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionPhotoQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByInspection($inspection, $comparison = null)
    {
        if ($inspection instanceof Inspection) {
            return $this
                ->addUsingAlias(InspectionPhotoPeer::INSPECTIONID, $inspection->getId(), $comparison);
        } elseif ($inspection instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(InspectionPhotoPeer::INSPECTIONID, $inspection->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByInspection() only accepts arguments of type Inspection or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Inspection relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function joinInspection($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Inspection');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Inspection');
        }

        return $this;
    }

    /**
     * Use the Inspection relation Inspection object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   InspectionQuery A secondary query class using the current class as primary query
     */
    public function useInspectionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinInspection($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Inspection', 'InspectionQuery');
    }

    /**
     * Filter the query by a related Resource object
     *
     * @param   Resource|PropelObjectCollection $resource The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   InspectionPhotoQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByResource($resource, $comparison = null)
    {
        if ($resource instanceof Resource) {
            return $this
                ->addUsingAlias(InspectionPhotoPeer::PHOTOID, $resource->getId(), $comparison);
        } elseif ($resource instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(InspectionPhotoPeer::PHOTOID, $resource->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByResource() only accepts arguments of type Resource or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Resource relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function joinResource($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Resource');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Resource');
        }

        return $this;
    }

    /**
     * Use the Resource relation Resource object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ResourceQuery A secondary query class using the current class as primary query
     */
    public function useResourceQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinResource($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Resource', 'ResourceQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   InspectionPhoto $inspectionPhoto Object to remove from the list of results
     *
     * @return InspectionPhotoQuery The current query, for fluid interface
     */
    public function prune($inspectionPhoto = null)
    {
        if ($inspectionPhoto) {
            $this->addCond('pruneCond0', $this->getAliasedColName(InspectionPhotoPeer::INSPECTIONID), $inspectionPhoto->getInspectionid(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(InspectionPhotoPeer::PHOTOID), $inspectionPhoto->getPhotoid(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

}
