<?php


/**
 * Base class that represents a query for the 'constructions_progress' table.
 *
 * Ejecucion fisico/financiera
 *
 * @method ConstructionProgressQuery orderById($order = Criteria::ASC) Order by the id column
 * @method ConstructionProgressQuery orderByConstructionid($order = Criteria::ASC) Order by the constructionId column
 * @method ConstructionProgressQuery orderByYear($order = Criteria::ASC) Order by the year column
 * @method ConstructionProgressQuery orderByMonth($order = Criteria::ASC) Order by the month column
 * @method ConstructionProgressQuery orderByPhysicalprogress($order = Criteria::ASC) Order by the physicalProgress column
 * @method ConstructionProgressQuery orderByFinancialprogress($order = Criteria::ASC) Order by the financialProgress column
 * @method ConstructionProgressQuery orderByRealphysicalprogress($order = Criteria::ASC) Order by the realPhysicalProgress column
 * @method ConstructionProgressQuery orderByRealfinancialprogress($order = Criteria::ASC) Order by the realFinancialProgress column
 *
 * @method ConstructionProgressQuery groupById() Group by the id column
 * @method ConstructionProgressQuery groupByConstructionid() Group by the constructionId column
 * @method ConstructionProgressQuery groupByYear() Group by the year column
 * @method ConstructionProgressQuery groupByMonth() Group by the month column
 * @method ConstructionProgressQuery groupByPhysicalprogress() Group by the physicalProgress column
 * @method ConstructionProgressQuery groupByFinancialprogress() Group by the financialProgress column
 * @method ConstructionProgressQuery groupByRealphysicalprogress() Group by the realPhysicalProgress column
 * @method ConstructionProgressQuery groupByRealfinancialprogress() Group by the realFinancialProgress column
 *
 * @method ConstructionProgressQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method ConstructionProgressQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method ConstructionProgressQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method ConstructionProgressQuery leftJoinConstruction($relationAlias = null) Adds a LEFT JOIN clause to the query using the Construction relation
 * @method ConstructionProgressQuery rightJoinConstruction($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Construction relation
 * @method ConstructionProgressQuery innerJoinConstruction($relationAlias = null) Adds a INNER JOIN clause to the query using the Construction relation
 *
 * @method ConstructionProgress findOne(PropelPDO $con = null) Return the first ConstructionProgress matching the query
 * @method ConstructionProgress findOneOrCreate(PropelPDO $con = null) Return the first ConstructionProgress matching the query, or a new ConstructionProgress object populated from the query conditions when no match is found
 *
 * @method ConstructionProgress findOneById(int $id) Return the first ConstructionProgress filtered by the id column
 * @method ConstructionProgress findOneByConstructionid(int $constructionId) Return the first ConstructionProgress filtered by the constructionId column
 * @method ConstructionProgress findOneByYear(int $year) Return the first ConstructionProgress filtered by the year column
 * @method ConstructionProgress findOneByMonth(int $month) Return the first ConstructionProgress filtered by the month column
 * @method ConstructionProgress findOneByPhysicalprogress(string $physicalProgress) Return the first ConstructionProgress filtered by the physicalProgress column
 * @method ConstructionProgress findOneByFinancialprogress(string $financialProgress) Return the first ConstructionProgress filtered by the financialProgress column
 * @method ConstructionProgress findOneByRealphysicalprogress(string $realPhysicalProgress) Return the first ConstructionProgress filtered by the realPhysicalProgress column
 * @method ConstructionProgress findOneByRealfinancialprogress(string $realFinancialProgress) Return the first ConstructionProgress filtered by the realFinancialProgress column
 *
 * @method array findById(int $id) Return ConstructionProgress objects filtered by the id column
 * @method array findByConstructionid(int $constructionId) Return ConstructionProgress objects filtered by the constructionId column
 * @method array findByYear(int $year) Return ConstructionProgress objects filtered by the year column
 * @method array findByMonth(int $month) Return ConstructionProgress objects filtered by the month column
 * @method array findByPhysicalprogress(string $physicalProgress) Return ConstructionProgress objects filtered by the physicalProgress column
 * @method array findByFinancialprogress(string $financialProgress) Return ConstructionProgress objects filtered by the financialProgress column
 * @method array findByRealphysicalprogress(string $realPhysicalProgress) Return ConstructionProgress objects filtered by the realPhysicalProgress column
 * @method array findByRealfinancialprogress(string $realFinancialProgress) Return ConstructionProgress objects filtered by the realFinancialProgress column
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseConstructionProgressQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseConstructionProgressQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'ConstructionProgress', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ConstructionProgressQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     ConstructionProgressQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return ConstructionProgressQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof ConstructionProgressQuery) {
            return $criteria;
        }
        $query = new ConstructionProgressQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   ConstructionProgress|ConstructionProgress[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = ConstructionProgressPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(ConstructionProgressPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   ConstructionProgress A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `CONSTRUCTIONID`, `YEAR`, `MONTH`, `PHYSICALPROGRESS`, `FINANCIALPROGRESS`, `REALPHYSICALPROGRESS`, `REALFINANCIALPROGRESS` FROM `constructions_progress` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new ConstructionProgress();
            $obj->hydrate($row);
            ConstructionProgressPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return ConstructionProgress|ConstructionProgress[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|ConstructionProgress[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ConstructionProgressPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ConstructionProgressPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(ConstructionProgressPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the constructionId column
     *
     * Example usage:
     * <code>
     * $query->filterByConstructionid(1234); // WHERE constructionId = 1234
     * $query->filterByConstructionid(array(12, 34)); // WHERE constructionId IN (12, 34)
     * $query->filterByConstructionid(array('min' => 12)); // WHERE constructionId > 12
     * </code>
     *
     * @see       filterByConstruction()
     *
     * @param     mixed $constructionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByConstructionid($constructionid = null, $comparison = null)
    {
        if (is_array($constructionid)) {
            $useMinMax = false;
            if (isset($constructionid['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::CONSTRUCTIONID, $constructionid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($constructionid['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::CONSTRUCTIONID, $constructionid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::CONSTRUCTIONID, $constructionid, $comparison);
    }

    /**
     * Filter the query on the year column
     *
     * Example usage:
     * <code>
     * $query->filterByYear(1234); // WHERE year = 1234
     * $query->filterByYear(array(12, 34)); // WHERE year IN (12, 34)
     * $query->filterByYear(array('min' => 12)); // WHERE year > 12
     * </code>
     *
     * @param     mixed $year The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByYear($year = null, $comparison = null)
    {
        if (is_array($year)) {
            $useMinMax = false;
            if (isset($year['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::YEAR, $year['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($year['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::YEAR, $year['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::YEAR, $year, $comparison);
    }

    /**
     * Filter the query on the month column
     *
     * Example usage:
     * <code>
     * $query->filterByMonth(1234); // WHERE month = 1234
     * $query->filterByMonth(array(12, 34)); // WHERE month IN (12, 34)
     * $query->filterByMonth(array('min' => 12)); // WHERE month > 12
     * </code>
     *
     * @param     mixed $month The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByMonth($month = null, $comparison = null)
    {
        if (is_array($month)) {
            $useMinMax = false;
            if (isset($month['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::MONTH, $month['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($month['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::MONTH, $month['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::MONTH, $month, $comparison);
    }

    /**
     * Filter the query on the physicalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByPhysicalprogress(1234); // WHERE physicalProgress = 1234
     * $query->filterByPhysicalprogress(array(12, 34)); // WHERE physicalProgress IN (12, 34)
     * $query->filterByPhysicalprogress(array('min' => 12)); // WHERE physicalProgress > 12
     * </code>
     *
     * @param     mixed $physicalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByPhysicalprogress($physicalprogress = null, $comparison = null)
    {
        if (is_array($physicalprogress)) {
            $useMinMax = false;
            if (isset($physicalprogress['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::PHYSICALPROGRESS, $physicalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($physicalprogress['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::PHYSICALPROGRESS, $physicalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::PHYSICALPROGRESS, $physicalprogress, $comparison);
    }

    /**
     * Filter the query on the financialProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByFinancialprogress(1234); // WHERE financialProgress = 1234
     * $query->filterByFinancialprogress(array(12, 34)); // WHERE financialProgress IN (12, 34)
     * $query->filterByFinancialprogress(array('min' => 12)); // WHERE financialProgress > 12
     * </code>
     *
     * @param     mixed $financialprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByFinancialprogress($financialprogress = null, $comparison = null)
    {
        if (is_array($financialprogress)) {
            $useMinMax = false;
            if (isset($financialprogress['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::FINANCIALPROGRESS, $financialprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($financialprogress['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::FINANCIALPROGRESS, $financialprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::FINANCIALPROGRESS, $financialprogress, $comparison);
    }

    /**
     * Filter the query on the realPhysicalProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByRealphysicalprogress(1234); // WHERE realPhysicalProgress = 1234
     * $query->filterByRealphysicalprogress(array(12, 34)); // WHERE realPhysicalProgress IN (12, 34)
     * $query->filterByRealphysicalprogress(array('min' => 12)); // WHERE realPhysicalProgress > 12
     * </code>
     *
     * @param     mixed $realphysicalprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByRealphysicalprogress($realphysicalprogress = null, $comparison = null)
    {
        if (is_array($realphysicalprogress)) {
            $useMinMax = false;
            if (isset($realphysicalprogress['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::REALPHYSICALPROGRESS, $realphysicalprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realphysicalprogress['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::REALPHYSICALPROGRESS, $realphysicalprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::REALPHYSICALPROGRESS, $realphysicalprogress, $comparison);
    }

    /**
     * Filter the query on the realFinancialProgress column
     *
     * Example usage:
     * <code>
     * $query->filterByRealfinancialprogress(1234); // WHERE realFinancialProgress = 1234
     * $query->filterByRealfinancialprogress(array(12, 34)); // WHERE realFinancialProgress IN (12, 34)
     * $query->filterByRealfinancialprogress(array('min' => 12)); // WHERE realFinancialProgress > 12
     * </code>
     *
     * @param     mixed $realfinancialprogress The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function filterByRealfinancialprogress($realfinancialprogress = null, $comparison = null)
    {
        if (is_array($realfinancialprogress)) {
            $useMinMax = false;
            if (isset($realfinancialprogress['min'])) {
                $this->addUsingAlias(ConstructionProgressPeer::REALFINANCIALPROGRESS, $realfinancialprogress['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($realfinancialprogress['max'])) {
                $this->addUsingAlias(ConstructionProgressPeer::REALFINANCIALPROGRESS, $realfinancialprogress['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ConstructionProgressPeer::REALFINANCIALPROGRESS, $realfinancialprogress, $comparison);
    }

    /**
     * Filter the query by a related Construction object
     *
     * @param   Construction|PropelObjectCollection $construction The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   ConstructionProgressQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByConstruction($construction, $comparison = null)
    {
        if ($construction instanceof Construction) {
            return $this
                ->addUsingAlias(ConstructionProgressPeer::CONSTRUCTIONID, $construction->getId(), $comparison);
        } elseif ($construction instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ConstructionProgressPeer::CONSTRUCTIONID, $construction->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByConstruction() only accepts arguments of type Construction or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Construction relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function joinConstruction($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Construction');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Construction');
        }

        return $this;
    }

    /**
     * Use the Construction relation Construction object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   ConstructionQuery A secondary query class using the current class as primary query
     */
    public function useConstructionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinConstruction($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Construction', 'ConstructionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ConstructionProgress $constructionProgress Object to remove from the list of results
     *
     * @return ConstructionProgressQuery The current query, for fluid interface
     */
    public function prune($constructionProgress = null)
    {
        if ($constructionProgress) {
            $this->addUsingAlias(ConstructionProgressPeer::ID, $constructionProgress->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
