<?php


/**
 * Base class that represents a row from the 'constructions_progress' table.
 *
 * Ejecucion fisico/financiera
 *
 * @package    propel.generator.constructions.classes.om
 */
abstract class BaseConstructionProgress extends \Egytca\Propel\Object implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'ConstructionProgressPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        ConstructionProgressPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the id field.
     * @var        int
     */
    protected $id;

    /**
     * The value for the constructionid field.
     * @var        int
     */
    protected $constructionid;

    /**
     * The value for the year field.
     * @var        int
     */
    protected $year;

    /**
     * The value for the month field.
     * @var        int
     */
    protected $month;

    /**
     * The value for the physicalprogress field.
     * @var        string
     */
    protected $physicalprogress;

    /**
     * The value for the financialprogress field.
     * @var        string
     */
    protected $financialprogress;

    /**
     * The value for the realphysicalprogress field.
     * @var        string
     */
    protected $realphysicalprogress;

    /**
     * The value for the realfinancialprogress field.
     * @var        string
     */
    protected $realfinancialprogress;

    /**
     * @var        Construction
     */
    protected $aConstruction;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [constructionid] column value.
     * Id de obra
     * @return int
     */
    public function getConstructionid()
    {
        return $this->constructionid;
    }

    /**
     * Get the [year] column value.
     * Ano
     * @return int
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * Get the [month] column value.
     * Mes
     * @return int
     */
    public function getMonth()
    {
        return $this->month;
    }

    /**
     * Get the [physicalprogress] column value.
     * Avance fisico de la Obra
     * @return string
     */
    public function getPhysicalprogress()
    {
        return $this->physicalprogress;
    }

    /**
     * Get the [financialprogress] column value.
     * Avance financiero de la Obra
     * @return string
     */
    public function getFinancialprogress()
    {
        return $this->financialprogress;
    }

    /**
     * Get the [realphysicalprogress] column value.
     * Avance fisico real de la Obra
     * @return string
     */
    public function getRealphysicalprogress()
    {
        return $this->realphysicalprogress;
    }

    /**
     * Get the [realfinancialprogress] column value.
     * Avance financiero real de la Obra
     * @return string
     */
    public function getRealfinancialprogress()
    {
        return $this->realfinancialprogress;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::ID;
        }


        return $this;
    } // setId()

    /**
     * Set the value of [constructionid] column.
     * Id de obra
     * @param int $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setConstructionid($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->constructionid !== $v) {
            $this->constructionid = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::CONSTRUCTIONID;
        }

        if ($this->aConstruction !== null && $this->aConstruction->getId() !== $v) {
            $this->aConstruction = null;
        }


        return $this;
    } // setConstructionid()

    /**
     * Set the value of [year] column.
     * Ano
     * @param int $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setYear($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->year !== $v) {
            $this->year = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::YEAR;
        }


        return $this;
    } // setYear()

    /**
     * Set the value of [month] column.
     * Mes
     * @param int $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setMonth($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->month !== $v) {
            $this->month = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::MONTH;
        }


        return $this;
    } // setMonth()

    /**
     * Set the value of [physicalprogress] column.
     * Avance fisico de la Obra
     * @param string $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setPhysicalprogress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->physicalprogress !== $v) {
            $this->physicalprogress = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::PHYSICALPROGRESS;
        }


        return $this;
    } // setPhysicalprogress()

    /**
     * Set the value of [financialprogress] column.
     * Avance financiero de la Obra
     * @param string $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setFinancialprogress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->financialprogress !== $v) {
            $this->financialprogress = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::FINANCIALPROGRESS;
        }


        return $this;
    } // setFinancialprogress()

    /**
     * Set the value of [realphysicalprogress] column.
     * Avance fisico real de la Obra
     * @param string $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setRealphysicalprogress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->realphysicalprogress !== $v) {
            $this->realphysicalprogress = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::REALPHYSICALPROGRESS;
        }


        return $this;
    } // setRealphysicalprogress()

    /**
     * Set the value of [realfinancialprogress] column.
     * Avance financiero real de la Obra
     * @param string $v new value
     * @return ConstructionProgress The current object (for fluent API support)
     */
    public function setRealfinancialprogress($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->realfinancialprogress !== $v) {
            $this->realfinancialprogress = $v;
            $this->modifiedColumns[] = ConstructionProgressPeer::REALFINANCIALPROGRESS;
        }


        return $this;
    } // setRealfinancialprogress()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->constructionid = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->year = ($row[$startcol + 2] !== null) ? (int) $row[$startcol + 2] : null;
            $this->month = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->physicalprogress = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->financialprogress = ($row[$startcol + 5] !== null) ? (string) $row[$startcol + 5] : null;
            $this->realphysicalprogress = ($row[$startcol + 6] !== null) ? (string) $row[$startcol + 6] : null;
            $this->realfinancialprogress = ($row[$startcol + 7] !== null) ? (string) $row[$startcol + 7] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = ConstructionProgressPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating ConstructionProgress object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aConstruction !== null && $this->constructionid !== $this->aConstruction->getId()) {
            $this->aConstruction = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionProgressPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = ConstructionProgressPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aConstruction = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionProgressPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = ConstructionProgressQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(ConstructionProgressPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ConstructionProgressPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aConstruction !== null) {
                if ($this->aConstruction->isModified() || $this->aConstruction->isNew()) {
                    $affectedRows += $this->aConstruction->save($con);
                }
                $this->setConstruction($this->aConstruction);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = ConstructionProgressPeer::ID;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ConstructionProgressPeer::ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ConstructionProgressPeer::ID)) {
            $modifiedColumns[':p' . $index++]  = '`ID`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::CONSTRUCTIONID)) {
            $modifiedColumns[':p' . $index++]  = '`CONSTRUCTIONID`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::YEAR)) {
            $modifiedColumns[':p' . $index++]  = '`YEAR`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::MONTH)) {
            $modifiedColumns[':p' . $index++]  = '`MONTH`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::PHYSICALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`PHYSICALPROGRESS`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::FINANCIALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`FINANCIALPROGRESS`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::REALPHYSICALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`REALPHYSICALPROGRESS`';
        }
        if ($this->isColumnModified(ConstructionProgressPeer::REALFINANCIALPROGRESS)) {
            $modifiedColumns[':p' . $index++]  = '`REALFINANCIALPROGRESS`';
        }

        $sql = sprintf(
            'INSERT INTO `constructions_progress` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`ID`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`CONSTRUCTIONID`':
                        $stmt->bindValue($identifier, $this->constructionid, PDO::PARAM_INT);
                        break;
                    case '`YEAR`':
                        $stmt->bindValue($identifier, $this->year, PDO::PARAM_INT);
                        break;
                    case '`MONTH`':
                        $stmt->bindValue($identifier, $this->month, PDO::PARAM_INT);
                        break;
                    case '`PHYSICALPROGRESS`':
                        $stmt->bindValue($identifier, $this->physicalprogress, PDO::PARAM_STR);
                        break;
                    case '`FINANCIALPROGRESS`':
                        $stmt->bindValue($identifier, $this->financialprogress, PDO::PARAM_STR);
                        break;
                    case '`REALPHYSICALPROGRESS`':
                        $stmt->bindValue($identifier, $this->realphysicalprogress, PDO::PARAM_STR);
                        break;
                    case '`REALFINANCIALPROGRESS`':
                        $stmt->bindValue($identifier, $this->realfinancialprogress, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        } else {
            $this->validationFailures = $res;

            return false;
        }
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aConstruction !== null) {
                if (!$this->aConstruction->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aConstruction->getValidationFailures());
                }
            }


            if (($retval = ConstructionProgressPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }



            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ConstructionProgressPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getConstructionid();
                break;
            case 2:
                return $this->getYear();
                break;
            case 3:
                return $this->getMonth();
                break;
            case 4:
                return $this->getPhysicalprogress();
                break;
            case 5:
                return $this->getFinancialprogress();
                break;
            case 6:
                return $this->getRealphysicalprogress();
                break;
            case 7:
                return $this->getRealfinancialprogress();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['ConstructionProgress'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['ConstructionProgress'][$this->getPrimaryKey()] = true;
        $keys = ConstructionProgressPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getConstructionid(),
            $keys[2] => $this->getYear(),
            $keys[3] => $this->getMonth(),
            $keys[4] => $this->getPhysicalprogress(),
            $keys[5] => $this->getFinancialprogress(),
            $keys[6] => $this->getRealphysicalprogress(),
            $keys[7] => $this->getRealfinancialprogress(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aConstruction) {
                $result['Construction'] = $this->aConstruction->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = ConstructionProgressPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setConstructionid($value);
                break;
            case 2:
                $this->setYear($value);
                break;
            case 3:
                $this->setMonth($value);
                break;
            case 4:
                $this->setPhysicalprogress($value);
                break;
            case 5:
                $this->setFinancialprogress($value);
                break;
            case 6:
                $this->setRealphysicalprogress($value);
                break;
            case 7:
                $this->setRealfinancialprogress($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = ConstructionProgressPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setConstructionid($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setYear($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setMonth($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setPhysicalprogress($arr[$keys[4]]);
        if (array_key_exists($keys[5], $arr)) $this->setFinancialprogress($arr[$keys[5]]);
        if (array_key_exists($keys[6], $arr)) $this->setRealphysicalprogress($arr[$keys[6]]);
        if (array_key_exists($keys[7], $arr)) $this->setRealfinancialprogress($arr[$keys[7]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ConstructionProgressPeer::DATABASE_NAME);

        if ($this->isColumnModified(ConstructionProgressPeer::ID)) $criteria->add(ConstructionProgressPeer::ID, $this->id);
        if ($this->isColumnModified(ConstructionProgressPeer::CONSTRUCTIONID)) $criteria->add(ConstructionProgressPeer::CONSTRUCTIONID, $this->constructionid);
        if ($this->isColumnModified(ConstructionProgressPeer::YEAR)) $criteria->add(ConstructionProgressPeer::YEAR, $this->year);
        if ($this->isColumnModified(ConstructionProgressPeer::MONTH)) $criteria->add(ConstructionProgressPeer::MONTH, $this->month);
        if ($this->isColumnModified(ConstructionProgressPeer::PHYSICALPROGRESS)) $criteria->add(ConstructionProgressPeer::PHYSICALPROGRESS, $this->physicalprogress);
        if ($this->isColumnModified(ConstructionProgressPeer::FINANCIALPROGRESS)) $criteria->add(ConstructionProgressPeer::FINANCIALPROGRESS, $this->financialprogress);
        if ($this->isColumnModified(ConstructionProgressPeer::REALPHYSICALPROGRESS)) $criteria->add(ConstructionProgressPeer::REALPHYSICALPROGRESS, $this->realphysicalprogress);
        if ($this->isColumnModified(ConstructionProgressPeer::REALFINANCIALPROGRESS)) $criteria->add(ConstructionProgressPeer::REALFINANCIALPROGRESS, $this->realfinancialprogress);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(ConstructionProgressPeer::DATABASE_NAME);
        $criteria->add(ConstructionProgressPeer::ID, $this->id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of ConstructionProgress (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setConstructionid($this->getConstructionid());
        $copyObj->setYear($this->getYear());
        $copyObj->setMonth($this->getMonth());
        $copyObj->setPhysicalprogress($this->getPhysicalprogress());
        $copyObj->setFinancialprogress($this->getFinancialprogress());
        $copyObj->setRealphysicalprogress($this->getRealphysicalprogress());
        $copyObj->setRealfinancialprogress($this->getRealfinancialprogress());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return ConstructionProgress Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return ConstructionProgressPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new ConstructionProgressPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Construction object.
     *
     * @param             Construction $v
     * @return ConstructionProgress The current object (for fluent API support)
     * @throws PropelException
     */
    public function setConstruction(Construction $v = null)
    {
        if ($v === null) {
            $this->setConstructionid(NULL);
        } else {
            $this->setConstructionid($v->getId());
        }

        $this->aConstruction = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Construction object, it will not be re-added.
        if ($v !== null) {
            $v->addConstructionProgress($this);
        }


        return $this;
    }


    /**
     * Get the associated Construction object
     *
     * @param PropelPDO $con Optional Connection object.
     * @return Construction The associated Construction object.
     * @throws PropelException
     */
    public function getConstruction(PropelPDO $con = null)
    {
        if ($this->aConstruction === null && ($this->constructionid !== null)) {
            $this->aConstruction = ConstructionQuery::create()->findPk($this->constructionid, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aConstruction->addConstructionProgresss($this);
             */
        }

        return $this->aConstruction;
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->id = null;
        $this->constructionid = null;
        $this->year = null;
        $this->month = null;
        $this->physicalprogress = null;
        $this->financialprogress = null;
        $this->realphysicalprogress = null;
        $this->realfinancialprogress = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

        $this->aConstruction = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ConstructionProgressPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
