<?php



/**
 * Skeleton subclass for representing a row from the 'constructions_inspection' table.
 *
 * Inspecciones a la obra
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.constructions.classes
 */
class Inspection extends BaseInspection {

	protected static $statusDesctiptions = [
		1 => 'por comenzar',
		2 => 'en fecha',
		3 => 'retrasado',
		4 => 'cancelado',
		5 => 'terminado',
		6 => 'detenido'
	];

	/**
	 * Devuelve array con estados (statuses) de una obra
	 *  id => Estados posibles
	 *
	 * @return array tipos de estado de una obra
	 */
	public static function getStatuses() {
		$statuses = array(
			1 => 'Blanco',
			2 => 'Verde',
			3 => 'Amarillo',
			// 4 => 'Negro',
			5 => 'Azul',
			6 => 'Rojo'
		);
		return $statuses;
	}

	/**
	 * Devuelve array con ritmos de trabajo (workingRates) de una obra
	 *  id => Estados posibles
	 *
	 * @return array con ritmos de trabajo (workingRates) de una obra
	 */
	public static function getWorkingRates() {
		$workingRates = array(
			1 => 'Nulo',
			2 => 'Bajo',
			3 => 'Medio',
			4 => 'Alto'
		);
		return $workingRates;
	}

	/**
	 * Devuelve array con estados (statuses) de una obra
	 *  id => Estados posibles
	 *
	 * @return array tipos de estado de una obra
	 */
	public function statusColor() {
		$statusColors = array(
			1 => 'white',
			2 => 'green',
			3 => 'yellow',
			4 => 'black',
			5 => 'blue',
			6 => 'red'
		);
		return $statusColors[$this->getStatus()];
	}

	public static function getStatusDescByKey($statusKey) {
		$descs = static::$statusDesctiptions;
		return array_key_exists($statusKey, $descs) ? $descs[$statusKey] : '';
	}

	public function getStatusDesc() {
		$statusKey = $this->getStatus();
		return $statusKey ? static::$statusDesctiptions[$this->getStatus()] : '';
	}


} // Inspection
