<?php

class ConstructionsProgressPhysicalChartXmlAction extends BaseAction {
	
	public function execute($mapping, $form, &$request, &$response) {
		
		parent::execute($mapping, $form, $request, $response);
		
		$plugInKey = 'SMARTY_PLUGIN';
		$smarty =& $this->actionServer->getPlugIn($plugInKey);
		if($smarty == NULL) {
			echo 'No PlugIn found matching key: '.$plugInKey."<br>\n";
		}
		
		if (empty($_GET['id'])) {
			$smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		
		$construction = ConstructionQuery::create()->findOneById($_GET['id']);
		if (!$construction) {
			$smarty->assign('invalidId', true);
			return $mapping->findForwardConfig('success');
		}
		
		
		$constructionProgresses = ConstructionProgressQuery::create()
			->filterByConstruction($construction)
			->orderByMonth(Criteria::ASC)
			->orderByYear(Criteria::ASC)
			->find();
		
		$smarty->assign('constructionProgresses', $constructionProgresses);
		
		header ("content-type: text/xml; charset=utf-8");

		//Encabezado BOM para que el flash chart identifique el UTF-8
		echo pack ( "C3" , 0xef, 0xbb, 0xbf );
		$this->template->template = 'TemplatePlain.tpl';
		
		return $mapping->findForwardConfig('success');
	}
}
