<?php

class ConstructionsDoEditAction extends BaseDoEditAction {
	
	function __construct() {
		parent::__construct('Construction');
	}

	protected function postSave() {
		parent::postSave();

		if(is_object($this->entity)){
			/***
			 * Registros de ejcucion
			 */
			//Guardo los datos de avance fisico financiero asociados a la obra
			foreach ($_POST["progressRecord"] as $progressRecord) {
	
				$this->convertField($progressRecord, 'physicalProgress');
				$this->convertField($progressRecord, 'financialProgress');
				$this->convertField($progressRecord, 'realPhysicalProgress');
				$this->convertField($progressRecord, 'realFinancialProgress');
				
				if (!empty($progressRecord["id"])) {
					$record = ConstructionProgressQuery::create()->findOneById($progressRecord["id"]);	
					if (empty($record))
						$record = new ConstructionProgress();
				}
				else
					$record = new ConstructionProgress();
				$record->fromArray($progressRecord,BasePeer::TYPE_FIELDNAME);
				$record->setConstructionid($this->entity->getId());
				try {
					$record->save();
				} catch (PropelException $exp) {
					if (ConfigModule::get("global","showPropelExceptions"))
						print_r($exp->__toString());
				}
			}
			//Fin Registros de ejcucion
			
			// Actualizo el isConstruction del proyecto cuando guardo una obra nueva
			$project = ProjectQuery::create()->findOneById($this->entity->getProyectId());
			$project->setIsconstruction(true);
			$project->save();
		}
	}
	
	function convertField(&$progressRecord, $field) {
		if (!empty($progressRecord[$field]))
			$progressRecord[$field] = Common::convertToMysqlNumericFormat($progressRecord[$field]);
		elseif ($progressRecord[$field] === '')
			$progressRecord[$field] = null;
	}
}
