<?php



/**
 * This class defines the structure of the 'actors_actor' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    propel.generator.actors.classes.map
 */
class ActorTableMap extends TableMap
{

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'actors.classes.map.ActorTableMap';

    /**
     * Initialize the table attributes, columns and validators
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('actors_actor');
        $this->setPhpName('Actor');
        $this->setClassname('Actor');
        $this->setPackage('actors.classes');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('ID', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('TITLE', 'Title', 'CHAR', false, 15, null);
        $this->addColumn('NAME', 'Name', 'CHAR', false, 90, null);
        $this->addColumn('SURNAME', 'Surname', 'CHAR', false, 90, null);
        $this->addColumn('INSTITUTION', 'Institution', 'CHAR', false, 200, null);
        $this->addColumn('MAILADDRESS', 'Mailaddress', 'VARCHAR', false, 90, null);
        $this->addColumn('DELETED_AT', 'DeletedAt', 'TIMESTAMP', false, null, null);
        // validators
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('ActorCategoryRelation', 'ActorCategoryRelation', RelationMap::ONE_TO_MANY, array('id' => 'actorId', ), 'CASCADE', null, 'ActorCategoryRelations');
        $this->addRelation('ActorRelation', 'ActorRelation', RelationMap::ONE_TO_MANY, array('id' => 'actorToId', ), 'CASCADE', null, 'ActorRelations');
        $this->addRelation('ActorActiveQuestion', 'ActorActiveQuestion', RelationMap::ONE_TO_MANY, array('id' => 'actorId', ), 'CASCADE', null, 'ActorActiveQuestions');
        $this->addRelation('ActorActiveRelationQuestion', 'ActorActiveRelationQuestion', RelationMap::ONE_TO_MANY, array('id' => 'actorToId', ), 'CASCADE', null, 'ActorActiveRelationQuestions');
        $this->addRelation('ActorFormAnswer', 'ActorFormAnswer', RelationMap::ONE_TO_MANY, array('id' => 'actorId', ), 'CASCADE', null, 'ActorFormAnswers');
        $this->addRelation('ActorCategory', 'ActorCategory', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'ActorCategorys');
        $this->addRelation('ProfileForm', 'ProfileForm', RelationMap::MANY_TO_MANY, array(), 'CASCADE', null, 'ProfileForms');
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'soft_delete' => array('deleted_column' => 'deleted_at', ),
        );
    } // getBehaviors()

} // ActorTableMap
