<?php

namespace Egytca\Status;

use ConfigModule;

trait FinishedVsDueDateStatus {

	protected $delayedTolerance;
	protected $ontimeTolerance;

	function _calculateStatus() {

		if (!$this->delayedTolerance || !$this->ontimeTolerance) {
			$timeTolerances = ConfigModule::get('indicators', 'timeTolerances');
			$this->delayedTolerance = $timeTolerances['delayed'];
			$this->ontimeTolerance = $timeTolerances['ontime'];
		}

		if (!$this->getDueDate()) {
			return 'undefined';
		} else if ($this->getFinishedDate()) {
			return 'finished';
		} else {

			$todayTime = strtotime('today');
			$dueTime = $this->getDueDate('U');
			$dueDate = $this->getDueDate('Y-m-d');

			if ($todayTime < $dueTime)
				return 'planned';
			else if ($todayTime <= strtotime($dueDate . ' ' . $this->ontimeTolerance) )
				return 'ontime';
			else if ($todayTime <= strtotime($dueDate . ' ' . $this->delayedTolerance) )
				return 'delayed';
			else
				return 'late';
		}
	}
}
