<?php

namespace Egytca\Statements;

use Exception;

class Factory {

	private static $statementClass = [
		'UnaryStatement' => ['IS NULL', 'IS NOT NULL'],
		'PrefixUnaryStatement' => ['EXISTS', 'NOT EXISTS'],
		'BinaryInvertingStatement' => ['AND', 'OR'],
		'BinaryNonInvertingStatement' => ['<', '<=', '>', '>=']
	];

	static function create($operand1, $operator, $operand2 = null) {

		$operand1 = self::statementize($operand1);
		$operand2 = self::statementize($operand2);

		if (in_array($operator, self::$statementClass['UnaryStatement'])) {
			return new UnaryStatement($operator, $operand1);
		} elseif (in_array($operator, self::$statementClass['PrefixUnaryStatement'])) {
			return new PrefixUnaryStatement($operator, $operand1);
		} else {

			if ($operand2 === null)
				throw new Exception('second operand required');

			if (in_array($operator, self::$statementClass['BinaryInvertingStatement'])) {
				return new BinaryInvertingStatement($operator, $operand1, $operand2);
			} elseif (in_array($operator, self::$statementClass['BinaryNonInvertingStatement'])) {
				return new BinaryNonInvertingStatement($operator, $operand1, $operand2);
			} else {
				throw new Exception("operator '$operator' is not defined");
			}
		}
	}

	private static function statementize($operand) {
		if ( $operand === null || ($operand instanceof Statement) ) {
			return $operand;
		} elseif (is_string($operand)) {
			return new StringStatement($operand);
		} else {
			throw new Exception('$operand must be a Statement object, a string or null');
		}
	}
}
