<?php

namespace Egytca;

use ModelCriteria;

class PropelRelationsConfig {

	private $relationConfigs;

	static function createFromNames(ModelCriteria $query, $relationNames) {
		$relationsConfig = new self();
		$relationsConfig->relationConfigs = [];
		foreach ($relationNames as $relationName) {
			$relationConfig = PropelRelationConfig::createFromName($query, $relationName);
			$relationsConfig->relationConfigs[$relationName] = $relationConfig;
		}
		return $relationsConfig;
	}

	function setRelationConfig($name, $relationConfig) {
		$this->relationConfigs[$name] = $relationConfig;
	}

	function getNames() {
		return $this->getValues('name');
	}

	function getUseDescendantQueryFns() {
		return $this->getValues('useDescendantQueryFn');
	}

	function getValues($propertyName) {
		$values = [];
		foreach ($this->relationConfigs as $i => $relationConfig) {
			$getProperty = 'get' . ucfirst($propertyName);
			$values[] = $relationConfig->$getProperty();
		}
		return $values;
	}

	function getDescendantTable($relationName) {
		return $this->relationConfigs[$relationName]->getDescendantTable();
	}

	function getDescendantColumn($relationName) {
		return $this->relationConfigs[$relationName]->getDescendantColumn();
	}

	function getLocalColumn($relationName) {
		return $this->relationConfigs[$relationName]->getLocalColumn();
	}

	function getUseDescendantQueryFn($relationName) {
		return $this->relationConfigs[$relationName]->getUseDescendantQueryFn();
	}
}


//use ModelCriteria;
use RelationMap;

class PropelRelationConfig {

	private $accessibleFields = [
		'descendantTable',
		'descendantColumn',
		'localColumn',
		'name',
		'useDescendantQueryFn'
	];

	private $descendantTable;
	private $descendantColumn;
	private $localColumn;
	private $name;
	private $useDescendantQueryFn;

	function __call($name, $arguments) {

		if (preg_match('/^get(\w+)$/', $name, $matches)) {
			$property = lcfirst($matches[1]);
			if (in_array($property, $this->accessibleFields))
				return $this->$property;
		}

		if (preg_match('/^set(\w+)$/', $name, $matches)) {
			$property = lcfirst($matches[1]);
			if (in_array($property, $this->accessibleFields))
				$this->$property = $arguments[0];
		}
	}

	static function createFromName(ModelCriteria $query, $name) {

		$tableMap = $query->getTableMap();
		$descendantRelation = $tableMap->getRelation($name);
		$columnMapping = $descendantRelation->getColumnMappings(RelationMap::LOCAL_TO_FOREIGN);

		$relationConfig = new self();
		$relationConfig->setDescendantTable($descendantRelation->getLocalTable()->getName());
		$relationConfig->setDescendantColumn(key($columnMapping));
		$relationConfig->setLocalColumn(reset($columnMapping));
		$relationConfig->setName($name);
		$relationConfig->setUseDescendantQueryFn('use' . $name . 'Query');
		return $relationConfig;
	}
}
