<?php

namespace Egytca\Attempt;

class Proxy {

	const PATTERN = "/^try(.+)$/";

	private $subject;

	static function matches($methodName, &$wantedMethod) {
		if (preg_match(self::PATTERN, $methodName, $matches)) {
			$wantedMethod = lcfirst($matches[1]);
			return true;
		} else {
			return false;
		}
	}

	static function create($subject) {
		return new self($subject);
	}

	function __construct($subject) {
		$this->subject = $subject;
	}

	function __call($name, $arguments) {

		if (self::matches($name, $wantedMethod)) {
			return self::call($this, $wantedMethod, $arguments);
		}

		return $this->subject === null ? null
			: call_user_func_array([$this->subject, $name], $arguments);
	}

	function call($subject, $name, $arguments) {
		$result = call_user_func_array([$subject, $name], $arguments);
		return self::create($result);
	}

	function get() {
		return $this->subject;
	}

	function toString() {
		return $this->subject->toString();
	}

}
