<?php

namespace Egytca\Archivable;

use Exception;
use PropelPDO;

trait ArchivableEntity {

    private $archivedByArchivable = false;

    /**
     * forces archivate()
     * meant for private use by Archivable trait
     */
    function _archivate() {
        $this->setArchived(true);
        $this->archivedByArchivable = true;
        foreach ($this->getChildren() as $child) {
            $child->_archivate();
        }
    }

    function archivate() {

        if ($this->getArchived())
            return $this;

        if ($this->canArchivate()) {
            $this->_archivate();
            return $this;
        } else {
            throw new Exception('cannot archivate: requirements not met');
        }
    }

    function canArchivate() {

        $peer = $this::PEER;

        if (!$this->isColumnModified($peer::ARCHIVED) && $this->getArchived())
            return true;

        if (!$this->isFinished())
            return false;
        foreach ($this->getChildren() as $child) {
            if (!$child->canArchivate())
                return false;
        }
        return true;
    }

    function _preSave(PropelPDO $con = null) {
        $peer = $this::PEER;
        if ($this->isColumnModified($peer::ARCHIVED)) {
            if (!$this->archivedByArchivable) {
                throw new Exception('Only Archivable trait can modify "archived" column');
            }
        }
        return true;
    }
}
