<?php

namespace Egytca\API;

use BasePeer;
use BaseQuery;
use Common;
use Egytca\HTTPError;
use Exception;

class DoEditAction extends Action {

	private $entityClassName;
	protected $entity;
	protected $entityParams;
	protected $actionLog;
	protected $createEntityLog;

	function __construct($entityClassName) {
		parent::__construct();
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		if (!class_exists($entityClassName))
			throw new Exception("class '$entityClassName' does not exist");
		$this->entityClassName = $entityClassName;
		$this->templateName = 'API/Entity.tpl';
	}

	public function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		// navegar a Main.php?do=processesDoEdit crea una entidad vacia nueva!!
		trigger_error('GET requests should not be accepted', E_USER_WARNING);

		$this->entityParams = Common::addUserInfoToParams($_POST["params"]);

		$entityClassName = $this->entityClassName;
		$id = $request->getParameter("id");

		if (!empty($id)) {
			$this->entity = BaseQuery::create($entityClassName)->findOneById($id);
			if (empty($this->entity)) {
				$this->errors->add($this->entityClassName.' with id \''.$id.'\' not found');
				return $this->returnFailure(HTTPError::NOT_FOUND);
			}
		}
		else
			$this->entity = new $entityClassName();

		// Acciones a ejecutar antes de actualizar el objeto
		if ($this->preUpdate() === false)
			return $this->returnFailure();

		// ATENCION!: PHPNAME es Soloprimeramayuscula
		// Uso PHPNAME porque es como lo exporta el toJSON, y se pierde la capitalizacion
		$this->entity->fromArray($this->entityParams, BasePeer::TYPE_PHPNAME);

		// Acciones a ejecutar despues de actualizar el objeto
		$this->postUpdate();

		// Acciones a ejecutar antes de guardar el objeto
		$this->preSave();
		$action = $this->entity->isNew() ? 'create' : 'edit';
		$this->entity->save();
		$logSufix = ', ' . Common::getTranslation('action: '.$action, 'common');
		if ($this->actionLog && method_exists($this->entity, 'getLogData'))
			Common::doLog('success', $this->entity->getLogData() . $logSufix);

		$entityLogClassName = $this->entityClassName.'Log';
		$setEntityId = 'set'.$this->entityClassName.'id';
		if ($this->createEntityLog && class_exists($entityLogClassName)) {
			if (!$this->entity->isNew()) {
				$entityLog = new $entityLogClassName();
				$entityLog->fromJSON($this->entity->toJSON());
				$entityLog->setId(NULL);
				$entityLog->$setEntityId($id);
				$entityLog->save();
			}
		}

		// Acciones a ejecutar luego de guardar el objeto
		$this->postSave();

		return $this->returnSuccess();
	}

	/**
	 * Acciones a tomar despues de actualizar el objeto pero antes de guardarlo
	 */
	protected function preSave() {
		// default: do nothing
	}

	/**
	 * Acciones a tomar despues de guardar el objeto
	 */
	protected function postSave() {
		// default: do nothing
	}

	/**
	 * Chequeos previos al actualizar del objeto (update de datos sin guardarlos)
	 */
	protected function preUpdate() {
		// default: do nothing
	}

	/**
	 * Acciones a tomar despues de actualizar el objeto
	 */
	protected function postUpdate() {
		// default: do nothing
	}

	protected function returnSuccess() {
		$this->assignEntity();
		return parent::returnSuccess();
	}

	private function assignEntity() {
		$this->smarty->assign('entity', $this->entity);
		$this->smarty->assign(lcfirst($this->entityClassName), $this->entity);
	}

}