<?php

namespace Egytca\API;

use BaseQuery;
use Common;
use Egytca\HTTPError;
use Exception;

class DoDeleteAction extends Action {

	private $entityClassName;
	protected $entity;
	protected $params;
	protected $filters;
	protected $actionLog;

	function __construct($entityClassName) {
		parent::__construct();
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		if (!class_exists($entityClassName))
			throw new Exception("class '$entityClassName' does not exist");
		$this->entityClassName = $entityClassName;
		$this->templateName = 'API/Entity.tpl';
	}

	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		trigger_error('GET requests should not be allowed', E_USER_WARNING);

		try {
			// Acciones a ejecutar antes de eliminar el objeto
			// Si el preDelete devuelve false, se retorna failure
			if ($this->preDelete() === false)
				return $this->returnFailure();
		} catch (Exception $e) {
			return $this->returnFailure(HTTPError::INTERNAL_SERVER_ERROR, $e->getMessage()); // esto debería manejarlo el error handling por default
		}

		$id = $request->getParameter("id");
		if (!empty($id)) {
			$this->entity = BaseQuery::create($this->entityClassName)->findOneById($id);
			if (is_null($this->entity)) {
				return $this->returnFailure(HTTPError::BAD_REQUEST, 'invalid id');
			}
		}

		try {

			$this->entity->delete();
			$action = 'delete';
			$logSufix = ', ' . Common::getTranslation('action: '.$action, 'common');
			if ($this->actionLog && method_exists($this->entity, 'getLogData'))
				Common::doLog('success', $this->entity->getLogData() . $logSufix);

			// Acciones a ejecutar despues de eliminar el objeto
			$this->postDelete();
			return $this->returnSuccess();
		} catch (Exception $e) {
			return $this->returnFailure(HTTPError::INTERNAL_SERVER_ERROR, $e->getMessage()); // esto debería manejarlo el error handling por default
		}

		return $this->returnFailure();
	}

	/**
	 * preDelete
	 * Acciones a tomar antes de eliminar el objeto
	 */
	protected function preDelete() {
		// default: do nothing
	}

	/**
	 * postDelete
	 * Acciones a tomar despues de eliminar el objeto
	 */
	protected function postDelete() {
		// default: do nothing
	}

	protected function returnSuccess() {
		$this->assignEntity();
		return parent::returnSuccess();
	}

	private function assignEntity() {
		$this->smarty->assign('entity', $this->entity);
		$this->smarty->assign(lcfirst($this->entityClassName), $this->entity);
	}

}