<?php

namespace Egytca\API;

use Egytca\HTTPError;
use Exception;

class DoArchivateAction extends Action {

	private $entityClassName;
	protected $entity;

	function __construct($entityClassName) {
		parent::__construct();
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		if (!class_exists($entityClassName))
			throw new Exception("class '$entityClassName' does not exist");
		$this->entityClassName = $entityClassName;
		$this->templateName = '';
		$this->templateNameSingle = 'API/Entity.tpl';
		$this->templateNameMultiple = 'API/Entities.tpl';
	}

	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		$paramDescriptors = [[
			'name' => 'id',
			'method' => 'POST',
			'required' => true,
			'nonEmpty' => true,
			'conditions' => ['integerOrArray']
		]];

		if (!$this->checkParams($paramDescriptors))
			return $this->returnFailure(HTTPError::BAD_REQUEST);

		$ids = $this->params['id'];

		$queryClass = $this->entityClassName.'Query';
		$this->entities = $queryClass::create()->findById($ids);
		$foundIds = array_keys($this->entities->toArray('id'));
		$notFoundIds = array_diff($ids, $foundIds);
		if (count($notFoundIds) > 0) {
			foreach ($notFoundIds as $notFoundId) {
				$this->errors->add($this->entityClassName.' with id \''.$notFoundId.'\' not found');
			}
			return $this->returnFailure(HTTPError::NOT_FOUND);
		}

		$allPassed = true;
		foreach ($this->entities as $entity) {
			if ($entity->canArchivate()) {
				$entity->archivate();
			} else {
				$allPassed = false;
				$this->errors->add('cannot archivate '.$this->entityClassName
					.' with id "'.$entity->getId().'": requirements not met');
			}
		}
		if (!$allPassed)
			return $this->returnFailure(HTTPError::FORBIDDEN);

		$this->entities->save();

		if (is_array($ids)) {
			$this->templateName = $this->templateNameMultiple;
			$this->smarty->assign('entities', $this->entities);
		} else {
			$this->templateName = $this->templateNameSingle;
			$this->smarty->assign('entity', $this->entities->get(0));
		}
		return $this->returnSuccess();
	}
}