<?php

/**
 * BaseListAction
 *
 * Meta clase para obtener una coleccion (listado) de objetos en la base de datos
 *
 * @package phpMVC
 * @author Modulos Empresarios / Egytca
 * @copyright Copyright (c) 2015, Egytca
 */

class BaseListAction extends BaseAction {

	private $entityClassName;
	protected $smarty;
	protected $ajaxTemplate;
	protected $filters;
	protected $query;
	protected $results;
	protected $pager;
	protected $page;
	protected $perPage;
	protected $notPaginated;

	/**
	 * Constructor
	 *
	 * @param string $entityClassName Nombre de la clase que representa la entidad que se va a listar
	 */
	function __construct($entityClassName) {
		if (empty($entityClassName))
			throw new Exception('$entityClassName must be set');
		$this->entityClassName = $entityClassName;
		if (substr(get_class($this), -7, 1) != 'X')
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)).'X.tpl';
		else
			$this->ajaxTemplate = str_replace('Action', '', get_class($this)) . '.tpl';
	}

	/**
	 * Execute
	 * @see BaseAction::execute()
	 */
	function execute($mapping, $form, &$request, &$response) {

		parent::execute($mapping, $form, $request, $response);

		// Verificamos la existencia de la clase de la que se obtendra la coleccion
		if (class_exists($this->entityClassName)) {

			$this->query = $this->createQuery();

			// Acciones a ejecutar antes de obtener la coleccion de objetos
			// Si el preList devuelve false, se retorna $mapping->findForwardConfig('failure')
			if ($this->preList() === false)
				return $mapping->findForwardConfig('failure');

			if (!$this->notPaginated) {

				if (!isset($this->perPage) || $this->perPage < 1)
					$this->perPage = Common::getRowsPerPage($this->module);

				$this->page = $request->getParameter('page');
				$this->pager = $this->query->createPager($this->filters, $this->page, $this->perPage);

				$this->results = $this->pager->getResults();
				$this->smarty->assign('pager', $this->pager);
			}
			else
				$this->results = $this->query->setFormatter(ModelCriteria::FORMAT_ON_DEMAND)->addFilters($this->filters)->find();

			// Genera info de debug si esta presente
			if (isset($this->debugData)) {
				$this->debugData->set(get_class($this).' filters', $this->filters);
				$this->debugData->set(get_class($this).' main query ('.get_class($this->query).')', $this->query->toString());
			}

			// Acciones a ejecutar despues de obtener la coleccion de objetos
			$this->postList();

			$this->smarty->assign(lcfirst($this->entityClassName) . 'Coll', $this->results);
			return $mapping->findForwardConfig('success');
		}
		else {
			$this->errors->add('Class "'.$this->entityClassName.'" does not exist.');
			$this->smarty->assign('message', 'An error occurred.');
			return $mapping->findForwardConfig('failure');
		}
	}

	protected function createQuery() {
		return BaseQuery::create($this->entityClassName);
	}


/**
 * preList
 * Acciones a ejecutar antes de obtener la coleccion de objetos
 */
	protected function preList() {

		// Procesar los valores del request asociados a filtros
		$this->prepareFilters();

		return true;
	}

/**
 * postList
 * Acciones a ejecutar despues de obtener la coleccion de objetos
 */
	protected function postList() {

		// Informacion para armar los links de paginador
		$this->assignFiltersToSmarty();

		$this->smarty->assign('entityClass', $this->entityClassName);
		$this->smarty->assign('entityColl', $this->results);

		return true;
	}

}