<?php

function modulesAutoload($classname) {

    $modulesPath = 'WEB-INF/classes/modules';

    if (preg_match('/^Egytca\\\Modules\\\(\w+)\\\(\w+)$/', $classname, $matches)) {
        $module = lcfirst($matches[1]);
        $filename = $matches[2];
    } elseif (preg_match("/^[A-Z][a-z0-9]*/", $classname, $matches)) {
    	$module = lcfirst($matches[0]);
        $filename = $classname;
    } else {
        return;
    }

    foreach (['actions', 'classes'] as $type) {
        $fullFilename = "$modulesPath/$module/$type/$filename.php";
    	if (file_exists($fullFilename)) {
    		require_once $fullFilename;
            return;
        }
    }
}

spl_autoload_register('modulesAutoload');