|-*
	params:
		url: request url
		defaultText: text value of the visible input.
		name: "name" attribute of hidden field.
		value: "value" attribute of hidden field.
		(optional) noResultsLabel: text to be displayed when the request returns
			no results.
		(optional) minLength: minimum length before sending requests.
		(optional) other: string of attributes to be included in visible input.

	example:
		|-include file='Autocomplete.tpl'
			url='Main.php?do=commonAutocompleteListX&type=json&object=media&notInIds='|cat:$media->getId()
			defaultText=$media->getMediaRelatedByAliasOf()
			name='params[aliasOf]'
			value=$media->getAliasOf()
			other='size="60"'
			minLength=3
			noResultsLabel='No hay medios que coincidan'
		-|
*-|
|-$goToLink|init:NULL-|
|-$minLength|init:NULL-|
|-$noResultsLabel|init:NULL-|

<div class="ui-front">
	|-counter name='autocomplete' assign='autocompleteId'-|
	<input type="text" id="autocomplete-label-|-$autocompleteId-|" value="|-$defaultText-|" |-$other-|> |-$goToLink-|
	<input type="hidden" id="autocomplete-value-|-$autocompleteId-|" name="|-$name-|" value="|-$value-|">
</div>

<script>
	(function() {
		var autocompleteLabel;

		$("#autocomplete-label-|-$autocompleteId-|").focus(function() {
			autocompleteLabel = $(this).val();
		});

		$("#autocomplete-label-|-$autocompleteId-|").autocomplete({
			source: '|-$url-|',
			change: function(event, ui) {
				// si no se selecciona un item, vuelve al valor inicial
				$(this).val(ui.item ? ui.item.label : autocompleteLabel);
			},
			select: function(event, ui) {

				if (ui.item.value === null) {
					$(this).val(autocompleteLabel); // revert label
					// do not modify hidden value
				} else {
					$(this).val(ui.item.label);
					$("#autocomplete-value-|-$autocompleteId-|").val(ui.item.value);
				}

				return false;
			},
			response: function(event, ui) {
				console.log('response', ui)
				var menu = ui.content;
				if (menu.length === 0)
					menu.push({ label: '|-$noResultsLabel|default:"##common,104,No hay resultados que coincidan##"-|' , value: null })
			},
			minLength: |-$minLength|default:3-|
		});
	})();
</script>