
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- projects_project
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_project`;

CREATE TABLE `projects_project`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Project Id',
    `objectiveId` INTEGER NOT NULL COMMENT 'Objective Id',
    `code` VARCHAR(50) COMMENT 'Project Code',
    `codeAux` VARCHAR(50) COMMENT 'Project Code Auxiliary code',
    `name` VARCHAR(255) NOT NULL COMMENT 'Project Name',
    `description` TEXT COMMENT 'Project Description',
    `impact` TEXT COMMENT 'Project Impact',
    `uniqueGoal` TEXT COMMENT 'Project Unique Goal',
    `goalExpirationDate` DATE COMMENT 'Project Goal Expiration Date',
    `date` DATETIME COMMENT 'Project Creation Date',
    `budgetPlanned` FLOAT COMMENT 'Project Budget (Presupuesto Planificado)',
    `budget` FLOAT COMMENT 'Project Budget (Presupuesto)',
    `exchangeRate` FLOAT COMMENT 'Exchange Rate',
    `visibility` INTEGER COMMENT 'Visibility',
    `coordinateNeed` TEXT COMMENT 'Project Coordinate Need',
    `frequency` TEXT COMMENT 'Project Frequency',
    `finished` TINYINT(1) COMMENT 'is Project Finished?',
    `notes` TEXT COMMENT 'Project Notes',
    `postalCode` VARCHAR(8) COMMENT 'Project Postal Code',
    `uniqueGoalNumeric` INTEGER COMMENT 'Project Unique Goal Numeric',
    `goalProgress` INTEGER COMMENT 'Project Goal Progress',
    `latitude` FLOAT COMMENT 'latitud del proyecto',
    `longitude` FLOAT COMMENT 'longitud del proyecto',
    `oldId` INTEGER COMMENT 'Old Id',
    `regionId` INTEGER COMMENT 'Region Id',
    `oldRegionId` INTEGER COMMENT 'Old Region Id',
    `lastModification` DATETIME COMMENT 'Ultima modificacion Date',
    `address` VARCHAR(255) COMMENT 'Direccion del proyecto',
    `street` VARCHAR(100) COMMENT 'Nombre de la calle',
    `number` INTEGER COMMENT 'Numero de la calle',
    `priority` INTEGER COMMENT 'Prioridad Id',
    `modifications` INTEGER COMMENT 'Cantidad de modificaciones',
    `plannedStart` DATE COMMENT 'Project planned start',
    `plannedEnd` DATE COMMENT 'Project planned End',
    `realStart` DATE COMMENT 'Project real start',
    `realEnd` DATE COMMENT 'Project real end',
    `cancelled` TINYINT(1) COMMENT 'is project cancelled?',
    `isConstruction` TINYINT(1) COMMENT 'is a construction?',
    `relevance` VARCHAR(255) COMMENT 'Importancia',
    `userId` INTEGER COMMENT 'User Id ',
    `order` INTEGER DEFAULT 0 NOT NULL COMMENT 'Orden',
    `weight` DECIMAL DEFAULT 0 NOT NULL COMMENT 'Peso',
    `updated` DATETIME COMMENT 'Updated',
    `responsibleCode` INTEGER NOT NULL COMMENT 'Codigo del responsable',
    `indicatorId` INTEGER COMMENT 'Id del indicador del grafico de desembolsos',
    `primarySource` VARCHAR(24) COMMENT 'Fuente principal de financiamiento',
    `additionalSource` VARCHAR(24) COMMENT 'Fuente adicional de financiamiento',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `subproject` VARCHAR(255) COMMENT 'is subproject?',
    `ongoing` TEXT COMMENT 'Nombre del programa en desarrollo',
    `relatedAreas` TEXT COMMENT 'Areas relacionadas',
    `goal` VARCHAR(255) COMMENT 'Meta producto',
    `legal` TEXT COMMENT 'Marco legal',
    `execResp` VARCHAR(255) COMMENT 'Responsable',
    `execTenure` VARCHAR(255) COMMENT 'Cargo',
    `execDependency` VARCHAR(255) COMMENT 'Dependencia',
    `execContact` VARCHAR(255) COMMENT 'Contacto',
    `subsecretary` VARCHAR(255) COMMENT 'Subsecretaria',
    `budgetRequested` FLOAT COMMENT 'Presupuesto solicitado',
    `budgetSanctioned` FLOAT COMMENT 'Presupuesto sancionado',
    `belgrano` TINYINT(1) COMMENT 'si es Plan Belgrano?',
    `clasification` INTEGER DEFAULT 0 COMMENT 'Clasification',
    `press` TINYINT(1) COMMENT 'Interes prensa?',
    `priorityArea` INTEGER DEFAULT 0 COMMENT 'prioridad del area',
    `beneficiario` TEXT COMMENT 'Grupo / Sector se va a beneficiar con este proyecto',
    `requireContractor` TINYINT(1) COMMENT 'Requiere Contratacion?',
    `purchaseType` INTEGER COMMENT 'Tipo de compra',
    `constructionType` INTEGER COMMENT 'Tipo de Obra',
    `requireExraResources` TINYINT(1) COMMENT 'Requiere personal extra?',
    `implementationPartner` TEXT COMMENT 'Socios en la implementación',
    `riskFactors` TEXT COMMENT 'Factores de riesgo',
    `ownFinance` INTEGER COMMENT 'Financiamiento propio?',
    `provinceFinance` INTEGER COMMENT 'Financiamiento Provincial?',
    `nationFinance` INTEGER COMMENT 'Financiamiento Nacional?',
    `otherFinance` INTEGER COMMENT 'Otro Financiamiento?',
    `financeDetail` VARCHAR(255) COMMENT 'Detalle de financiamiento',
    `financeProgram` VARCHAR(255) COMMENT 'Programa destino financiamiento',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `projects_project_FI_1` (`objectiveId`),
    INDEX `projects_project_FI_2` (`responsibleCode`),
    INDEX `projects_project_FI_3` (`indicatorId`),
    INDEX `projects_project_FI_4` (`userId`),
    CONSTRAINT `projects_project_FK_1`
        FOREIGN KEY (`objectiveId`)
        REFERENCES `objectives_objective` (`id`),
    CONSTRAINT `projects_project_FK_2`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`code`),
    CONSTRAINT `projects_project_FK_3`
        FOREIGN KEY (`indicatorId`)
        REFERENCES `indicators_indicator` (`id`),
    CONSTRAINT `projects_project_FK_4`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Project';

-- ---------------------------------------------------------------------
-- projects_region
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_region`;

CREATE TABLE `projects_region`
(
    `regionId` INTEGER NOT NULL,
    `projectId` INTEGER NOT NULL,
    PRIMARY KEY (`regionId`,`projectId`),
    INDEX `projects_region_FI_2` (`projectId`),
    CONSTRAINT `projects_region_FK_1`
        FOREIGN KEY (`regionId`)
        REFERENCES `regions_region` (`id`),
    CONSTRAINT `projects_region_FK_2`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`)
) ENGINE=MyISAM COMMENT='Asociacion entre Barrios y Proyectos';

-- ---------------------------------------------------------------------
-- projects_milestone
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_milestone`;

CREATE TABLE `projects_milestone`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Milestone Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `name` TEXT NOT NULL COMMENT 'Milestone Name',
    `date` DATE COMMENT 'Milestone Creation Date',
    `expirationDate` DATE COMMENT 'Milestone Expiration Date',
    `completed` TINYINT(1) COMMENT 'is Milestone Completed?',
    `notes` TEXT COMMENT 'Project Notes',
    PRIMARY KEY (`id`),
    INDEX `projects_milestone_FI_1` (`projectId`),
    CONSTRAINT `projects_milestone_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`)
) ENGINE=MyISAM COMMENT='Milestone';

-- ---------------------------------------------------------------------
-- projects_indicator
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_indicator`;

CREATE TABLE `projects_indicator`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Indicator Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `communeId` INTEGER COMMENT 'Project Id',
    `regionId` INTEGER COMMENT 'Project Id',
    `name` VARCHAR(100) NOT NULL COMMENT 'Indicator Name',
    `expirationDate` DATE COMMENT 'Indicator Expiration Date',
    `measureUnitId` INTEGER COMMENT 'Measure Unit',
    `notes` TEXT COMMENT 'Project Notes',
    `started` TINYINT(1) COMMENT 'is Indicator Started?',
    `startDate` DATE COMMENT 'Indicator Start Date',
    `endDate` DATE COMMENT 'Indicator End Date',
    `actualProgress` INTEGER COMMENT 'Indicator Actual Progress',
    PRIMARY KEY (`id`),
    INDEX `projects_indicator_FI_1` (`projectId`),
    INDEX `projects_indicator_FI_2` (`regionId`),
    CONSTRAINT `projects_indicator_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`),
    CONSTRAINT `projects_indicator_FK_2`
        FOREIGN KEY (`regionId`)
        REFERENCES `regions_region` (`id`)
) ENGINE=MyISAM COMMENT='Indicator';

-- ---------------------------------------------------------------------
-- projects_activity
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_activity`;

CREATE TABLE `projects_activity`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Activity Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `name` TEXT NOT NULL COMMENT 'Activity Name',
    `description` TEXT COMMENT 'Activity Description',
    `date` DATE COMMENT 'Activity Creation Date',
    `expirationDate` DATE COMMENT 'Activity Expiration Date',
    `completed` TINYINT(1) COMMENT 'is Activity Completed?',
    `updated` DATETIME COMMENT 'Updated',
    `uniqueGoalNumeric` INTEGER COMMENT 'Project Unique Goal Numeric',
    `goalProgress` INTEGER COMMENT 'Activity Goal Progress',
    `notes` TEXT COMMENT 'Activity Notes',
    `userId` INTEGER COMMENT 'User Id ',
    `lastModification` DATETIME COMMENT 'Ultima modificacion Date',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `plannedStart` DATE COMMENT 'Activity planned start',
    `plannedEnd` DATE COMMENT 'Activity planned End',
    `realStart` DATE COMMENT 'Activity real start',
    `realEnd` DATE COMMENT 'Activity real end',
    `cancelled` TINYINT(1) COMMENT 'is activity cancelled?',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `press` TINYINT(1) DEFAULT 0 COMMENT 'Interes prensa?',
    `budget` FLOAT COMMENT 'Project Activity Budget (Presupuesto)',
    `responsibleCode` INTEGER COMMENT 'Codigo del responsable',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `projects_activity_FI_1` (`projectId`),
    INDEX `projects_activity_FI_2` (`userId`),
    INDEX `projects_activity_FI_3` (`responsibleCode`),
    CONSTRAINT `projects_activity_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`),
    CONSTRAINT `projects_activity_FK_2`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`),
    CONSTRAINT `projects_activity_FK_3`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM COMMENT='Activity';

-- ---------------------------------------------------------------------
-- projects_document
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_document`;

CREATE TABLE `projects_document`
(
    `project_id` INTEGER NOT NULL,
    `document_id` INTEGER NOT NULL,
    PRIMARY KEY (`project_id`,`document_id`),
    INDEX `projects_document_FI_2` (`document_id`),
    CONSTRAINT `projects_document_FK_1`
        FOREIGN KEY (`project_id`)
        REFERENCES `projects_project` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `projects_document_FK_2`
        FOREIGN KEY (`document_id`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM;

-- ---------------------------------------------------------------------
-- projects_activityDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_activityDocument`;

CREATE TABLE `projects_activityDocument`
(
    `activity_id` INTEGER NOT NULL,
    `document_id` INTEGER NOT NULL,
    PRIMARY KEY (`activity_id`,`document_id`),
    INDEX `projects_activityDocument_FI_2` (`document_id`),
    CONSTRAINT `projects_activityDocument_FK_1`
        FOREIGN KEY (`activity_id`)
        REFERENCES `projects_activity` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `projects_activityDocument_FK_2`
        FOREIGN KEY (`document_id`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM;

-- ---------------------------------------------------------------------
-- projects_contractor
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_contractor`;

CREATE TABLE `projects_contractor`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `project_id` INTEGER,
    `contractor_id` INTEGER,
    `type` INTEGER NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `projects_contractor_U_1` (`project_id`, `contractor_id`, `type`),
    INDEX `projects_contractor_FI_2` (`contractor_id`),
    CONSTRAINT `projects_contractor_FK_1`
        FOREIGN KEY (`project_id`)
        REFERENCES `projects_project` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `projects_contractor_FK_2`
        FOREIGN KEY (`contractor_id`)
        REFERENCES `panel_contractor` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- projects_projectLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_projectLog`;

CREATE TABLE `projects_projectLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Project Log Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `objectiveId` INTEGER NOT NULL COMMENT 'Objective Id',
    `code` VARCHAR(50) COMMENT 'Project Code',
    `codeAux` VARCHAR(50) COMMENT 'Project Code Auxiliary code',
    `name` VARCHAR(255) NOT NULL COMMENT 'Project Name',
    `description` TEXT COMMENT 'Project Description',
    `impact` TEXT COMMENT 'Project Impact',
    `uniqueGoal` TEXT COMMENT 'Project Unique Goal',
    `goalExpirationDate` DATE COMMENT 'Project Goal Expiration Date',
    `date` DATETIME COMMENT 'Project Creation Date',
    `budget` FLOAT COMMENT 'Project Budget (Presupuesto)',
    `budgetPlanned` FLOAT COMMENT 'Project Budget (Presupuesto Planificado)',
    `exchangeRate` FLOAT COMMENT 'Exchange Rate',
    `visibility` INTEGER COMMENT 'Visibility',
    `coordinateNeed` TEXT COMMENT 'Project Coordinate Need',
    `frequency` TEXT COMMENT 'Project Frequency',
    `finished` TINYINT(1) COMMENT 'is Project Finished?',
    `notes` TEXT COMMENT 'Project Notes',
    `postalCode` VARCHAR(8) COMMENT 'Project Postal Code',
    `uniqueGoalNumeric` INTEGER COMMENT 'Project Unique Goal Numeric',
    `goalProgress` INTEGER COMMENT 'Project Goal Progress',
    `latitude` FLOAT COMMENT 'latitud del proyecto',
    `longitude` FLOAT COMMENT 'longitud del proyecto',
    `oldId` INTEGER COMMENT 'Old Id',
    `regionId` INTEGER COMMENT 'Region Id',
    `oldRegionId` INTEGER COMMENT 'Old Region Id',
    `lastModification` DATETIME COMMENT 'Ultima modificacion Date',
    `address` VARCHAR(255) COMMENT 'Direccion del proyecto',
    `priority` INTEGER COMMENT 'Prioridad Id',
    `modifications` INTEGER COMMENT 'Cantidad de modificaciones',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `plannedStart` DATE COMMENT 'Project planned start',
    `plannedEnd` DATE COMMENT 'Project planned End',
    `realStart` DATE COMMENT 'Project real start',
    `realEnd` DATE COMMENT 'Project real end',
    `cancelled` TINYINT(1) COMMENT 'is project cancelled?',
    `isConstruction` TINYINT(1) COMMENT 'is a construction?',
    `relevance` VARCHAR(255) COMMENT 'Importancia',
    `userId` INTEGER COMMENT 'User Id ',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `responsibleCode` INTEGER COMMENT 'Codigo del responsable',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `subproject` VARCHAR(255) COMMENT 'is subproject?',
    `ongoing` TEXT COMMENT 'Nombre del programa en desarrollo',
    `relatedAreas` TEXT COMMENT 'Areas relacionadas',
    `goal` VARCHAR(255) COMMENT 'Meta producto',
    `legal` TEXT COMMENT 'Marco legal',
    `press` TINYINT(1) COMMENT 'Interes prensa?',
    `execResp` VARCHAR(255) COMMENT 'Responsable',
    `execTenure` VARCHAR(255) COMMENT 'Cargo',
    `execDependency` VARCHAR(255) COMMENT 'Dependencia',
    `execContact` VARCHAR(255) COMMENT 'Contacto',
    `subsecretary` VARCHAR(255) COMMENT 'Subsecretaria',
    `budgetRequested` FLOAT COMMENT 'Presupuesto solicitado',
    `budgetSanctioned` FLOAT COMMENT 'Presupuesto sancionado',
    `beneficiario` TEXT COMMENT 'Grupo / Sector se va a beneficiar con este proyecto',
    `requireContractor` TINYINT(1) COMMENT 'Requiere Contratacion?',
    `purchaseType` INTEGER COMMENT 'Tipo de compra',
    `constructionType` INTEGER COMMENT 'Tipo de Obra',
    `requireExraResources` TINYINT(1) COMMENT 'Requiere personal extra?',
    `implementationPartner` TEXT COMMENT 'Socios en la implementación',
    `riskFactors` TEXT COMMENT 'Factores de riesgo',
    `ownFinance` TINYINT(1) COMMENT 'Financiamiento propio?',
    `provinceFinance` TINYINT(1) COMMENT 'Financiamiento Provincial?',
    `nationFinance` TINYINT(1) COMMENT 'Financiamiento Nacional?',
    `otherFinance` TINYINT(1) COMMENT 'Otro Financiamiento?',
    `financeDetail` VARCHAR(255) COMMENT 'Detalle de financiamiento',
    `financeProgram` VARCHAR(255) COMMENT 'Programa destino financiamiento',
    PRIMARY KEY (`id`),
    INDEX `projects_projectLog_FI_1` (`projectId`),
    INDEX `projects_projectLog_FI_2` (`objectiveId`),
    INDEX `projects_projectLog_FI_3` (`userId`),
    INDEX `projects_projectLog_FI_4` (`responsibleCode`),
    CONSTRAINT `projects_projectLog_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`),
    CONSTRAINT `projects_projectLog_FK_2`
        FOREIGN KEY (`objectiveId`)
        REFERENCES `objectives_objective` (`id`),
    CONSTRAINT `projects_projectLog_FK_3`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`),
    CONSTRAINT `projects_projectLog_FK_4`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM COMMENT='ProjectLog';

-- ---------------------------------------------------------------------
-- projects_milestoneLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_milestoneLog`;

CREATE TABLE `projects_milestoneLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Milestone Id',
    `milestoneId` INTEGER NOT NULL COMMENT 'Milestone Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `name` TEXT NOT NULL COMMENT 'Milestone Name',
    `date` DATE COMMENT 'Milestone Creation Date',
    `expirationDate` DATE COMMENT 'Milestone Expiration Date',
    `completed` TINYINT(1) COMMENT 'is Milestone Completed?',
    `notes` TEXT COMMENT 'Project Notes',
    `userId` INTEGER COMMENT 'User Id ',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `lastModification` DATETIME COMMENT 'Ultima modificacion Date',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    PRIMARY KEY (`id`),
    INDEX `projects_milestoneLog_FI_1` (`projectId`),
    INDEX `projects_milestoneLog_FI_2` (`milestoneId`),
    INDEX `projects_milestoneLog_FI_3` (`userId`),
    CONSTRAINT `projects_milestoneLog_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`),
    CONSTRAINT `projects_milestoneLog_FK_2`
        FOREIGN KEY (`milestoneId`)
        REFERENCES `projects_milestone` (`id`),
    CONSTRAINT `projects_milestoneLog_FK_3`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
) ENGINE=MyISAM COMMENT='Milestone Log';

-- ---------------------------------------------------------------------
-- projects_activityLog
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `projects_activityLog`;

CREATE TABLE `projects_activityLog`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Activity Id',
    `activityId` INTEGER NOT NULL COMMENT 'Activity Id',
    `projectId` INTEGER NOT NULL COMMENT 'Project Id',
    `name` TEXT NOT NULL COMMENT 'Activity Name',
    `description` TEXT COMMENT 'Activity Description',
    `date` DATE COMMENT 'Activity Creation Date',
    `expirationDate` DATE COMMENT 'Activity Expiration Date',
    `completed` TINYINT(1) COMMENT 'is Activity Completed?',
    `uniqueGoalNumeric` INTEGER COMMENT 'Project Unique Goal Numeric',
    `goalProgress` INTEGER COMMENT 'Activity Goal Progress',
    `notes` TEXT COMMENT 'Activity Notes',
    `userId` INTEGER COMMENT 'User Id ',
    `userByAffiliatesId` INTEGER COMMENT 'UserByAffiliates Id',
    `updated` DATETIME COMMENT 'Updated',
    `lastModification` DATETIME COMMENT 'Ultima modificacion Date',
    `changes` INTEGER COMMENT 'Cantidad de modificaciones',
    `plannedStart` DATE COMMENT 'Activity planned start',
    `plannedEnd` DATE COMMENT 'Activity planned End',
    `realStart` DATE COMMENT 'Activity real start',
    `realEnd` DATE COMMENT 'Activity real end',
    `cancelled` TINYINT(1) COMMENT 'is activity cancelled?',
    `startingYear` INTEGER COMMENT 'Starting year',
    `endingYear` INTEGER COMMENT 'Ending year',
    `press` TINYINT(1) COMMENT 'Interes prensa?',
    `budget` FLOAT COMMENT 'Project Activity Budget (Presupuesto)',
    `responsibleCode` INTEGER COMMENT 'Codigo del responsable',
    PRIMARY KEY (`id`),
    INDEX `projects_activityLog_FI_1` (`projectId`),
    INDEX `projects_activityLog_FI_2` (`activityId`),
    INDEX `projects_activityLog_FI_3` (`userId`),
    INDEX `projects_activityLog_FI_4` (`responsibleCode`),
    CONSTRAINT `projects_activityLog_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`),
    CONSTRAINT `projects_activityLog_FK_2`
        FOREIGN KEY (`activityId`)
        REFERENCES `projects_activity` (`id`),
    CONSTRAINT `projects_activityLog_FK_3`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`),
    CONSTRAINT `projects_activityLog_FK_4`
        FOREIGN KEY (`responsibleCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM COMMENT='Activity Log';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
