
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- panel_guarantee
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_guarantee`;

CREATE TABLE `panel_guarantee`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de la garantia',
    `code` CHAR(80) COMMENT 'Numero o codigo',
    `type` INTEGER COMMENT 'Tipo de garantia',
    `projectId` INTEGER COMMENT 'Id del proyecto',
    `contractorId` INTEGER COMMENT 'Id del contratista',
    `issuer` CHAR(125) NOT NULL COMMENT 'Emisor',
    `currency` INTEGER COMMENT 'Moneda',
    `ammount` DECIMAL(12,2) COMMENT 'Monto',
    `issueDate` DATE NOT NULL COMMENT 'Fecha emision',
    `expirationType` INTEGER COMMENT 'Tipo de vencimiento',
    `expirationDate` DATE COMMENT 'Fecha de vencimiento',
    `expirationTerms` CHAR(80) COMMENT 'Terminos de vencimiento',
    `returned` BOOL COMMENT 'Garantia devuelta',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `panel_guarantee_FI_1` (`projectId`),
    INDEX `panel_guarantee_FI_2` (`contractorId`),
    CONSTRAINT `panel_guarantee_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`)
        ON DELETE SET NULL,
    CONSTRAINT `panel_guarantee_FK_2`
        FOREIGN KEY (`contractorId`)
        REFERENCES `panel_contractor` (`id`)
        ON DELETE SET NULL
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Garantias';

-- ---------------------------------------------------------------------
-- panel_guaranteeDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_guaranteeDocument`;

CREATE TABLE `panel_guaranteeDocument`
(
    `guaranteeId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`guaranteeId`,`documentId`),
    INDEX `panel_guaranteeDocument_FI_2` (`documentId`),
    CONSTRAINT `panel_guaranteeDocument_FK_1`
        FOREIGN KEY (`guaranteeId`)
        REFERENCES `panel_guarantee` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_guaranteeDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_contractor
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_contractor`;

CREATE TABLE `panel_contractor`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del Contratista',
    `name` CHAR(255) COMMENT 'Nombre',
    `cuit` CHAR(11) COMMENT 'Nombre',
    `address` CHAR(255) COMMENT 'Direccion',
    `phone` CHAR(120) COMMENT 'Direccion',
    `contact` CHAR(120) COMMENT 'Persona Contacto',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Contratistas';

-- ---------------------------------------------------------------------
-- panel_contractorCategory
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_contractorCategory`;

CREATE TABLE `panel_contractorCategory`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL COMMENT 'Name',
    `order` INTEGER(4) COMMENT 'Orden',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `scope` INTEGER,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Categorias de Contractistas';

-- ---------------------------------------------------------------------
-- panel_contractorCategoryRelation
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_contractorCategoryRelation`;

CREATE TABLE `panel_contractorCategoryRelation`
(
    `contractorId` INTEGER(5) NOT NULL COMMENT 'Id Contractor',
    `categoryId` INTEGER(5) NOT NULL COMMENT 'Category Id',
    PRIMARY KEY (`contractorId`,`categoryId`),
    INDEX `panel_contractorCategoryRelation_FI_2` (`categoryId`),
    CONSTRAINT `panel_contractorCategoryRelation_FK_1`
        FOREIGN KEY (`contractorId`)
        REFERENCES `panel_contractor` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_contractorCategoryRelation_FK_2`
        FOREIGN KEY (`categoryId`)
        REFERENCES `panel_contractorCategory` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Relacion Contractistas y Categorias';

-- ---------------------------------------------------------------------
-- panel_administrativeAct
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_administrativeAct`;

CREATE TABLE `panel_administrativeAct`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del Acto Administrativo',
    `type` INTEGER COMMENT 'Tipo de acto',
    `object` CHAR(120) COMMENT 'Objeto del Acto',
    `actDate` DATE NOT NULL COMMENT 'Fecha del acto',
    `description` TEXT COMMENT 'Descripcion del Acto',
    `projectId` INTEGER COMMENT 'Id del proyecto',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `panel_administrativeAct_FI_1` (`projectId`),
    CONSTRAINT `panel_administrativeAct_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`)
        ON DELETE SET NULL
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Actos Administrativos';

-- ---------------------------------------------------------------------
-- panel_adminActParticipant
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_adminActParticipant`;

CREATE TABLE `panel_adminActParticipant`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del Participante del Acto Administrativo',
    `adminActId` INTEGER NOT NULL COMMENT 'Id del Acto Administrativo',
    `objectType` VARCHAR(50) NOT NULL COMMENT 'Tipo de participante',
    `objectId` INTEGER NOT NULL COMMENT 'Id del participante',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `panel_adminActParticipant_U_1` (`adminActId`, `objectType`, `objectId`),
    CONSTRAINT `panel_adminActParticipant_FK_1`
        FOREIGN KEY (`adminActId`)
        REFERENCES `panel_administrativeAct` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de participantes en actos administrativos';

-- ---------------------------------------------------------------------
-- panel_administrativeActDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_administrativeActDocument`;

CREATE TABLE `panel_administrativeActDocument`
(
    `administrativeActId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`administrativeActId`,`documentId`),
    INDEX `panel_administrativeActDocument_FI_2` (`documentId`),
    CONSTRAINT `panel_administrativeActDocument_FK_1`
        FOREIGN KEY (`administrativeActId`)
        REFERENCES `panel_administrativeAct` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_administrativeActDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_mission
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_mission`;

CREATE TABLE `panel_mission`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de la Mision',
    `type` INTEGER COMMENT 'Tipo de Mision',
    `startDate` DATE NOT NULL COMMENT 'Fecha de la mision',
    `finishDate` DATE NOT NULL COMMENT 'Fecha de la mision',
    `projectId` INTEGER COMMENT 'Prestamo asociado',
    `description` TEXT COMMENT 'Descripcion de la Mision',
    `responsible` CHAR(120) COMMENT 'Persona Responsable de la mision',
    `userId` INTEGER COMMENT 'Usuario que creo la mision',
    `updaterUserId` INTEGER COMMENT 'Usuario que guardo la mision',
    `deleted_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `panel_mission_FI_1` (`projectId`),
    INDEX `panel_mission_FI_2` (`userId`),
    INDEX `panel_mission_FI_3` (`updaterUserId`),
    CONSTRAINT `panel_mission_FK_1`
        FOREIGN KEY (`projectId`)
        REFERENCES `projects_project` (`id`)
        ON DELETE SET NULL,
    CONSTRAINT `panel_mission_FK_2`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
        ON DELETE SET NULL,
    CONSTRAINT `panel_mission_FK_3`
        FOREIGN KEY (`updaterUserId`)
        REFERENCES `users_user` (`id`)
        ON DELETE SET NULL
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Misiones';

-- ---------------------------------------------------------------------
-- panel_missionParticipant
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_missionParticipant`;

CREATE TABLE `panel_missionParticipant`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion del Participante de la Mision',
    `missionId` INTEGER NOT NULL COMMENT 'Id de la mision',
    `objectType` VARCHAR(50) NOT NULL COMMENT 'Tipo de participante',
    `objectId` INTEGER NOT NULL COMMENT 'Id del participante',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `panel_missionParticipant_U_1` (`missionId`, `objectType`, `objectId`),
    CONSTRAINT `panel_missionParticipant_FK_1`
        FOREIGN KEY (`missionId`)
        REFERENCES `panel_mission` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de participantes en misiones';

-- ---------------------------------------------------------------------
-- panel_missionCommitment
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_missionCommitment`;

CREATE TABLE `panel_missionCommitment`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT COMMENT 'Identificacion de Compromiso de la Mision',
    `missionId` INTEGER COMMENT 'Id de la Mision',
    `participantId` INTEGER COMMENT 'Id del participante',
    `responsible` CHAR(255) COMMENT 'Responsables',
    `commitment` TEXT COMMENT 'Descripcion del Compromiso',
    `achieved` BOOL COMMENT 'Logrado',
    `date` DATE NOT NULL COMMENT 'Fecha del compromiso',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `panel_missionCommitment_FI_1` (`missionId`),
    INDEX `panel_missionCommitment_FI_2` (`participantId`),
    CONSTRAINT `panel_missionCommitment_FK_1`
        FOREIGN KEY (`missionId`)
        REFERENCES `panel_mission` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_missionCommitment_FK_2`
        FOREIGN KEY (`participantId`)
        REFERENCES `panel_missionParticipant` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Compromisos de Misiones';

-- ---------------------------------------------------------------------
-- panel_missionDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_missionDocument`;

CREATE TABLE `panel_missionDocument`
(
    `missionId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`missionId`,`documentId`),
    INDEX `panel_missionDocument_FI_2` (`documentId`),
    CONSTRAINT `panel_missionDocument_FK_1`
        FOREIGN KEY (`missionId`)
        REFERENCES `panel_mission` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_missionDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_reportSection
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_reportSection`;

CREATE TABLE `panel_reportSection`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `code` INTEGER NOT NULL COMMENT 'Codigo de la seccion, usado para poder generar nuevas versiones de la misma seccion, el cual mantiene el code pero genera una nueva version',
    `name` VARCHAR(100) NOT NULL COMMENT 'Name',
    `versionId` INTEGER NOT NULL COMMENT 'Version',
    `type` INTEGER(5) NOT NULL COMMENT 'Tipo de seccion del reporte',
    `content` MEDIUMTEXT COMMENT 'Content',
    `enviromentalSupervision` MEDIUMTEXT COMMENT 'Supervision Ambiantal',
    `objectType` VARCHAR(50) COMMENT 'Tipo de entidad relacionada.',
    `objectId` INTEGER(5) COMMENT 'Id de la entidad relacionada.',
    `completed` BOOL COMMENT 'Completada',
    `updated` DATETIME COMMENT 'Updated',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `panel_reportSection_U_1` (`code`, `versionId`),
    INDEX `panel_reportSection_FI_1` (`versionId`),
    CONSTRAINT `panel_reportSection_FK_1`
        FOREIGN KEY (`versionId`)
        REFERENCES `panel_reportVersion` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Seccion de reporte al BM';

-- ---------------------------------------------------------------------
-- panel_reportVersion
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_reportVersion`;

CREATE TABLE `panel_reportVersion`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `dateFrom` DATETIME COMMENT 'Fecha de inicio de validez del reporte',
    `dateTo` DATETIME COMMENT 'Fecha de fin de validez del reporte',
    `name` VARCHAR(255) COMMENT 'Activity Name',
    `description` TEXT COMMENT 'Descripcion de la version',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Versiones de reportes';

-- ---------------------------------------------------------------------
-- panel_reportDocument
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_reportDocument`;

CREATE TABLE `panel_reportDocument`
(
    `reportSectionId` INTEGER NOT NULL,
    `documentId` INTEGER NOT NULL,
    PRIMARY KEY (`reportSectionId`,`documentId`),
    INDEX `panel_reportDocument_FI_2` (`documentId`),
    CONSTRAINT `panel_reportDocument_FK_1`
        FOREIGN KEY (`reportSectionId`)
        REFERENCES `panel_reportSection` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_reportDocument_FK_2`
        FOREIGN KEY (`documentId`)
        REFERENCES `documents_document` (`id`)
        ON DELETE CASCADE
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_notification
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_notification`;

CREATE TABLE `panel_notification`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `objectType` VARCHAR(255) COMMENT 'Clase del objeto al que se envio la notificacion.',
    `objectId` INTEGER COMMENT 'Id del objeto al que se envio la notificacion.',
    `type` INTEGER COMMENT 'Tipo de notificacion.',
    `deliveredOn` DATETIME COMMENT 'Fecha en que fue enviada la notificacion por ultima vez.',
    `mailAddress` VARCHAR(255) COMMENT 'Direccion de mail de notificaciones sin objeto destinatario',
    `mailBody` TEXT COMMENT 'Cuerpo del mensaje enviado.',
    `result` INTEGER COMMENT 'Numero de recipientes aceptados',
    PRIMARY KEY (`id`),
    FULLTEXT INDEX `panel_notification_I_1` (`mailBody`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_resultFrameIndicator
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_resultFrameIndicator`;

CREATE TABLE `panel_resultFrameIndicator`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL COMMENT 'Name',
    `type` INTEGER(5) NOT NULL COMMENT 'Tipo de indicador',
    `useData` BOOL COMMENT 'Utiliza o no datos de indicador',
    `valueType` INTEGER(5) COMMENT 'Tipo de valor del indicador',
    `content` MEDIUMTEXT COMMENT 'Content',
    `objectType` VARCHAR(50) COMMENT 'Tipo de entidad relacionada.',
    `objectId` INTEGER(5) COMMENT 'Id de la entidad relacionada.',
    `frequency` INTEGER(5) NOT NULL COMMENT 'Frecuencia',
    `baseValue` VARCHAR(255) COMMENT 'Valor base',
    `dataRecolectionInstrument` VARCHAR(255) COMMENT 'Instrumento de recoleccion de datos',
    `dataRecolectionResponsible` VARCHAR(255) COMMENT 'Encargado de recolectar datos',
    `updated` DATETIME COMMENT 'Updated',
    `tree_left` INTEGER,
    `tree_right` INTEGER,
    `tree_level` INTEGER,
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Indicador del Marco de Resultados';

-- ---------------------------------------------------------------------
-- panel_resultFrameValue
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_resultFrameValue`;

CREATE TABLE `panel_resultFrameValue`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `resultFrameIndicatorId` INTEGER COMMENT 'Id del indicador del marco de resultados asociado.',
    `year` INTEGER COMMENT 'Year',
    `value` VARCHAR(255) COMMENT 'Content',
    `goal` VARCHAR(255) COMMENT 'Content',
    `updated` DATETIME COMMENT 'Updated',
    `deleted_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `panel_resultFrameValue_FI_1` (`resultFrameIndicatorId`),
    CONSTRAINT `panel_resultFrameValue_FK_1`
        FOREIGN KEY (`resultFrameIndicatorId`)
        REFERENCES `panel_resultFrameIndicator` (`id`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Valores de los indicadores del Marco de Resultados';

-- ---------------------------------------------------------------------
-- panel_alertDigest
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_alertDigest`;

CREATE TABLE `panel_alertDigest`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `positionCode` INTEGER COMMENT 'Codigo del cargo',
    `emails` VARCHAR(200) COMMENT 'Direcciones de email',
    PRIMARY KEY (`id`),
    INDEX `panel_alertDigest_FI_1` (`positionCode`),
    CONSTRAINT `panel_alertDigest_FK_1`
        FOREIGN KEY (`positionCode`)
        REFERENCES `positions_position` (`code`)
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci';

-- ---------------------------------------------------------------------
-- panel_missionUpdate
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `panel_missionUpdate`;

CREATE TABLE `panel_missionUpdate`
(
    `missionId` INTEGER NOT NULL COMMENT 'Identificacion de la Mision',
    `datetime` DATETIME NOT NULL COMMENT 'Fecha de la actualizacion',
    `username` VARCHAR(255) COMMENT 'Nombre de Usuario de la actualizacion',
    `userId` INTEGER COMMENT 'Usuario de la actualizacion',
    PRIMARY KEY (`missionId`),
    INDEX `panel_missionUpdate_FI_2` (`userId`),
    CONSTRAINT `panel_missionUpdate_FK_1`
        FOREIGN KEY (`missionId`)
        REFERENCES `panel_mission` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `panel_missionUpdate_FK_2`
        FOREIGN KEY (`userId`)
        REFERENCES `users_user` (`id`)
        ON DELETE SET NULL
) ENGINE=MyISAM CHARACTER SET='utf8' COLLATE='utf8_general_ci' COMMENT='Base de Actualizaciones de Misiones';

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
