<?php

require_once 'builder/om/PHP5ObjectBuilder.php';

class CustomParentObjectBuilder extends PHP5ObjectBuilder {

	protected function addClassOpen(&$script) {
		parent::addClassOpen($script);
		$parentClass = $this->getParentClass();
		if ($parentClass) {
			$script = preg_replace("/extends BaseObject(\b)/", "extends $parentClass$1", $script);
		}
	}

	protected function getParentClass() {

		$behaviorParentClass = $this->getBehaviorContent('parentClass');
		if ($behaviorParentClass) {
			return $behaviorParentClass;
		}

		$parentClass = $this->getBuildProperty('parentObject');
		if ($parentClass) {
			return $parentClass;
		}

		return null;
	}
}
