<?php

/**
 * UsersSubstituteDoExitAction
 *
 * Salida del supervisor de ejecutar el sistema con otro usuario extendiendo BaseAction
 *
 * @package users
 */

class UsersSubstituteDoExitAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes generar el display
	 */
	protected function exec() {
		parent::exec();

		$requesterUser = Common::getLoggedUser();

		if (!empty($_SESSION['supervisorUser'])) {
			$user = $_SESSION['supervisorUser'];
			if ($user->isSupervisor()) {
				Common::doLog('success', $requesterUser);
				$_SESSION['loginUser'] = $user;
				unset($_SESSION['supervisorUser']);
				$this->smarty->assign('loginUser', $user);
				$this->smarty->assign('SESSION', $_SESSION);
			}
			else {
				unset($_SESSION['loginUser']);
				return false;
			}
		}
		else {
			$this->forwardFailureName = 'failure-notSupervisor';
			return false;
		}
	}
}
