<?php

class UsersListAction extends BaseListAction {

	private $groupIdFilter;
	
	function __construct($entityClassName = 'User') {
		parent::__construct($entityClassName);
	}

	function preList() {
		parent::preList();

		// filtro el listado de usuarios para que solo se pueda ver los del mismo nivel o menores
		$loggedUser = Common::getLoggedUser();
		$this->query->filterByLevel($loggedUser->getLevel(), Criteria::GREATER_EQUAL);
	}

	function postList() {
		parent::postList();
		
		$this->smarty->assign("inactiveUsers", UserPeer::getInactives());

		global $system;
		$licensesLeft = $system["config"]["users"]["licenses"] - UserQuery::create()->find();
		$this->smarty->assign("licensesLeft", $licensesLeft);
	}

}
