<?php

/**
 * SecurityUsersLevelPermissionsAction
 *
 * Edicion de permisoso por nivel de usuario
 *
 * @package security
 */

class SecurityUsersLevelPermissionsAction extends BaseAction {

	/**
	 * Acciones a ejecutar antes de generar el display
	 */
	protected function exec() {
		parent::exec();

		$this->smarty->assign('userLevels', LevelQuery::create()->filterByBitlevel(1, Criteria::GREATER_THAN)->find());

		$this->smarty->assign('userBitLevel', empty($_GET['userBitLevel']) ? 2 : $_GET['userBitLevel']);

		$securityAction = new SecurityAction();
		$moduleNames = Module::getActiveAndPresent();
		$modules = array();

		foreach ($moduleNames as $moduleName) {

			$modules[$moduleName] = array();

			$moduleAccess = SecurityModuleQuery::create()->findOneByModule($moduleName);
			if ($moduleAccess) {
				$modules[$moduleName]['access'] = array(
					'all' => $moduleAccess->hasAllUsersAccess(),
					'bitLevel' => $moduleAccess->getAccess(),
					'noCheckLogin' => $moduleAccess->getNochecklogin()
				);
			}

			$actionNames = ControllerUtils::getActionsForModule($moduleName);
			$accessToActions = $securityAction->getAccessToActions($actionNames);
			foreach ($actionNames as $actionName) {
				if (ControllerUtils::isPairActionWithDo($actionName))
					continue;
				$modules[$moduleName]['actions'][$actionName] = isset($accessToActions[$actionName]) ? $accessToActions[$actionName] : NULL;
			}

		}

		$this->smarty->assign('modules', $modules);

	} // Endexec

}
