<?php

use Egytca\Planning\YearFilter as PlanningYearFilter;
use Egytca\QueryCreate;


/**
 * Skeleton subclass for performing query and update operations on the 'projects_project' table.
 *
 * Project
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.projects.classes
 */
class ProjectQuery extends BaseProjectQuery {

	use PlanningYearFilter;
	use QueryCreate;

	
	private $useLoggedUserGroupAutoFilter = false;
	protected $usePlanningYearsFilter = true;

	
	/**
	 * Inicializa las ocndiciones de filtrado en la construccion del objeto
	 *
	 * @param     string $dbName Nombre de la base de datos
	 * @param     string $modelName Nombre de la clase
	 * @param     string $modelAlias Alias del modelo
	 * @return ProjectQuery
	 */
	public function __construct($dbName = 'application', $modelName = 'Project', $modelAlias = null) {
		
		parent::__construct($dbName, $modelName, $modelAlias);

		$loggedUser = Common::getLoggedUser();
		if ($loggedUser && !$loggedUser->isSupervisor() && ConfigModule::get('projects', 'useFilterByUserGroup')) {
			$this->useLoggedUserGroupAutoFilter = true;
		}
		
		if ($this->usePlanningYearsFilter) {
			$this->filterByPlanningYears();
		}
	}

	function preSelect() {
		if ($this->useLoggedUserGroupAutoFilter) {
			$this->filterByLoggedUserGroup();
		}
	}

	function setLoggedUserGroupAutoFilter($value) {
		$this->useLoggedUserGroupAutoFilter = $value;
		return $this;
	}

	/**
	 * Agrega filtros por nombre, apellido, institucion o sobrenombre
	 *
	 * @param   type string $filterValue texto a buscar
	 * @return condicion de filtrado por texto a buscar
	 */
	public function searchString($filterValue) {
		return $this->filterByName("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterByDescription("%$filterValue%", Criteria::LIKE)
				->_or()
					->filterByAddress("%$filterValue%", Criteria::LIKE);
	}

	/**
	 * Agrega filtros por dependencia
	 *
	 * @return condicion de filtrado por position
	 */
	public function filterByResponsible() {

		if (ConfigModule::get('users', 'useFilterByUserGroup')) {
			$user = Common::getAdminLogged();
			if (!empty($user) && !$user->isAdmin() && !$user->isSupervisor())
				return $this->filterByResponsiblecode(Common::getAdminGroupsIds(), Criteria::IN);
		}
		return $this;
	}

	/**
	 * Agrega filtros por objetivo estrategico
	 *
	 * @param   type integer $strategicObjectiveid id del objetivo estrategico
	 * @param   type criteria $comparison tipo de comparacion
	 * @return condicion de filtrado por Objetivo estrategico
	 */
	public function filterByStrategicObjectiveId($strategicObjectiveid = null, $comparison = null) {

		return $this->join('Objective')
			 ->useQuery('Objective')
    		 	->filterByStrategicObjectiveId($strategicObjectiveid, $comparison)
			 ->endUse();

	}

	/**
	 * Agrega filtros por eje de gestion
	 *
	 * @param   type integer $policyGuidelineId id del eje de gestion
	 * @param   type criteria $comparison tipo de comparacion
	 * @return condicion de filtrado por eje de gestion
	 */
	public function filterByPolicyGuidelineId($policyGuidelineId = null, $comparison = null) {
		$this->join('Objective')
			 ->join('Objective.StrategicObjective')
			 ->useQuery('StrategicObjective')
    		 	->filterByPolicyGuidelineId($policyGuidelineId, $comparison)
			 ->endUse();
		return $this;
	}

	function filterByLoggedUserGroup() {
		return $this->usePositionQuery()
				->filterByLoggedUserGroupWithDesc()
			->endUse();
	}

	/**
	 * Devuelve la criteria para filtrar por fecha de finalización planificada a fin de armar un reporte de alertas de actividades.
	 */
	public function filterByPendingEnd($date, $comparison = null) {
		return $this->filterByFinished(false)
			->filterByPlannedEnd($date, $comparison)
			->filterByRealend(null, Criteria::ISNULL);
	}

	public static function getRegionCandidates($id) {
		$project = ProjectQuery::create()->findOneById($id);
		if (!empty($project))
			$objectiveId = $project->getObjectiveId();
		else
			return NULL;
		$regionObjectives = ObjectiveRegionQuery::create()
												->filterByObjectiveId($objectiveId)
												->find();

		if (!empty($regionObjectives)) {//El objetivo tiene region asociada, solo permito iguales o descendientes

			$criteria = new Criteria();

			foreach ($regionObjectives as $regionObjective) {
				$region = RegionPeer::get($regionObjective->getRegionId());
					if (empty($criterionRegion))
						$criterionRegion = $criteria->getNewCriterion(RegionPeer::ID,$region->getId());
					else
						$criterionRegion->addOr($criteria->getNewCriterion(RegionPeer::ID,$region->getId()));
				$descendants = $region->getDescendants();
				foreach ($descendants as $descendant){
					if (empty($criterionRegion))
						$criterionRegion = $criteria->getNewCriterion(RegionPeer::ID,$descendant->getId());
					else
						$criterionRegion->addOr($criteria->getNewCriterion(RegionPeer::ID,$descendant->getId()));
				}
				if (!empty($criterionRegion)){
					$criteria->addAnd($criterionRegion);
				}
			}
			$not_in_query = RegionPeer::ID . ' NOT IN (SELECT ' . ProjectRegionPeer::REGIONID . '
											FROM ' . ProjectRegionPeer::TABLE_NAME . '
											WHERE ' . ProjectRegionPeer::PROJECTID . ' = ' . $id . ')';
			$criteria->addAnd(RegionPeer::ID, $not_in_query, Criteria::CUSTOM);
			$regions = RegionPeer::doSelect($criteria);

			}
			else { //El objetivo no tiene region asociada

			$criteria = new Criteria();
			$not_in_query = RegionPeer::ID . ' NOT IN (SELECT ' . ProjectRegionPeer::REGIONID . '
											FROM ' . ProjectRegionPeer::TABLE_NAME . '
											WHERE ' . ProjectRegionPeer::PROJECTID . ' = ' . $id . ')';
			$criteria->add(RegionPeer::ID, $not_in_query, Criteria::CUSTOM);
			$regions = RegionPeer::doSelect($criteria);
			}
		return $regions;
	}

	function filterByDateFrom($plannedStart) {
		return $this->filterByPlannedStart($plannedStart, CRITERIA::GREATER_EQUAL);		
	}

	function filterByDateTo($plannedStart) {
		return $this->filterByPlannedStart($plannedStart, CRITERIA::LESS_EQUAL);		
	}

	/**
	 * Filtar por estado.
	 * @param array status filtros por estado.
	 * $status['delayed'] == 1 filtar por retrasados.
	 * $status['ended'] == 1 filtra por finalizados
	 * $status['working'] == 1 filtra por en ejecucion
	 *
	 * Los filtros se combinan con OR ya que se puede filtrar por mas de uno a la ves.
	 */
	function filterByStatus($status) {

		$criterion;

		if (array_key_exists('ended', $status)) {

			if ($status['ended']) {
				if (empty($criterion))
					$criterion = new Criterion($this, ProjectPeer::FINISHED,1,Criteria::EQUAL);
				else
					$criterion->addOr(new Criterion($this, ProjectPeer::FINISHED,1,Criteria::EQUAL));	
			}
		}

		if (array_key_exists('ontime', $status)) {

			if ($status['ontime']) {

				$criterionOntime = $this->criterionForStatusColor('green');

				if (empty($criterion))
					$criterion = $criterionOntime;
				else
					$criterion->addOr($criterionOntime);
			}
		}

		if (array_key_exists('delayed', $status)) {

			if ($status['delayed']) {

				$criterionDelayed = $this->criterionForStatusColor('yellow')
					->addOr($this->criterionForStatusColor('red'));

				if (empty($criterion))
					$criterion = $criterionDelayed;
				else
					$criterion->addOr($criterionDelayed);
			}
		}

		$this->add($criterion);

		return $this;
	}

	function criterionForStatusColor($color) {
		$allObjects = static::create()->find();
		$wantedColorIds = [];
		foreach ($allObjects as $object) {
			if ($object->statusColor() == $color) {
				$wantedColorIds[] = $object->getId();
			}
		}
		return new Criterion($this, ProjectPeer::ID, $wantedColorIds, Criteria::IN);
	}

	function filterByStatusColor($color) {
		return $this->add($this->criterionForStatusColor($color));
	}

} // ProjectQuery
