<?php


class ProjectsShowAction extends BaseAction {

	function exec() {
		parent::exec();

		$this->smarty->assign('moduleConfig', Common::getModuleConfiguration('Projects'));

		if (!empty($_GET['positionId'])) {
			$position = PositionQuery::create()->findPK($_GET['positionId']);
			$this->smarty->assign('position', $position);
			if (!empty($_GET['color']))
				$projects = $position->getProjectsByStatusColor($_GET['color']);
			else
				$projects = $position->getAllProjectsWithDescendants();
		}
		else if(!empty($_GET['objectiveId'])) {
			$objective = ObjectiveQuery::create()->findPK($_GET['objectiveId']);
			$this->smarty->assign("objective", $objective);
			if (!empty($_GET['color']))
				$projects = $objective->getProjectsByStatusColor($_GET['color']);
			else
				$projects = $objective->getAllProjects();
		}
		else if(!empty($_GET['policyGuidelineId'])) {
			$policyGuideline = PolicyGuidelineQuery::create()->findPK($_GET['policyGuidelineId']);
			$this->smarty->assign("policyGuideline", $policyGuideline);
			if (!empty($_GET['color']))
				$projects = $policyGuideline->getProjectsByStatusColor($_GET['color']);
			else
				$projects = $policyGuideline->getAllProjects();
		}
		$this->smarty->assign('positions', PositionQuery::create()->find());
		$this->smarty->assign("projects", $projects);
	}

}
