<?php

class ProjectsDoEditAction extends BaseDoEditAction {

	function __construct($entityClassName = 'Project') {
		parent::__construct($entityClassName);
	}

	function preUpdate() {
		parent::preUpdate();

		 if (!is_null($_POST['params']['budget']))
		 //$_POST['params']['budget'] = Common::convertToMysqlNumericFormat($_POST['params']['budget']);
		 $_POST['params']['budget'] = str_replace(',', '.', $_POST['params']['budget']);
		 
		if (!is_null($_POST['params']['budgetRequested']))
			$_POST['params']['budgetRequested'] = Common::convertToMysqlNumericFormat($_POST['params']['budgetRequested']);
		if (!is_null($_POST['params']['budgetSanctioned']))
			$_POST['params']['budgetSanctioned'] = Common::convertToMysqlNumericFormat($_POST['params']['budgetSanctioned']);
		if (!is_null($_POST['params']['exchangeRate']))
			$_POST['params']['exchangeRate'] = Common::convertToMysqlNumericFormat($_POST['params']['exchangeRate']);
	}

	function postSave() {
		parent::postSave();

		$this->smarty->assign('priorityTypes', Project::getPriorities());
		$this->smarty->assign('positions', PositionQuery::create()->find());
		$this->smarty->assign('minorChanges', ConfigModule::get('projects', 'useMinorChanges'));
		// Esta funcion utiliza el criteria que esta en el objectivepeer, no se si se pasa todo al query
		//$this->smarty->assign('objectives', ObjectivePeer::getAllFiltered());
		$this->smarty->assign('objectives', ObjectiveQuery::create()->find());

		// Caso edicion desde show.
		if (isset($_GET['show'])) {
			$this->smarty->assign('show',1);
			// Para menu de navegacion.
			// TODO : Mover esto a smarty.
			$this->smarty->assign('objective',$this->entity->getObjective());
			$this->smarty->assign('dependency',$this->entity->getObjective()->getAffiliate());
		}

		$this->smarty->assign('fromObjectiveId',$_REQUEST['fromObjectiveId']);
		$this->smarty->assign('includeJQuery', true);

		if ($this->entity->getIsConstruction()) {
			// Si se edita, el proyecto tiene que tener una construccion asociada.
			if ($_POST['action'] == 'edit')
				$construction = ConstructionQuery::create()->findOneByProyectid($this->entity->getId());
			if (!$construction || $_POST['action'] == 'create')
				$construction = Construction::createFromProject($this->entity);

			$constructionParams = $_POST['construction']['params'];
			$construction->fromArray($constructionParams, BasePeer::TYPE_FIELDNAME);
			$construction->save();
		}

		if ($_REQUEST['return'] == 'construction-list') {
			$this->forwardName = 'success-edit-construction';
		} else {
			if ($_POST['action'] == 'create' && $_POST['params']['isConstruction'])
				$this->forwardName = 'success-edit-construction';
		}
	}

}
