<?php

class ProjectsActivitiesShowAction extends BaseAction {

	function exec() {
		parent::exec();

		$this->smarty->assign('moduleConfig', Common::getModuleConfiguration('Projects'));

		if (!empty($_GET['projectid'])) {
			$project = ProjectQuery::create()->findPK($_GET['projectid']);
			$this->smarty->assign('project', $project);

			$order = ProjectActivityQuery::create()
				->orderByPlannedStart(Criteria::ASC)
				->orderByPlannedEnd(Criteria::ASC);

			if (!empty($_GET['color'])) {
				$activities = $project->getActivitiesByStatusColor($_GET['color'], $order);
			} else {
				$activities = $project->getAllActivities($order);
			}
		}
		$this->smarty->assign("activities", $activities);
	}

}
