<?php
/**
 * ProjectsActivitiesListAction
 *
 * Listado de actividades de un proyecto extendiendo BaseListAction
 *
 * @package projects
 * @author Pais Digital
 * @copyright Copyright (c) 2016, Egytca
 */

class ProjectsActivitiesListAction extends BaseListAction {

	function __construct($entityClassName = 'ProjectActivity') {
		parent::__construct($entityClassName);
	}

	function preList() {
		parent::preList();

		if (!empty($_GET['filters']['dateFrom']))
			$this->query->filterByDateFrom($_GET['filters']['dateFrom']);
		
		if (!empty($_GET['filters']['dateTo']))
			$this->query->filterByDateTo($_GET['filters']['dateTo']);

		if (!empty($_GET['filters']['status']))
			$this->query->filterByStatus($_GET['filters']['status']);		

		// filtro que incluye dependencias
		// es importante controlar que venga el responsibleCode porque el findOneByCode, va a devolver un resultado
		// por mas que no se le haya pasado nada.
		if (!empty($_GET['filters']['includeDependents']) && !empty($_GET['filters']['responsibleCode'])) {
			
			$position = PositionQuery::create()->findOneByCode($_GET['filters']['responsibleCode']);			
			
			// filtro por la dependencia del proyecto padre de la actividad.
			$this->query->useProjectQuery()
							->filterByResponsiblecode($position->getCodeWithDescendants(), Criteria::IN)
						->endUse();

			// elimino filtro por position.
			unset($this->filters['responsibleCode']);
		}

		$this->query->orderByPlannedstart(Criteria::ASC);
		$this->query->orderByPlannedend(Criteria::ASC);
	}

	function postList() {
		parent::postList();

		if ($this->filters['fromProjects']){
			$project = ProjectQuery::create()->findOneById($this->filters['projectId']);
			if (is_object($project))
				$this->smarty->assign("parentObject",$project);
		}

		$this->smarty->assign("positions",PositionQuery::create()->find());
		$this->smarty->assign('includeJQuery', true);
	}

}
