<?php

require_once 'ProjectActivityYearsUnfilteredQuery.php';

use Egytca\Planning\YearsFilteredSelectAction;


class ProjectsActivitiesEditAction extends BaseSelectAction {

	use YearsFilteredSelectAction;


	function __construct($entityClassName = 'ProjectActivity') {
		parent::__construct($entityClassName);
	}

	function postSelect() {
		parent::postSelect();

		$this->smarty->assign('includeJQuery', true);

		if (!empty($_GET['id'])) {
			// Voy a editar un activity
			$this->smarty->assign('action', 'edit');
		} else {
			// Voy a crear un activity
			$this->entity->setStartingYear($_SESSION['planning']['startingYear']);
			$this->entity->setEndingYear($_SESSION['planning']['endingYear']);

			if (!empty($this->filters['projectid']))
				$this->entity->setProjectId($this->filters['projectid']);
			if (!empty($_GET['fromProjectsList']))
				$this->entity->setProjectId($_GET['fromProjectsList']);

			$this->smarty->assign('action', 'create');
		}

		$this->entity->prepareProjectsAndObjectives($this->smarty, $this->filters, $this->entity);
		Project::prepareDocuments($this->smarty);
	}

	protected function createYearsUnfilteredQuery() {
		return ProjectActivityYearsUnfilteredQuery::create();
	}

}
