<?php


/**
 * Base class that represents a query for the 'panel_missionUpdate' table.
 *
 * Base de Actualizaciones de Misiones
 *
 * @method MissionUpdateQuery orderByMissionid($order = Criteria::ASC) Order by the missionId column
 * @method MissionUpdateQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method MissionUpdateQuery orderByUsername($order = Criteria::ASC) Order by the username column
 * @method MissionUpdateQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 *
 * @method MissionUpdateQuery groupByMissionid() Group by the missionId column
 * @method MissionUpdateQuery groupByDatetime() Group by the datetime column
 * @method MissionUpdateQuery groupByUsername() Group by the username column
 * @method MissionUpdateQuery groupByUserid() Group by the userId column
 *
 * @method MissionUpdateQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method MissionUpdateQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method MissionUpdateQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method MissionUpdateQuery leftJoinMission($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mission relation
 * @method MissionUpdateQuery rightJoinMission($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mission relation
 * @method MissionUpdateQuery innerJoinMission($relationAlias = null) Adds a INNER JOIN clause to the query using the Mission relation
 *
 * @method MissionUpdateQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method MissionUpdateQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method MissionUpdateQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method MissionUpdate findOne(PropelPDO $con = null) Return the first MissionUpdate matching the query
 * @method MissionUpdate findOneOrCreate(PropelPDO $con = null) Return the first MissionUpdate matching the query, or a new MissionUpdate object populated from the query conditions when no match is found
 *
 * @method MissionUpdate findOneByMissionid(int $missionId) Return the first MissionUpdate filtered by the missionId column
 * @method MissionUpdate findOneByDatetime(string $datetime) Return the first MissionUpdate filtered by the datetime column
 * @method MissionUpdate findOneByUsername(string $username) Return the first MissionUpdate filtered by the username column
 * @method MissionUpdate findOneByUserid(int $userId) Return the first MissionUpdate filtered by the userId column
 *
 * @method array findByMissionid(int $missionId) Return MissionUpdate objects filtered by the missionId column
 * @method array findByDatetime(string $datetime) Return MissionUpdate objects filtered by the datetime column
 * @method array findByUsername(string $username) Return MissionUpdate objects filtered by the username column
 * @method array findByUserid(int $userId) Return MissionUpdate objects filtered by the userId column
 *
 * @package    propel.generator.panel.classes.om
 */
abstract class BaseMissionUpdateQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseMissionUpdateQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'MissionUpdate', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new MissionUpdateQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     MissionUpdateQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return MissionUpdateQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof MissionUpdateQuery) {
            return $criteria;
        }
        $query = new MissionUpdateQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   MissionUpdate|MissionUpdate[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = MissionUpdatePeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(MissionUpdatePeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   MissionUpdate A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `MISSIONID`, `DATETIME`, `USERNAME`, `USERID` FROM `panel_missionUpdate` WHERE `MISSIONID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new MissionUpdate();
            $obj->hydrate($row);
            MissionUpdatePeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return MissionUpdate|MissionUpdate[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|MissionUpdate[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MissionUpdatePeer::MISSIONID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MissionUpdatePeer::MISSIONID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the missionId column
     *
     * Example usage:
     * <code>
     * $query->filterByMissionid(1234); // WHERE missionId = 1234
     * $query->filterByMissionid(array(12, 34)); // WHERE missionId IN (12, 34)
     * $query->filterByMissionid(array('min' => 12)); // WHERE missionId > 12
     * </code>
     *
     * @see       filterByMission()
     *
     * @param     mixed $missionid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByMissionid($missionid = null, $comparison = null)
    {
        if (is_array($missionid) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(MissionUpdatePeer::MISSIONID, $missionid, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(MissionUpdatePeer::DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(MissionUpdatePeer::DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionUpdatePeer::DATETIME, $datetime, $comparison);
    }

    /**
     * Filter the query on the username column
     *
     * Example usage:
     * <code>
     * $query->filterByUsername('fooValue');   // WHERE username = 'fooValue'
     * $query->filterByUsername('%fooValue%'); // WHERE username LIKE '%fooValue%'
     * </code>
     *
     * @param     string $username The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByUsername($username = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($username)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $username)) {
                $username = str_replace('*', '%', $username);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(MissionUpdatePeer::USERNAME, $username, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(MissionUpdatePeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(MissionUpdatePeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MissionUpdatePeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query by a related Mission object
     *
     * @param   Mission|PropelObjectCollection $mission The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionUpdateQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByMission($mission, $comparison = null)
    {
        if ($mission instanceof Mission) {
            return $this
                ->addUsingAlias(MissionUpdatePeer::MISSIONID, $mission->getId(), $comparison);
        } elseif ($mission instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionUpdatePeer::MISSIONID, $mission->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByMission() only accepts arguments of type Mission or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mission relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function joinMission($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mission');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mission');
        }

        return $this;
    }

    /**
     * Use the Mission relation Mission object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   MissionQuery A secondary query class using the current class as primary query
     */
    public function useMissionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMission($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mission', 'MissionQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   MissionUpdateQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(MissionUpdatePeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(MissionUpdatePeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   MissionUpdate $missionUpdate Object to remove from the list of results
     *
     * @return MissionUpdateQuery The current query, for fluid interface
     */
    public function prune($missionUpdate = null)
    {
        if ($missionUpdate) {
            $this->addUsingAlias(MissionUpdatePeer::MISSIONID, $missionUpdate->getMissionid(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
