<?php



/**
 * Skeleton subclass for representing a row from the 'panel_contractor' table.
 *
 * Base de Contratistas
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 * @package    propel.generator.panel.classes
 */
class Contractor extends BaseContractor {

	/** the default item name for this class */
	const ITEM_NAME = 'Contractor';
	const CANDIDATE    = 1;
  const PRECLASIFIED = 2;
  const OFFERER      = 3;
  const CONTRACTED   = 4;

  protected static $types = array(
    Contractor::CANDIDATE    => 'Candidate',
    Contractor::PRECLASIFIED => 'Preclasified',
    Contractor::OFFERER      => 'Offerer',
    Contractor::CONTRACTED   => 'Contracted'
  );

  /**
   * Devuelve los tipos de contratista
   */
  public static function getTypes(){
		$activeContractorTypes = ConfigModule::get("contractors","activeContractorTypes");
    $contractorTypes = array_intersect_key(Contractor::$types, $activeContractorTypes);
    return $contractorTypes;
  }

  /**
   * Devuelve los nombres de los tipos de contratista traducidas
   */
  public function getTypesTranslated(){
    $contractorTypes = $this->types;

    foreach(array_keys($contractorTypes) as $key)
      $contractorTypesTranslated[$key] = Common::getTranslation($contractorTypes[$key],'contractors');

    return $contractorTypesTranslated;
  }

} // Contractor
