<?php
/**
 * PanelSendScheduleAction
 *
 */

set_time_limit(720);

require_once 'AlertManager.php';

/**
 * Esta acción está pensada para ser corrida con cron.
 * Para ello se puede usar las siguientes lineas:
 *
 * cd /ruta/del/main/; php Main.php do=panelSendSchedule 1>> schedule_log 2>> schedule_log;
 *
 * Con eso redireccionamos la salida estandar y la de errores al archivo schedule_log.
 *
 * Recordar comentar la linea $manager->setTestMode(); cuando se quiera activar efectivamente.
 */

class PanelSendScheduleAction extends BaseAction {

	private $debugMode = true;

	function exec() {

		$this->debugMode = $_REQUEST['debug'];

		if ( (!$this->debugMode && empty($_POST['do'])) || !Common::getLoggedUser()->isSupervisor()) {
			die('inaccesible');
		}

		if (!$this->debugMode && date('d') > 7) {
			die('Solo disponible durante la primer semana del mes');
		}

		if (parent::exec() === false) {
			return false;
		}

		if ($this->debugMode) {
			echo '<h3 style="color: red;">------ Ejecutando en modo debug ------</h3>';
		}

		$this->template->template = "TemplatePlain.tpl";

		$allRecipients = [];
		$alertManager = new AlertManager();

		$positions = PositionQuery::create()
			->filterByLastVersion()
			->find();

		foreach ($positions as $position) {

			$scheduleMail = $alertManager->createScheduleMail($position);
			if ($scheduleMail === null) {
				continue;
			}

			$allRecipients[] = $scheduleMail->getMailTo();

			if ($this->debugMode) {
				$this->printDebugInfo($position, $scheduleMail);
			} else {
				$result = $scheduleMail->send();
			}
		}

		if ($this->debugMode) {
			die('<h3  style="color: red;">------ Final modo debug ------</h3>');
		}

		$this->smarty->assign('timestamp', new DateTime());
		$this->smarty->assign('recipients', $allRecipients);
	}

	private function printDebugInfo($position, $scheduleMail) {
		echo '<hr>';
		echo '<h2>Calendario para cargo: "'.$position->getName().'"</h2>';
		echo '<h4 style="color: brown;">Email: '.$scheduleMail->getMailTo().'</h4>';
		echo '<h4 style="color: brown;">Asunto: '.$scheduleMail->getSubject().'</h4>';
		echo '<div style="border: 1px dashed gray; padding: 0.5em;">';
		echo $scheduleMail->getBody();
		echo '</div>';
	}
}
