<?php

/**
 * Listado de agenda de compromisos.
 * 
 * @package panel
 */
class PanelMissionListAction extends BaseListAction {

	public function __construct($entityClassName = 'Mission') {
		parent::__construct($entityClassName);
	}

	public function preList() {
		parent::preList();

		$this->smarty->assign("includeJQuery", true);

		// filtro solo los que usuario logeado puede leer
		$loggedUser = Common::getLoggedUser();
		$this->query->filterByUserReadAccess($loggedUser);

		if (!empty($_GET['filters']['fromDate']))
			$this->query->filterByStartdate(Common::convertToMysqlDateFormat($_GET['filters']['fromDate']), Criteria::GREATER_EQUAL);
	
		if (!empty($_GET['filters']['toDate']))
			$this->query->filterByFinishdate(Common::convertToMysqlDateFormat($_GET['filters']['toDate']), Criteria::LESS_EQUAL);

		if (!empty($_GET['filters']['participant'])) {
			$this->query->useMissionParticipantQuery()
							->filterById($_GET['filters']['participant'])
						->endUse();
		}

		unset($this->filters['participant']);
		unset($this->filters['fromDate']);
		unset($this->filters['toDate']);
		
	}
}
