<?php


/**
 * Base class that represents a query for the 'objectives_strategicLog' table.
 *
 * Strategic Objective Log
 *
 * @method StrategicObjectiveLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method StrategicObjectiveLogQuery orderByStrategicid($order = Criteria::ASC) Order by the strategicId column
 * @method StrategicObjectiveLogQuery orderByPolicyguidelineid($order = Criteria::ASC) Order by the policyGuidelineId column
 * @method StrategicObjectiveLogQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method StrategicObjectiveLogQuery orderByDescription($order = Criteria::ASC) Order by the description column
 * @method StrategicObjectiveLogQuery orderByExchangerate($order = Criteria::ASC) Order by the exchangeRate column
 * @method StrategicObjectiveLogQuery orderByUserid($order = Criteria::ASC) Order by the userId column
 * @method StrategicObjectiveLogQuery orderByAffiliateid($order = Criteria::ASC) Order by the affiliateId column
 * @method StrategicObjectiveLogQuery orderByUserbyaffiliatesid($order = Criteria::ASC) Order by the userByAffiliatesId column
 * @method StrategicObjectiveLogQuery orderByUpdated($order = Criteria::ASC) Order by the updated column
 * @method StrategicObjectiveLogQuery orderByOldid($order = Criteria::ASC) Order by the oldId column
 * @method StrategicObjectiveLogQuery orderByChanges($order = Criteria::ASC) Order by the changes column
 * @method StrategicObjectiveLogQuery orderByStartingyear($order = Criteria::ASC) Order by the startingYear column
 * @method StrategicObjectiveLogQuery orderByEndingyear($order = Criteria::ASC) Order by the endingYear column
 *
 * @method StrategicObjectiveLogQuery groupById() Group by the id column
 * @method StrategicObjectiveLogQuery groupByStrategicid() Group by the strategicId column
 * @method StrategicObjectiveLogQuery groupByPolicyguidelineid() Group by the policyGuidelineId column
 * @method StrategicObjectiveLogQuery groupByName() Group by the name column
 * @method StrategicObjectiveLogQuery groupByDescription() Group by the description column
 * @method StrategicObjectiveLogQuery groupByExchangerate() Group by the exchangeRate column
 * @method StrategicObjectiveLogQuery groupByUserid() Group by the userId column
 * @method StrategicObjectiveLogQuery groupByAffiliateid() Group by the affiliateId column
 * @method StrategicObjectiveLogQuery groupByUserbyaffiliatesid() Group by the userByAffiliatesId column
 * @method StrategicObjectiveLogQuery groupByUpdated() Group by the updated column
 * @method StrategicObjectiveLogQuery groupByOldid() Group by the oldId column
 * @method StrategicObjectiveLogQuery groupByChanges() Group by the changes column
 * @method StrategicObjectiveLogQuery groupByStartingyear() Group by the startingYear column
 * @method StrategicObjectiveLogQuery groupByEndingyear() Group by the endingYear column
 *
 * @method StrategicObjectiveLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method StrategicObjectiveLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method StrategicObjectiveLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method StrategicObjectiveLogQuery leftJoinStrategicObjective($relationAlias = null) Adds a LEFT JOIN clause to the query using the StrategicObjective relation
 * @method StrategicObjectiveLogQuery rightJoinStrategicObjective($relationAlias = null) Adds a RIGHT JOIN clause to the query using the StrategicObjective relation
 * @method StrategicObjectiveLogQuery innerJoinStrategicObjective($relationAlias = null) Adds a INNER JOIN clause to the query using the StrategicObjective relation
 *
 * @method StrategicObjectiveLogQuery leftJoinPolicyGuideline($relationAlias = null) Adds a LEFT JOIN clause to the query using the PolicyGuideline relation
 * @method StrategicObjectiveLogQuery rightJoinPolicyGuideline($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PolicyGuideline relation
 * @method StrategicObjectiveLogQuery innerJoinPolicyGuideline($relationAlias = null) Adds a INNER JOIN clause to the query using the PolicyGuideline relation
 *
 * @method StrategicObjectiveLogQuery leftJoinUser($relationAlias = null) Adds a LEFT JOIN clause to the query using the User relation
 * @method StrategicObjectiveLogQuery rightJoinUser($relationAlias = null) Adds a RIGHT JOIN clause to the query using the User relation
 * @method StrategicObjectiveLogQuery innerJoinUser($relationAlias = null) Adds a INNER JOIN clause to the query using the User relation
 *
 * @method StrategicObjectiveLog findOne(PropelPDO $con = null) Return the first StrategicObjectiveLog matching the query
 * @method StrategicObjectiveLog findOneOrCreate(PropelPDO $con = null) Return the first StrategicObjectiveLog matching the query, or a new StrategicObjectiveLog object populated from the query conditions when no match is found
 *
 * @method StrategicObjectiveLog findOneById(int $id) Return the first StrategicObjectiveLog filtered by the id column
 * @method StrategicObjectiveLog findOneByStrategicid(int $strategicId) Return the first StrategicObjectiveLog filtered by the strategicId column
 * @method StrategicObjectiveLog findOneByPolicyguidelineid(int $policyGuidelineId) Return the first StrategicObjectiveLog filtered by the policyGuidelineId column
 * @method StrategicObjectiveLog findOneByName(string $name) Return the first StrategicObjectiveLog filtered by the name column
 * @method StrategicObjectiveLog findOneByDescription(string $description) Return the first StrategicObjectiveLog filtered by the description column
 * @method StrategicObjectiveLog findOneByExchangerate(double $exchangeRate) Return the first StrategicObjectiveLog filtered by the exchangeRate column
 * @method StrategicObjectiveLog findOneByUserid(int $userId) Return the first StrategicObjectiveLog filtered by the userId column
 * @method StrategicObjectiveLog findOneByAffiliateid(int $affiliateId) Return the first StrategicObjectiveLog filtered by the affiliateId column
 * @method StrategicObjectiveLog findOneByUserbyaffiliatesid(int $userByAffiliatesId) Return the first StrategicObjectiveLog filtered by the userByAffiliatesId column
 * @method StrategicObjectiveLog findOneByUpdated(string $updated) Return the first StrategicObjectiveLog filtered by the updated column
 * @method StrategicObjectiveLog findOneByOldid(int $oldId) Return the first StrategicObjectiveLog filtered by the oldId column
 * @method StrategicObjectiveLog findOneByChanges(int $changes) Return the first StrategicObjectiveLog filtered by the changes column
 * @method StrategicObjectiveLog findOneByStartingyear(int $startingYear) Return the first StrategicObjectiveLog filtered by the startingYear column
 * @method StrategicObjectiveLog findOneByEndingyear(int $endingYear) Return the first StrategicObjectiveLog filtered by the endingYear column
 *
 * @method array findById(int $id) Return StrategicObjectiveLog objects filtered by the id column
 * @method array findByStrategicid(int $strategicId) Return StrategicObjectiveLog objects filtered by the strategicId column
 * @method array findByPolicyguidelineid(int $policyGuidelineId) Return StrategicObjectiveLog objects filtered by the policyGuidelineId column
 * @method array findByName(string $name) Return StrategicObjectiveLog objects filtered by the name column
 * @method array findByDescription(string $description) Return StrategicObjectiveLog objects filtered by the description column
 * @method array findByExchangerate(double $exchangeRate) Return StrategicObjectiveLog objects filtered by the exchangeRate column
 * @method array findByUserid(int $userId) Return StrategicObjectiveLog objects filtered by the userId column
 * @method array findByAffiliateid(int $affiliateId) Return StrategicObjectiveLog objects filtered by the affiliateId column
 * @method array findByUserbyaffiliatesid(int $userByAffiliatesId) Return StrategicObjectiveLog objects filtered by the userByAffiliatesId column
 * @method array findByUpdated(string $updated) Return StrategicObjectiveLog objects filtered by the updated column
 * @method array findByOldid(int $oldId) Return StrategicObjectiveLog objects filtered by the oldId column
 * @method array findByChanges(int $changes) Return StrategicObjectiveLog objects filtered by the changes column
 * @method array findByStartingyear(int $startingYear) Return StrategicObjectiveLog objects filtered by the startingYear column
 * @method array findByEndingyear(int $endingYear) Return StrategicObjectiveLog objects filtered by the endingYear column
 *
 * @package    propel.generator.objectives.classes.om
 */
abstract class BaseStrategicObjectiveLogQuery extends \Egytca\Propel\Query
{
    /**
     * Initializes internal state of BaseStrategicObjectiveLogQuery object.
     *
     * @param     string $dbName The dabase name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'application', $modelName = 'StrategicObjectiveLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new StrategicObjectiveLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     StrategicObjectiveLogQuery|Criteria $criteria Optional Criteria to build the query from
     *
     * @return StrategicObjectiveLogQuery
     */
    public static function create($modelAlias = null, $criteria = null)
    {
        if ($criteria instanceof StrategicObjectiveLogQuery) {
            return $criteria;
        }
        $query = new StrategicObjectiveLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return   StrategicObjectiveLog|StrategicObjectiveLog[]|mixed the result, formatted by the current formatter
     */
    public function findPk($key, $con = null)
    {
        if ($key === null) {
            return null;
        }
        if ((null !== ($obj = StrategicObjectiveLogPeer::getInstanceFromPool((string) $key))) && !$this->formatter) {
            // the object is alredy in the instance pool
            return $obj;
        }
        if ($con === null) {
            $con = Propel::getConnection(StrategicObjectiveLogPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        if ($this->formatter || $this->modelAlias || $this->with || $this->select
         || $this->selectColumns || $this->asColumns || $this->selectModifiers
         || $this->map || $this->having || $this->joins) {
            return $this->findPkComplex($key, $con);
        } else {
            return $this->findPkSimple($key, $con);
        }
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return   StrategicObjectiveLog A model object, or null if the key is not found
     * @throws   PropelException
     */
    protected function findPkSimple($key, $con)
    {
        $sql = 'SELECT `ID`, `STRATEGICID`, `POLICYGUIDELINEID`, `NAME`, `DESCRIPTION`, `EXCHANGERATE`, `USERID`, `AFFILIATEID`, `USERBYAFFILIATESID`, `UPDATED`, `OLDID`, `CHANGES`, `STARTINGYEAR`, `ENDINGYEAR` FROM `objectives_strategicLog` WHERE `ID` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(PDO::FETCH_NUM)) {
            $obj = new StrategicObjectiveLog();
            $obj->hydrate($row);
            StrategicObjectiveLogPeer::addInstanceToPool($obj, (string) $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     PropelPDO $con A connection object
     *
     * @return StrategicObjectiveLog|StrategicObjectiveLog[]|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($stmt);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     PropelPDO $con an optional connection object
     *
     * @return PropelObjectCollection|StrategicObjectiveLog[]|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, $con = null)
    {
        if ($con === null) {
            $con = Propel::getConnection($this->getDbName(), Propel::CONNECTION_READ);
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $stmt = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($stmt);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StrategicObjectiveLogPeer::ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StrategicObjectiveLogPeer::ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id) && null === $comparison) {
            $comparison = Criteria::IN;
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::ID, $id, $comparison);
    }

    /**
     * Filter the query on the strategicId column
     *
     * Example usage:
     * <code>
     * $query->filterByStrategicid(1234); // WHERE strategicId = 1234
     * $query->filterByStrategicid(array(12, 34)); // WHERE strategicId IN (12, 34)
     * $query->filterByStrategicid(array('min' => 12)); // WHERE strategicId > 12
     * </code>
     *
     * @see       filterByStrategicObjective()
     *
     * @param     mixed $strategicid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByStrategicid($strategicid = null, $comparison = null)
    {
        if (is_array($strategicid)) {
            $useMinMax = false;
            if (isset($strategicid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::STRATEGICID, $strategicid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($strategicid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::STRATEGICID, $strategicid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::STRATEGICID, $strategicid, $comparison);
    }

    /**
     * Filter the query on the policyGuidelineId column
     *
     * Example usage:
     * <code>
     * $query->filterByPolicyguidelineid(1234); // WHERE policyGuidelineId = 1234
     * $query->filterByPolicyguidelineid(array(12, 34)); // WHERE policyGuidelineId IN (12, 34)
     * $query->filterByPolicyguidelineid(array('min' => 12)); // WHERE policyGuidelineId > 12
     * </code>
     *
     * @see       filterByPolicyGuideline()
     *
     * @param     mixed $policyguidelineid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByPolicyguidelineid($policyguidelineid = null, $comparison = null)
    {
        if (is_array($policyguidelineid)) {
            $useMinMax = false;
            if (isset($policyguidelineid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($policyguidelineid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $policyguidelineid, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%'); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $name)) {
                $name = str_replace('*', '%', $name);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::NAME, $name, $comparison);
    }

    /**
     * Filter the query on the description column
     *
     * Example usage:
     * <code>
     * $query->filterByDescription('fooValue');   // WHERE description = 'fooValue'
     * $query->filterByDescription('%fooValue%'); // WHERE description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $description The value to use as filter.
     *              Accepts wildcards (* and % trigger a LIKE)
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByDescription($description = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($description)) {
                $comparison = Criteria::IN;
            } elseif (preg_match('/[\%\*]/', $description)) {
                $description = str_replace('*', '%', $description);
                $comparison = Criteria::LIKE;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::DESCRIPTION, $description, $comparison);
    }

    /**
     * Filter the query on the exchangeRate column
     *
     * Example usage:
     * <code>
     * $query->filterByExchangerate(1234); // WHERE exchangeRate = 1234
     * $query->filterByExchangerate(array(12, 34)); // WHERE exchangeRate IN (12, 34)
     * $query->filterByExchangerate(array('min' => 12)); // WHERE exchangeRate > 12
     * </code>
     *
     * @param     mixed $exchangerate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByExchangerate($exchangerate = null, $comparison = null)
    {
        if (is_array($exchangerate)) {
            $useMinMax = false;
            if (isset($exchangerate['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::EXCHANGERATE, $exchangerate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($exchangerate['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::EXCHANGERATE, $exchangerate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::EXCHANGERATE, $exchangerate, $comparison);
    }

    /**
     * Filter the query on the userId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserid(1234); // WHERE userId = 1234
     * $query->filterByUserid(array(12, 34)); // WHERE userId IN (12, 34)
     * $query->filterByUserid(array('min' => 12)); // WHERE userId > 12
     * </code>
     *
     * @see       filterByUser()
     *
     * @param     mixed $userid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUserid($userid = null, $comparison = null)
    {
        if (is_array($userid)) {
            $useMinMax = false;
            if (isset($userid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::USERID, $userid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::USERID, $userid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::USERID, $userid, $comparison);
    }

    /**
     * Filter the query on the affiliateId column
     *
     * Example usage:
     * <code>
     * $query->filterByAffiliateid(1234); // WHERE affiliateId = 1234
     * $query->filterByAffiliateid(array(12, 34)); // WHERE affiliateId IN (12, 34)
     * $query->filterByAffiliateid(array('min' => 12)); // WHERE affiliateId > 12
     * </code>
     *
     * @param     mixed $affiliateid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByAffiliateid($affiliateid = null, $comparison = null)
    {
        if (is_array($affiliateid)) {
            $useMinMax = false;
            if (isset($affiliateid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::AFFILIATEID, $affiliateid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($affiliateid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::AFFILIATEID, $affiliateid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::AFFILIATEID, $affiliateid, $comparison);
    }

    /**
     * Filter the query on the userByAffiliatesId column
     *
     * Example usage:
     * <code>
     * $query->filterByUserbyaffiliatesid(1234); // WHERE userByAffiliatesId = 1234
     * $query->filterByUserbyaffiliatesid(array(12, 34)); // WHERE userByAffiliatesId IN (12, 34)
     * $query->filterByUserbyaffiliatesid(array('min' => 12)); // WHERE userByAffiliatesId > 12
     * </code>
     *
     * @param     mixed $userbyaffiliatesid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUserbyaffiliatesid($userbyaffiliatesid = null, $comparison = null)
    {
        if (is_array($userbyaffiliatesid)) {
            $useMinMax = false;
            if (isset($userbyaffiliatesid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($userbyaffiliatesid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::USERBYAFFILIATESID, $userbyaffiliatesid, $comparison);
    }

    /**
     * Filter the query on the updated column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdated('2011-03-14'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated('now'); // WHERE updated = '2011-03-14'
     * $query->filterByUpdated(array('max' => 'yesterday')); // WHERE updated > '2011-03-13'
     * </code>
     *
     * @param     mixed $updated The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByUpdated($updated = null, $comparison = null)
    {
        if (is_array($updated)) {
            $useMinMax = false;
            if (isset($updated['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::UPDATED, $updated['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($updated['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::UPDATED, $updated['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::UPDATED, $updated, $comparison);
    }

    /**
     * Filter the query on the oldId column
     *
     * Example usage:
     * <code>
     * $query->filterByOldid(1234); // WHERE oldId = 1234
     * $query->filterByOldid(array(12, 34)); // WHERE oldId IN (12, 34)
     * $query->filterByOldid(array('min' => 12)); // WHERE oldId > 12
     * </code>
     *
     * @param     mixed $oldid The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByOldid($oldid = null, $comparison = null)
    {
        if (is_array($oldid)) {
            $useMinMax = false;
            if (isset($oldid['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::OLDID, $oldid['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldid['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::OLDID, $oldid['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::OLDID, $oldid, $comparison);
    }

    /**
     * Filter the query on the changes column
     *
     * Example usage:
     * <code>
     * $query->filterByChanges(1234); // WHERE changes = 1234
     * $query->filterByChanges(array(12, 34)); // WHERE changes IN (12, 34)
     * $query->filterByChanges(array('min' => 12)); // WHERE changes > 12
     * </code>
     *
     * @param     mixed $changes The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByChanges($changes = null, $comparison = null)
    {
        if (is_array($changes)) {
            $useMinMax = false;
            if (isset($changes['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::CHANGES, $changes['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($changes['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::CHANGES, $changes['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::CHANGES, $changes, $comparison);
    }

    /**
     * Filter the query on the startingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByStartingyear(1234); // WHERE startingYear = 1234
     * $query->filterByStartingyear(array(12, 34)); // WHERE startingYear IN (12, 34)
     * $query->filterByStartingyear(array('min' => 12)); // WHERE startingYear > 12
     * </code>
     *
     * @param     mixed $startingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByStartingyear($startingyear = null, $comparison = null)
    {
        if (is_array($startingyear)) {
            $useMinMax = false;
            if (isset($startingyear['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::STARTINGYEAR, $startingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startingyear['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::STARTINGYEAR, $startingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::STARTINGYEAR, $startingyear, $comparison);
    }

    /**
     * Filter the query on the endingYear column
     *
     * Example usage:
     * <code>
     * $query->filterByEndingyear(1234); // WHERE endingYear = 1234
     * $query->filterByEndingyear(array(12, 34)); // WHERE endingYear IN (12, 34)
     * $query->filterByEndingyear(array('min' => 12)); // WHERE endingYear > 12
     * </code>
     *
     * @param     mixed $endingyear The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function filterByEndingyear($endingyear = null, $comparison = null)
    {
        if (is_array($endingyear)) {
            $useMinMax = false;
            if (isset($endingyear['min'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::ENDINGYEAR, $endingyear['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($endingyear['max'])) {
                $this->addUsingAlias(StrategicObjectiveLogPeer::ENDINGYEAR, $endingyear['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StrategicObjectiveLogPeer::ENDINGYEAR, $endingyear, $comparison);
    }

    /**
     * Filter the query by a related StrategicObjective object
     *
     * @param   StrategicObjective|PropelObjectCollection $strategicObjective The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByStrategicObjective($strategicObjective, $comparison = null)
    {
        if ($strategicObjective instanceof StrategicObjective) {
            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::STRATEGICID, $strategicObjective->getId(), $comparison);
        } elseif ($strategicObjective instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::STRATEGICID, $strategicObjective->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByStrategicObjective() only accepts arguments of type StrategicObjective or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the StrategicObjective relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function joinStrategicObjective($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('StrategicObjective');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'StrategicObjective');
        }

        return $this;
    }

    /**
     * Use the StrategicObjective relation StrategicObjective object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   StrategicObjectiveQuery A secondary query class using the current class as primary query
     */
    public function useStrategicObjectiveQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinStrategicObjective($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'StrategicObjective', 'StrategicObjectiveQuery');
    }

    /**
     * Filter the query by a related PolicyGuideline object
     *
     * @param   PolicyGuideline|PropelObjectCollection $policyGuideline The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByPolicyGuideline($policyGuideline, $comparison = null)
    {
        if ($policyGuideline instanceof PolicyGuideline) {
            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $policyGuideline->getId(), $comparison);
        } elseif ($policyGuideline instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::POLICYGUIDELINEID, $policyGuideline->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPolicyGuideline() only accepts arguments of type PolicyGuideline or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PolicyGuideline relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function joinPolicyGuideline($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PolicyGuideline');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PolicyGuideline');
        }

        return $this;
    }

    /**
     * Use the PolicyGuideline relation PolicyGuideline object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   PolicyGuidelineQuery A secondary query class using the current class as primary query
     */
    public function usePolicyGuidelineQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPolicyGuideline($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PolicyGuideline', 'PolicyGuidelineQuery');
    }

    /**
     * Filter the query by a related User object
     *
     * @param   User|PropelObjectCollection $user The related object(s) to use as filter
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return   StrategicObjectiveLogQuery The current query, for fluid interface
     * @throws   PropelException - if the provided filter is invalid.
     */
    public function filterByUser($user, $comparison = null)
    {
        if ($user instanceof User) {
            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::USERID, $user->getId(), $comparison);
        } elseif ($user instanceof PropelObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StrategicObjectiveLogPeer::USERID, $user->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByUser() only accepts arguments of type User or PropelCollection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the User relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function joinUser($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('User');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'User');
        }

        return $this;
    }

    /**
     * Use the User relation User object
     *
     * @see       useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return   UserQuery A secondary query class using the current class as primary query
     */
    public function useUserQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinUser($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'User', 'UserQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   StrategicObjectiveLog $strategicObjectiveLog Object to remove from the list of results
     *
     * @return StrategicObjectiveLogQuery The current query, for fluid interface
     */
    public function prune($strategicObjectiveLog = null)
    {
        if ($strategicObjectiveLog) {
            $this->addUsingAlias(StrategicObjectiveLogPeer::ID, $strategicObjectiveLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

}
